#INCLUDE "CLASSY2.CH"
#INCLUDE "FUNCKY.CH"


#DEFINE DEFAULT_INITIAL_COUNTER 1


//  Class Ŀ
//          Name: CntNumeric                                                 
//   Description:                                                            
//        Author: Chris Pels                                                 
//  Date created: 05-03-94              Date updated: 05-03-94              
//  Time created: 01:22:06pm            Time updated: 01:22:06pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//  Parent class: Counter                                                    
//      See Also:                                                            
// 
//       History: $History: CNTNUM.PRG $
/**/
/******************  Version 3  ******************/
/*User: Chris        Date: 5/03/94    Time: 1:28p */
/*Updated in /GBTLib*/
/*Added History keyword for version control and changed copyright to GBT.*/
/**/
/******************  Version 2  ******************/
/*User: Chris        Date: 5/02/94    Time: 3:09p */
/*Updated in /GBTLib*/
/*Standardized and improved documentation.*/
/**/
/******************  Version 1  ******************/
/*User: Chris        Date: 4/13/94    Time: 3:36p */
/*Updated in /GBTLib*/
/*Initial version.*/
//
CREATE CLASS CntNumeric INHERIT Counter

PROTECTED:

	VAR nCounter                         // Current counter value.

EXPORT:

	METHOD Init                          // Initialize class.
	METHOD Inc                           // Increment the counter.
	METHOD Dec                           // Decrement the counter.
	METHOD Assign                        // Set the counter.
	METHOD Get                           // Get current counter value.
	METHOD Reset                         // Reset counter to standard default.

END CLASS

//  Method Ŀ
//          Name: Init()                                                     
//   Description: Initialize the class.                                      
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:18:49pm            Time updated: 03:18:49pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: nInitial                                                   
//  Return Value: (self)                                                     
//      See Also:                                                            
// 
METHOD Init( nInitial )

	DEFAULT nInitial TO DEFAULT_INITIAL_COUNTER // Initial counter is 1.
	::Assign( nInitial )

RETURN (self)

//  Method Ŀ
//          Name: Inc()                                                
//   Description: Increment the counter.                                     
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:18:41pm            Time updated: 03:18:41pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: None                                                       
//  Return Value: (self)                                                     
//      See Also:                                                            
// 
METHOD Inc( nIncrement )

	DEFAULT nIncrement TO 1              // Increment by 1 by default.

	::nCounter += nIncrement

RETURN ( ::nCounter )

//  Method Ŀ
//          Name: Dec()                                                
//   Description: Decrement the counter.                                     
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:18:34pm            Time updated: 03:18:34pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: None                                                       
//  Return Value: (self)                                                     
//      See Also:                                                            
// 
METHOD Dec( nDecrement )

	DEFAULT nDecrement TO 1              // Decrement by 1 by default.

	::nCounter -= nDecrement

RETURN ( ::nCounter )

//  Method Ŀ
//          Name: Assign()                                               
//   Description: Set the current value of the counter.                      
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:18:25pm            Time updated: 03:18:25pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: nCounter                                                   
//  Return Value: (self)                                                     
//      See Also:                                                            
// 
METHOD Assign( nCounter )

	ASSERT( valtype(nCounter)=="N" )
	::nCounter := nCounter

RETURN (self)

//  Method Ŀ
//          Name: Get()                                               
//   Description: Return current counter value.                              
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:18:12pm            Time updated: 03:18:12pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: nCounter                                                   
//  Return Value: @( nCounter @)                                              
//      See Also:                                                            
// 
METHOD Get( nCounter )
RETURN( ::nCounter )

//  Method Ŀ
//          Name: Reset()                                                    
//   Description: Reset counter to standard default.                         
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 12:21:42pm            Time updated: 12:21:42pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: None                                                       
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Reset()
	::nCounter := DEFAULT_INITIAL_COUNTER
RETURN (self)
