#INCLUDE "CLASSY2.CH"
#INCLUDE "FUNCKY.CH"

//  Class Ŀ
//          Name: CntASCII                                                   
//   Description: Incremental counter using ASCII character set.             
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 02:57:00pm            Time updated: 02:57:00pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//  Parent class: Counter                                                    
//      See Also:                                                            
// 
//       History: $History: CNTASCII.PRG $
/**/
/******************  Version 3  ******************/
/*User: Chris        Date: 5/03/94    Time: 1:28p */
/*Updated in /GBTLib*/
/*Added History keyword for version control and changed copyright to GBT.*/
/**/
/******************  Version 2  ******************/
/*User: Chris        Date: 5/02/94    Time: 3:09p */
/*Updated in /GBTLib*/
/*Standardized and improved documentation.*/
//

CREATE CLASS CntASCII INHERIT Counter

PROTECTED:

	VAR cCounter                         // Character based counter.
	VAR nLength                          // Length of counter.

	MESSAGE LastASCII IS DEFERRED        // Determines last ASCII character.
	MESSAGE NextASCII IS DEFERRED        // Next ASCII character.
	METHOD ASCInc                        // Increments ASCII string.

EXPORT:

	MESSAGE Dec IS NULL            // Decrement counter.
	MESSAGE Reset IS DEFERRED         // Resets to first ASCII character.
	METHOD Get                    // Get current counter.
	METHOD Inc                     // Increment counter.
	METHOD Init
	METHOD Assign                    // Set counter.

END CLASS

//  Method Ŀ
//          Name: Init()                                                     
//   Description: Initializes ASCII counter class.                           
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 02:59:19pm            Time updated: 02:59:19pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cInitial                                                   
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Init( cInitial ),()

	DEFAULT cInitial TO ::Reset()     // Initial counter value.
	::Assign( cInitial )             // Set counter's initial value.

RETURN (self)

//  Method Ŀ
//          Name: Inc()                                                
//   Description: Increments counter.                                        
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 02:59:36pm            Time updated: 02:59:36pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: nIncrement                                                 
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Inc( nIncrement )
	//MORE THAN INCREMENT OF 1 NOT DONE YET.
	::cCounter := ::ASCInc( ::cCounter, ::nLength )
RETURN (self)

//  Method Ŀ
//          Name: ASCInc()                                                   
//   Description: Increments counter one ASCII value.                        
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:00:03pm            Time updated: 03:00:03pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cString                                                    
//              : nPosition                                                  
//  Return Value: ( cString )                                              
//      See Also:                                                            
// 
METHOD ASCInc( cString, nPosition )

	Local ;
		cChar                              // Single character to be processed.

	ASSERT( valtype(cString)=="C" )      // Development mode type checking.
	ASSERT( valtype(nPosition)=="N")

	cChar := ;                           // Single character.
		substr(cString,nPosition,1)        // Extraction of character from string.

	IF ::LastASCII( cChar )              // Last ASCII character.

		cString :=;                        // Assign to string.
			stuff(;                          // Insert into string.
			cString,;
			nPosition,;                      // At position...
			1,;                              // Delete character there.
			::Reset();                    // Reset to first ASCII char in set.
			)

		IF nPosition!=1                    // Not in first position.

			cString :=;
				AscInc(;                       // Increment ASCII value.
				cString,;
				(nPosition-1);                 // Character in next position to the left.
				)

		END

	ELSE                                 // Not last ASCII character.

		cString :=;                        // Assign to string.
			stuff(;                          // Insert into string.
			cString,;
			nPosition,;                      // At position...
			1,;                              // Delete character there.
			::NextASCII( cChar);
			)

	END

RETURN ( cString )                     // Return incremented string.

//  Method Ŀ
//          Name: Assign()                                               
//   Description: Sets the counter to a value.                               
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:01:21pm            Time updated: 03:01:21pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cCounter                                                   
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Assign( cCounter )

	ASSERT( valtype( cCounter )=="C" )
	::cCounter := cCounter
	::nLength := len( ::cCounter )

RETURN (self)

//  Method Ŀ
//          Name: Get()                                               
//   Description: Returns the current counter value.                         
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:01:32pm            Time updated: 03:01:32pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: None                                                       
//  Return Value: @( ::cCounter @)                                             
//      See Also:                                                            
// 
METHOD Get()
RETURN ( ::cCounter )
