/* 
   This prg generates header files to be included with prgs using
   AutoMem for Clipper. Compile and link with all the switches.

   Syntax: AUTOCH [ DBFname ] [ Outfile ]

   -  AutoCh will popup a list of dbfs in the current dir if you 
      don't pass a dbf name.  

   -  The default outfile name is ALIAS.CH.

   -  The program will warn you if you are about to overwrite an existing file.

   Author : Kim Taulbee [CS: 71021,3340]
   Copyright (c) 1992, Intelligent Software Solutions, All Rights reserved.
*/

//-------------------------------------
FUNCTION  Autoch( cDBF, cOutFile )
   LOCAL aM, i, aDir, nHandle, cBuffer  
   MEMVAR      Getlist
   CLS

   // Handle whatever comes in the way of params
   IF !EMPTY( cDBF )
      cDBF := IF( !RIGHT(cDBF,4)='.DBF', cDBF+'.DBF', UPPER(cDBF) )
   ENDIF
   IF cDBF == NIL .OR. !FILE( cDBF )
      // Popup list of dbfs in current dir
      IF EMPTY( cDBF := GetDbf() )
	 RETURN( NIL )
      ENDIF
   ENDIF

   // Open dbf
   Memory(-1)
   USE (cDBF) NEW
   
   // if outfile name not passed, name it after alias
   cOutFile := IF( cOutFile == NIL, ALIAS() +'.CH', UPPER(cOutFile) )

   // Check to make sure you don't overwrite existing file
   WHILE FILE( cOutFile )
      Warnbeep()  
      IF ALERT( "File Exists, Overwrite?", {"No","Yes"} ) == 1
	 // Get alternate outfile name.
	 @ 11,12 SAY 'Enter filename to use:' GET cOutFile
	 SETCURSOR(1)
	 READ
	 SETCURSOR(0)
	 CLS
      ELSE
	 EXIT
      ENDIF
   ENDDO    

   @ 11, 00 SAY PADC( 'Creating ' + cOutFile, 80 )
   Bip()

   // Credits and pertinate info
   cBuffer :=  '/*' + CHR(13)+CHR(10)                                               +;
	       '  This file generated by AutoCh for use with Automem for Clipper.'  +;   
	       CHR(13)+CHR(10)                                                      +;
	       '  "AutoMem for Clipper" system written by Kim Taulbee. '            +;
	       '[CS: 7102,3340] '                                                   +;
	       CHR(13)+CHR(10)                                                      +;
	       '  Copyright (C) 1992, Intelligent Software Solutions, '             +;
	       'All rights Reserved.'                                               +; 
	       CHR(13)+CHR(10) + CHR(13)+CHR(10)                                    +;
	       '  Database: ' + cDBF     + CHR(13)+CHR(10)                          +;    
	       '  Date: ' + DTOC(DATE()) + CHR(13)+CHR(10)                          +;
	       '  Time: ' + TIME()       + CHR(13)+CHR(10)  + '*/'                  +;   
	       CHR(13)+CHR(10) + CHR(13)+CHR(10)        

   // Fill buffer with #define statement + linefeed for each field in dbf.    
   FOR i := 1 TO FCOUNT()
      cBuffer :=  cBuffer + '#define    p'   +;
		  PADR(FIELDNAME(i),16)      +;
		  STR(i)+CHR(13)+CHR(10)       
   NEXT
   cBuffer := cBuffer + CHR(13)+CHR(10) + '// EOF '+cOutFile

   // Create outfile
   nHandle := FCREATE( cOutFile )
   FWRITE( nHandle, cBuffer )
   FCLOSE( nHandle )
   DBCLOSEAREA()   

   // Give a quick look/edit
   Bip()
   IF ALERT( 'View '+cOutFile+'?', {'Yes','No'} ) == 1
      @ 23, 0 SAY REPL(CHR(196), 80)
      @ 24, 1 SAY 'MEMOEDIT:  CTRL-W to save changes, ESC to abandon'
      SETCURSOR(1)
      MEMOEDIT( cBuffer, 0,0,22,MAXCOL() )
   ENDIF
   CLS
   RETURN(NIL)

//-------------------------------------
STATIC FUNCTION GetDbf()
   LOCAL cOldScrn := SAVESCREEN(4,10,20,22)     
   LOCAL aDir, aList, cDBF
   LOCAL i, nChoice   
   
   IF FILE( '*.DBF' )
      aDir  := DIRECTORY( '*.DBF' ) 
      aList := ARRAY(LEN(aDir))   
      FOR i := 1 TO LEN( aList )       // Glean dbf names from aDir
	 aList[i] := aDir[i][1]  
      NEXT
      ASORT( aList )                   // Put them in order
   ELSE
      Warnbeep()
      ALERT( "No dbf's in current directory!" )
      RETURN( '' )
   ENDIF

   // List dbfs in current dir
   nChoice := ACHOICE( 4,10,20,22, aList ) 
   cDBF     := IF( nChoice > 0, aList[nChoice], '')
   RESTSCREEN(4,10,20,22, cOldScrn )
   RETURN( cDBF )   

//-------------------------------------
STATIC FUNCTION Warnbeep()
   TONE( 300, 1 )
   TONE( 150, 1 )
RETURN NIL

//------------------------------------- 
STATIC FUNCTION Bip()            // a gentle reminder
    TONE( 3700, 01 )
RETURN NIL

