/*
   ASAP - Another System Analysis Product
   (c) Copyright 1989 - 1991, The Leylan Factor

   distribute freely with this header intact

   compile : clipper <file> /m/n/w
*/

#include "asap.ch"

STATIC nStatRow, nStatCol, nStatLen, nStatWid, cStatHue, cStatTxt, cStatBox
STATIC aStatHdr, aStatMsg, nStatCnt, nStatMax, nStatRnd, nStatMode


FUNCTION StatNew( nRow, nCol, nLen, nWid, cHue, cTxt, cBox )

   nStatRow := nRow
   nStatCol := nCol
   nStatLen := nLen
   nStatWid := nWid
   cStatHue := cHue
   cStatTxt := cTxt
   cStatBox := cBox

   aStatHdr := { "ASAP - System Start  " + DTOC( DATE() ) ,;
                 "                             " ,;
                 "(c) Copyright 1989 - 1991    " ,;
                 "The Leylan Factor            " ,;
                 "                             " ,;
                 "                             " ,;
                 "........... begin ..........." ,;
                 "                             " }

   aStatMsg := { "RAM test active...           " ,;
                 "DISK test active...          " ,;
                 "SERIAL test active...        " ,;
                 "PARALLEL test active...      " ,;
                 "THERMOMETER On...            " ,;
                 "[[[[[[[[[   Hi Mom  ]]]]]]]]]" ,;
                 "RAM collision detected...    " ,;
                 "Auto RAM correction On       " ,;
                 "Auto RAM correction Off      " ,;
                 "Intruder Alert               " ,;
                 "Misplaced track error        " ,;
                 "Data recovered...            " ,;
                 "                             " ,;
                 "Minor sector malfunction...  " ,;
                 "Compressing... please wait   " ,;
                 "                             " ,;
                 "Temperature : STEADY         " ,;
                 "Tolerance exceeded by 10%    " ,;
                 "                             " ,;
                 "                             " ,;
                 "Parallel Port throughput OK  " ,;
                 "                             " ,;
                 "Arithmetic Unit testing...   " ,;
                 "Adding big numbers <ok>      " ,;
                 "Long division test <ok>      " ,;
                 "Multiplication test <ok>     " ,;
                 "Quadratic equation test <ok> " ,;
                 "                             " ,;
                 "Video test 1 ... passed      " ,;
                 "Video test 2 ... passed      " ,;
                 "Video test 3 ... passed      " ,;
                 "                             " ,;
                 "                             " ,;
                 "Acceleration testing         " ,;
                 "                             " ,;
                 "Multi-mode operation         " ,;
                 "                             " ,;
                 "ROM verification and POST    " ,;
                 "                             " ,;
                 "Copying EPROM initialization " ,;
                 "                             " ,;
                 "                             " ,;
                 "DOS IRQ value shifted by 64  " ,;
                 "                             " ,;
                 "Auxilliary byte removed      " ,;
                 "                             " ,;
                 "8-bit verification approved  " ,;
                 "9-bit verification approved  " ,;
                 "                             " ,;
                 "oops ... never mind...       " ,;
                 "                             " ,;
                 "Virtual mode service request " ,;
                 "Floating point failure       " ,;
                 "                             " ,;
                 "Reading data blocks          " ,;
                 "Writing data blocks          " ,;
                 "                             " ,;
                 "Partition 1 contains data    " ,;
                 "                             " ,;
                 "FCB contains TSR reference   " ,;
                 "                             " ,;
                 "Buffered Keyboard Input On   " ,;
                 "Direct Keyboard Input Off    " ,;
                 "                             " ,;
                 "                             " ,;
                 "Memory defragmentation       " ,;
                 "Warning...                   " ,;
                 "                             " ,;
                 "Meaningless macro removed    " ,;
                 "                             " ,;
                 "Engaging printer device      " ,;
                 "Testing graphic characters   " ,;
                 "                             " ,;
                 "Unrecognized OPCODE at 1F2B  " ,;
                 "                             " ,;
                 "    <<<< BEGIN TRACE >>>>    " ,;
                 "     <<<< END TRACE >>>>     " ,;
                 "Synchronization stabilized   " ,;
                 "                             " ,;
                 "Interrupts disabled          " ,;
                 "Interrupts enabled           " ,;
                 "                             " ,;
                 "                             " ,;
                 "System cool down             " ,;
                 "                             " ,;
                 "                             " ,;
                 "E = MC                      " ,;
                 "                             " ,;
                 "Good morning gentlemen       " ,;
                 "I'm the HAL 9000 computer    " ,;
                 "I'd like to sing you a song  " ,;
                 "I'm sorry Dave               " ,;
                 "                             " ,;
                 "How about a game ?           " ,;
                 "Joshua ...                   " ,;
                 "                             " ,;
                 "                             " ,;
                 "                             " ,;
                 "                             " ,;
                 "There was a sailor from Minsk" }

   nStatCnt := 0
   nStatMax := 5
   nStatRnd := Randomize( SECONDS() / 100 )

   nStatMode := PR_STARTUP

   RETURN NIL


FUNCTION StatShow

   @ nStatRow, nStatCol, nStatRow + nStatLen, nStatCol + nStatWid ;
      BOX cStatBox COLOR cStatHue

   @ nStatRow, nStatCol + 2 SAY cStatTxt

   RETURN NIL


FUNCTION StatEvent
   STATIC nCnt := 1

   IF nStatCnt <= nStatMax

      nStatCnt++

   ELSE

      DO CASE

      CASE nStatMode == PR_STARTUP

         StatusSay( aStatHdr[ nCnt ], ;
                    nStatRow, nStatCol, nStatWid, cStatHue, nStatLen )
         nCnt++

         IF nCnt > LEN( aStatHdr )
            nStatMode := PR_NORMAL
         ENDIF

      CASE nStatMode == PR_NORMAL

         nStatRnd := Random( nStatRnd )

         StatusSay( aStatMsg[ INT( nStatRnd / (32768 / LEN( aStatMsg ))) + 1 ], ;
                    nStatRow, nStatCol, nStatWid, cStatHue, nStatLen )

      ENDCASE

      nStatCnt := 0

   ENDIF

   RETURN NIL


STATIC FUNCTION StatusSay( cMsg, nRow, nCol, nWid, cHue, nLen )

   SCROLL( nRow + 2, nCol + 1, nRow + nLen - 1, nCol + nWid - 2, 1 )
   @ nRow + 12, nCol + 2 SAY cMsg COLOR cHue

   RETURN NIL

