************************************************************************
*  PROGRAM: APOP.PRG
*  WRITER: KRAIG W. KRIST/T BEAR COMPUTER SERVICES.
*  DATE: APRIL 1993
*  DESCRIPTION: GENERIC FUNCTION.   WILL ACHOICE PASSED aPOP IN PASSED
*               WINDOW COORDINATES nTOP, nLEFT, nBOTTOM, nRIGHT
************************************************************************
*           ---- MODIFICATION LOG ----
*  WHEN:
*   WHY:
************************************************************************
*
* CALLED BY:            
*   PASSED IN FROM         : nTOP, nLEFT, nBOTTOM, nRIGHT, aPOP
*   RETURNS TO         : SELECTED VALUE
*
* CALLS: AC_OPT (FUNCTION AUTOMATICALLY HANDLED BY ACHOICE)
*   PASSES TO AC_OPT:
*   RETURNED FROM AC_OPT:
************************************************************************
#INCLUDE "BOX.CH"
************************************************************************
*  FUNCTION APOP
************************************************************************
FUNCTION APOP(nTOP,nLEFT,nBOTTOM,nRIGHT,aPOP)
************************************************************************
*  DECLARE VARIABLES
************************************************************************
  MEMVAR nARR_SIZE, nTMP, aSCROLLBAR, nWTOP, nWBOTTOM, nCENTER
  LOCAL cSAVE_SCR, lTOOBIG, cRET_VAL
  PRIVATE nTMP, nCENTER, nWTOP, nWBOTTOM, nARR_SIZE
************************************************************************
*  INITIALIZE VARIABLES
************************************************************************
  PRIVATE aSCROLLBAR := {}
  nTMP := nCENTER := 0
  nWTOP := nTOP
  cSAVE_SCR := SAVESCREEN(0,0,MAXROW(),MAXCOL())
  nARR_SIZE := LEN(aPOP)
************************************************************************
*  DETERMINE IF AVAILABLE DATA WILL FIT IN THE WINDOW SIZE
************************************************************************
  nWBOTTOM := IF(((nBOTTOM-nTOP) > nARR_SIZE),;
              (nWTOP+nARR_SIZE+1),nBOTTOM)
  lTOOBIG := IF((nARR_SIZE > (nWBOTTOM-nTOP-1)),.T.,.F.)
  WINSHADE(nTOP,nLEFT,nWBOTTOM,nRIGHT)
************************************************************************
*  DETERMINE CENTER
************************************************************************
  nCENTER := nLEFT + ((nRIGHT-nLEFT)/2-4)
************************************************************************
*  PAINT
************************************************************************
  @ nTOP,nLEFT,nWBOTTOM,nRIGHT BOX B_DOUBLE
************************************************************************
*  INITIALIZE SCROLL BAR
************************************************************************
  SCROLLBARNEW(nTOP,nRIGHT,nWBOTTOM,'W/B')
************************************************************************
*  ISSUE APPROPRIATE TOP OF WINDOW MESSAGE
************************************************************************
  @ nTOP, nCENTER SAY '  Top  '
************************************************************************
*  ISSUE APPROPRIATE BOTTOM OF WINDOW MESSAGE
************************************************************************
  IF lTOOBIG
    @ nWBOTTOM,nCENTER SAY ' More ' + CHR(25) + ' '
  ELSE
    @ nWBOTTOM,nCENTER SAY ' Bottom '
  ENDIF
************************************************************************
*  PAINT INITIAL SCROLL BAR
************************************************************************
  SCROLLBARDISPLAY()
  SCROLLBARUPDATE(1,nARR_SIZE,.T.)
************************************************************************
*  CALL CLIPPER ACHOICE FUNCTION
************************************************************************
  nTMP := ACHOICE(nTOP+1,nLEFT+1,nWBOTTOM-1,nRIGHT-1,aPOP,,'AC_OPT')
  RESTSCREEN(0,0,MAXROW(),MAXCOL(),cSAVE_SCR)
  IF nTMP = 0
    cRET_VAL := SPACE(1)
  ELSE
    cRET_VAL := ALLTRIM(aPOP[nTMP])
  ENDIF
RETURN(cRET_VAL)
