***
*	ALTERROR
*
*	Clipper error system.  Debugging version.
*

PROCEDURE errorsys

RETURN


***
*	expr_error(name, line, info, model, _1, _2, _3)
*

FUNCTION expr_error
PARAM name, line, info, model, _1, _2, _3
PRIVATE result, sample
Logerr(2)
IF M->info = "zero divide"
	IF "%" $ M->model
		RETURN M->_1
	ELSE
		RETURN 0
	END
END

ALTD(2)

IF TYPE("M->result") != "U"
	RETURN M->result
END


SET DEVICE TO SCREEN
@ 24, 0

IF info = "type mismatch"
	M->sample = M->model
	M->sample = strtran(M->sample, "_1", type("M->_1"))
	M->sample = strtran(M->sample, "_2", type("M->_2"))
	M->sample = strtran(M->sample, "_3", type("M->_3"))

	@ 24, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) + ", " +;
				M->info + ": " + M->sample

ELSE
	@ 24, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) + ", " +;
				M->info

END

BREAK

RETURN .T.


***
*	misc_error(name, line, info, model)
*

FUNCTION misc_error
PARAM name, line, info, model
Logerr(3)
ALTD(2)

SET DEVICE TO SCREEN
@ 24, 0
@ 24, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) + ", " +;
			M->info + ": " + M->model

BREAK

RETURN .F.


***
*	open_error(name, line, info, model, _1)
*

FUNCTION open_error
PARAM name, line, info, model, _1
Logerr(5)
ALTD(2)

SET DEVICE TO SCREEN
@ 23, 0
@ 23, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) + ", "  +;
			M->info + ": " + M->model + " " + M->_1
@ 24, 0 SAY "Press Esc to abort, any other key to retry..."

IF (INKEY(0) == 27)
	@ 23,0
	@ 24,0
	RETURN .F.
END

@ 23,0
@ 24,0
RETURN .T.


***
*	undef_error(name, line, info, model, _1)
*

FUNCTION undef_error
PARAM name, line, info, model, _1
Logerr(4)
ALTD(2)

SET DEVICE TO SCREEN
@ 23, 0
@ 23, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) + ", "  +;
			M->info + ": " + " " + M->_1
@ 24, 0 SAY "Press Esc to abort, any other key to retry..."

IF (INKEY(0) == 27)
	@ 23,0
	@ 24,0
	BREAK
END

@ 23,0
@ 24,0
RETURN .T.


***
*	print_error(name, line)
*

FUNCTION print_error
PARAM name, line
PRIVATE key, file, info
info = "Printer Error"
Logerr(6)
SET DEVICE TO SCREEN
@ 23, 0
@ 23, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) +;
			", printer not ready"
@ 24, 0 SAY "Press <I>gnore, <R>etry, <B>REAK, F<ile>, <Q>uit..."

DO WHILE .T.
	key = UPPER(CHR(INKEY(0)))

	IF (M->key == "Q")
		QUIT

	ELSEIF (M->key == "I")
		@ 23,0
		@ 24,0
		RETURN .F.

	ELSEIF (M->key == "R")
		@ 23,0
		@ 24,0
		RETURN .T.

	ELSEIF (M->key == "B")
		@ 23,0
		@ 24,0
		BREAK

	ELSEIF (M->key == "F")
		@ 23,0
		@ 24,0
		ACCEPT "Filename - " TO file
		SET PRINTER TO (M->file)
		@ 23,0
		@ 24,0
		RETURN .T.

	END
END

RETURN .F.


***
*	db_error(name, line, info)
*

FUNCTION db_error
PARAM name, line, info
Logerr(1)
ALTD(2)
IF Info == "USE" .AND. NETERR()
  RETURN(.T.)
ENDIF
SET DEVICE TO SCREEN
@ 24, 0
@ 24, 0 SAY "Proc " + M->name + " line " + LTRIM(STR(M->line)) +;
			", " + M->info

BREAK

RETURN .F.
   
   
FUNCTION Logerr
PARAMETERS Logerror
Ret_Line = CHR(13) + CHR(10)
Errfile = "Error.Log"
IF !FILE("ERROR.LOG")
  Errhandle = FCREATE("ERROR.LOG",0)
  FCLOSE(ErrHandle)
ENDIF
Errhandle = FOPEN("ERROR.LOG",1)
FSEEK(Errhandle, 0, 2)
FWRITE(Errhandle,Ret_line+""+REPLICATE("",76)+""+Ret_Line)
FWRITE(ErrHandle," ERROR LOG: "+DTOC(DATE())+"  "+TIME()+SPACE(45)+""+Ret_Line)
FWRITE(Errhandle,""+REPLICATE("",76)+""+Ret_Line)
IF DOSERROR() > 0
  FWRITE(Errhandle,DosErrMsg()+Ret_Line)
ENDIF
FWRITE(ErrHandle,"ERROR CLASS"+Ret_Line)
DO CASE 
CASE Logerror = 1  && Db_Error
  FWRITE(Errhandle," DB_ERROR         : "+UPPER(Info)+Ret_Line)
  FWRITE(Errhandle," MODULE           : "+UPPER(Name)+Ret_Line)
  FWRITE(ERRHANDLE," LINE NUMBER      : "+TRANSFORM(LINE,"999,999")+RET_LINE)
CASE Logerror = 2  && Expr_Error has additional parms model, _1, _2, _3
  FWRITE(Errhandle," EXPR_ERROR       : "+UPPER(INFO)+Ret_Line)
  FWRITE(Errhandle," MODULE           : "+UPPER(Name)+Ret_Line)
  FWRITE(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999")+Ret_Line)
  FWRITE(Errhandle," MODEL            : "+Model+Ret_Line)
  IF TYPE("_1") # "U"
     FWRITE(Errhandle, " _1              : ")
     FWRITE(Errhandle,_1)
     FWRITE(Errhandle,Ret_Line)
  ENDIF
  IF TYPE("_2") # "U"
     FWRITE(Errhandle, " _2              : ")
     FWRITE(Errhandle,_2)
     FWRITE(Errhandle,Ret_Line)
  ENDIF
  IF TYPE("_3") # "U"
     FWRITE(Errhandle, " _3              : ")
     FWRITE(Errhandle,_3)
     FWRITE(Errhandle,Ret_Line)
  ENDIF
CASE Logerror = 3  && Misc_Error model
  FWRITE(Errhandle," MISC_ERROR       : "+UPPER(Info)+Ret_Line)
  FWRITE(Errhandle," MODULE           : "+UPPER(Name)+Ret_Line)
  FWRITE(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999")+Ret_Line)
  FWRITE(Errhandle," MODEL            : "+Model+Ret_Line)
CASE Logerror = 4  && Undef_Error model, _1
  FWRITE(Errhandle," UNDEF_ERROR      : "+UPPER(Info)+Ret_Line)
  FWRITE(Errhandle," MODULE           : "+UPPER(Name)+Ret_Line)
  FWRITE(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999")+Ret_Line)
  FWRITE(Errhandle," MODEL            : "+Model+Ret_Line)
  FWRITE(Errhandle," _1               : ")
  FWRITE(Errhandle,_1)
  FWRITE(Errhandle,Ret_Line)
CASE Logerror = 5  && Open_Error model, _1
  FWRITE(Errhandle," OPEN_ERROR       : "+UPPER(Info)+Ret_Line)
  FWRITE(Errhandle," MODULE           : "+UPPER(Name)+Ret_Line)
  FWRITE(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999")+Ret_Line)
  FWRITE(Errhandle," MODEL            : "+Model+Ret_Line)
  FWRITE(Errhandle," _1               : ")
  FWRITE(Errhandle,_1)
  FWRITE(Errhandle,Ret_Line)
CASE Logerror = 6  && Print_Error model, _1
  FWRITE(Errhandle," PRINT_ERROR      : "+UPPER(Info)+Ret_Line)
  FWRITE(Errhandle," MODULE           : "+UPPER(Name)+Ret_Line)
  FWRITE(Errhandle," LINE NUMBER      : "+TRANSFORM(Line,"999,999")+Ret_Line)
  FWRITE(Errhandle," MODEL            : "+Model+Ret_Line)
  FWRITE(Errhandle," _1               : ")
  FWRITE(Errhandle,_1)
  FWRITE(Errhandle,Ret_Line)
ENDCASE
FWRITE(Errhandle,Ret_Line+"MEMORY/DISK"+Ret_Line)
FWRITE(Errhandle," Volume Label     : "+GETVOLUME()+Ret_Line)
FWRITE(Errhandle," DOS Version      : "+TRANSFORM(DOSVERS(),"9.99")+Ret_Line)
FWRITE(Errhandle," Program Name     : "+PROGRAM()+Ret_Line)         
FWRITE(Errhandle," Default Path     : "+PATH()+Ret_Line)
FWRITE(Errhandle," Current Directory: "+CURDIR()+Ret_Line)
FWRITE(Errhandle," Total Disk Space : "+TRANSFORM(DISKSIZE(),"999,999,999")+" Bytes "+Ret_Line)
FWRITE(Errhandle," Free Disk Space  : "+TRANSFORM(DISKSPACE(),"999,999,999")+" Bytes"+Ret_Line)
FWRITE(Errhandle," DOS Mem Installed: "+TRANSFORM(DOSMEM()*1024,"999,999,999")+" Bytes"+Ret_Line)
FWRITE(Errhandle," Avail Memory     : "+TRANSFORM(MEMORY(0)*1024,"999,999,999")+" Bytes"+Ret_Line)
FWRITE(Errhandle," Expanded Mem Mgr : "+IF(ISEMS(),TRANSFORM(EXPMEM()*1024,"999,999,999")+" Bytes ","None")+Ret_Line)
FWRITE(Errhandle," Avail Extend Mem : "+TRANSFORM(EXTMEM()*1024,"999,999,999")+" Bytes"+Ret_Line)
FWRITE(Errhandle," Avail File Handle: "+TRANSFORM(HANDLES(),"999")+Ret_Line)
FWRITE(Errhandle,Ret_Line+"HARDWARE"+Ret_Line)
FWRITE(Errhandle," Comm Port 1      : "+IF(ISCOM(1),"Installed","None")+Ret_Line)
FWRITE(Errhandle," Comm Port 2      : "+IF(ISCOM(2),"Installed","None")+Ret_Line)
FWRITE(Errhandle," Comm Port 3      : "+IF(ISCOM(3),"Installed","None")+Ret_Line)
FWRITE(Errhandle," Comm Port 4      : "+IF(ISCOM(4),"Installed","None")+Ret_Line)
FWRITE(Errhandle," Printer 1        : "+Print_Stat(1)+Ret_Line)
FWRITE(Errhandle," Printer 2        : "+Print_Stat(2)+Ret_Line)
FWRITE(Errhandle," Printer 3        : "+Print_Stat(3)+Ret_Line)
FWRITE(Errhandle," Co-Processor     : "+IF(NDPTYPE()=0,"None ",TRANSFORM(NDPTYPE(),"99999"))+Ret_Line)
FWRITE(Errhandle," Mouse            : "+IF(ISMOUSE(),"Installed","None    ")+Ret_Line)
FWRITE(Errhandle," Last Key         : "+LTRIM(STR(LASTKEY()))+Ret_Line)
FWRITE(Errhandle,Ret_Line+"SET COMMANDS "+Ret_Line)
FWRITE(Errhandle," Alternate........."+IF(STATUS(1),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Exclusive........."+IF(STATUS(11),"ON.","OFF")+Ret_Line)
FWRITE(Errhandle," Bell.............."+IF(STATUS(2),"ON ", "OFF")+"      ") 
FWRITE(Errhandle,"Fixed............."+IF(STATUS(12),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Century..........."+IF(STATUS(3),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Insert............"+IF(STATUS(13),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Confirm..........."+IF(STATUS(4),"ON ", "OFF")+"      ") 
FWRITE(Errhandle,"Intensity........."+IF(STATUS(14),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Console..........."+IF(STATUS(5),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Print............."+IF(STATUS(15),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Cursor............"+IF(STATUS(6),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Scoreboard........"+IF(STATUS(16),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Deleted..........."+IF(STATUS(7),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Softseek.........."+IF(STATUS(17),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Delimiters........"+IF(STATUS(8),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Unique............"+IF(STATUS(18),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Escape............"+IF(STATUS(9),"ON ", "OFF")+"      ")
FWRITE(Errhandle,"Wrap.............."+IF(STATUS(19),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle," Exact............."+IF(STATUS(10),"ON ","OFF")+Ret_Line)
FWRITE(Errhandle,Ret_Line+"DATABASE INFORMATION "+Ret_Line)
IF ALLTRIMLEN(ALIAS()) > 0 .OR. SELECT() # 0
   FWRITE(Errhandle," Selected")
   Log_Dbf()
ELSEIF SELECT() = 0
   FWRITE(ErrHandle," No Area Selected "+Ret_Line)
ENDIF
FOR Out_Ctr = 1 TO 250
  IF Alltrimlen(ALIAS(Out_Ctr)) > 0
     SELECT (Out_Ctr)
     FWRITE(Errhandle,"      . . ."+SPACE(53)+". . ."+Ret_Line)
     Log_Dbf()
  ENDIF
NEXT
FWRITE(Errhandle,"<EOJ>"+Ret_Line)
FCLOSE(Errhandle)
RETURN(.T.)



FUNCTION Log_Dbf
FWRITE(Errhandle," Area: "+TRANSFORM(SELECT(),"999")+"  ")
IF Alltrimlen(ALIAS()) > 0
  FWRITE(Errhandle,ALIAS())
  FWRITE(Errhandle," Record Number: " + ALLTRIM(TRANSFORM(RECNO(),"@B 999,999"))+" of "+ALLTRIM(TRANSFORM(RECCOUNT(),"@B 999,999"))+IF(DELETED()," <Deleted>","")+Ret_Line)
  FWRITE(Errhandle," Last Updated: "+DTOC(LUPDATE())+Ret_Line)
ELSE
  FWRITE(Errhandle,"No Database in Selected Area ")
ENDIF
FWRITE(Errhandle,Ret_Line)
FOR CTR = 1 TO 10
  Rstring = DBRELATION(Ctr)
  IF Alltrimlen(Rstring)>0
     FWRITE(Errhandle," Relation :"+LTRIM(STR(Ctr))+"  "+TRIM(Rstring))
     FWRITE(Errhandle," INTO "+ALIAS(DBRSELECT(Ctr))+Ret_Line)
  ELSE
     EXIT
  ENDIF
NEXT
IF Alltrimlen(DBFILTER()) > 0
  FWRITE(Errhandle," Filter: "+DBFILTER()+Ret_Line)
ENDIF
IF ISINDEX()
  Ntx_Cont = INDEXORD()
  FOR Ctr = 1 to 15
     Ntx_Key  = INDEXKEY(Ctr)
     IF Alltrimlen(Ntx_Key) > 0
        FWRITE(Errhandle," Index "+TRANSFORM(Ctr,"999")+"  "+SUBSTR(INDEXKEY(Ctr)+REPLICATE(".",50),1,50))
        FWRITE(Errhandle,IF(Ctr = Ntx_Cont,"Primary ","Secondary ")+Ret_Line)
     ELSE
        EXIT
     ENDIF
  NEXT
ENDIF
RETURN(0)




FUNCTION Print_Stat
PARAMETER Port_Num
Prt_stat = Prnstatus(Port_Num)
DO CASE 
CASE Prt_Stat = 0 
   RETURN("On-Line ")
CASE Prt_Stat = 1
   RETURN("Off-Line ")
CASE Prt_Stat = 2
   RETURN("Turned Off ")
CASE Prt_Stat = 3
   RETURN("Out of Paper ")
CASE Prt_Stat = 4
   RETURN("Bad Cable Connection ")
OTHERWISE
   RETURN("Status Unknown ")
ENDCASE


FUNCTION DosErrMsg
PRIVATE Err_Num
Err_Num = DOSERROR()
DO CASE
CASE Err_Num =  0
  Msg = "Unknown or No Error"
CASE Err_Num =  1
  Msg = "Invalid function number"                                       
CASE Err_Num =  2
  Msg = "File not found"
CASE Err_Num =  3
  Msg = "Path not found"
CASE Err_Num =  4
  Msg = "Too many open files (no handles left)"
CASE Err_Num =  5
  Msg = "Access denied"
CASE Err_Num = 6 
  Msg = "Invalid handle"
CASE Err_Num =  7
  Msg = "Memory control blocks destroyed"
CASE Err_Num =  8
  Msg = "Insufficient memory"
CASE Err_Num =  9
  Msg = "Invalid memory block address"
CASE Err_Num = 10
  Msg = "Invalid environment"
CASE Err_Num = 11
  Msg = "Invalid format"
CASE Err_Num = 12
  Msg = "Invalid access code"
CASE Err_Num = 13
  Msg = "Invalid data"
CASE Err_Num = 14
  Msg = "Reserved"
CASE Err_Num = 15
  Msg = "Invalid drive was specified"
CASE Err_Num = 16
  Msg = "Attempt to remove current directory"
CASE Err_Num = 17
  Msg = "Not same device"
CASE Err_Num = 18
  Msg = "No more files"
CASE Err_Num = 19
  Msg = "Attempt to write on write-protected diskette"
CASE Err_Num = 20
  Msg = "Unknown unit"
CASE Err_Num = 21
  Msg = "Drive not ready"
CASE Err_Num = 22
  Msg = "Unknown command"
CASE Err_Num = 23
  Msg = "Data error (CRC)"
CASE Err_Num = 24
  Msg = "Bad request structure length"
CASE Err_Num = 25
  Msg = "Seek error"
CASE Err_Num = 26
  Msg = "Unknown media type"
CASE Err_Num = 27
  Msg = "Sector not found"
CASE Err_Num = 28
  Msg = "Printer out of paper"
CASE Err_Num = 29
  Msg = "Write fault"
CASE Err_Num = 30
  Msg = "Read fault"
CASE Err_Num = 31
  Msg = "General failure"
CASE Err_Num = 32
  Msg = "Sharing violation"
CASE Err_Num = 33
  Msg = "Lock violation"
CASE Err_Num = 34
  Msg = "Invalid disk change"
CASE Err_Num = 35
  Msg = "FCB unavailable"
CASE Err_Num = 36
  Msg = "Sharing buffer overflow"
CASE Err_Num >= 37 .AND. Err_Num <= 49
  Msg = "Reserved"
CASE Err_Num = 50
  Msg = "Network request not supported"
CASE Err_Num = 51
  Msg = "Remote computer not listening"
CASE Err_Num = 52
  Msg = "Duplicate name on network"
CASE Err_Num = 53
  Msg = "Network name not found"
CASE Err_Num = 54
  Msg = "Network busy"
CASE Err_Num = 55
  Msg = "Network device no longer exists"
CASE Err_Num = 56
  Msg = "Network BIOS command limit exceeded"
CASE Err_Num = 57
  Msg = "Network adapter hardware error"
CASE Err_Num = 58
  Msg = "Incorrect response from network"
CASE Err_Num = 59
  Msg = "Unexpected network error"
CASE Err_Num = 60
  Msg = "Incompatible remote adapter"
CASE Err_Num = 61
  Msg = "Print queue full"
CASE Err_Num = 62
  Msg = "Not enough space for print file"
CASE Err_Num = 63
  Msg = "Print file deleted (not enough space)"
CASE Err_Num = 64
  Msg = "Network name deleted"
CASE Err_Num = 65
  Msg = "Access denied"
CASE Err_Num = 66
  Msg = "Network device type incorrect"
CASE Err_Num = 67
  Msg = "Network name not found"
CASE Err_Num = 68
  Msg = "Network name limit exceeded"
CASE Err_Num = 69
  Msg = "Network BIOS session limit exceeded"
CASE Err_Num = 70
  Msg = "Temporarily paused"
CASE Err_Num = 71
  Msg = "Network request not accepted"
CASE Err_Num = 72
  Msg = "Print or disk redirection paused"
CASE Err_Num >= 73 .AND. Err_Num <= 79
  Msg = "Reserved"
CASE Err_Num = 80
  Msg = "File exists"
CASE Err_Num = 81
  Msg = "Reserved"
CASE Err_Num = 82
  Msg = "Cannot make directory entry"
CASE Err_Num = 83
  Msg = "Fail on INT 24"
CASE Err_Num = 84
  Msg = "Too many redirections"
CASE Err_Num = 85
  Msg = "Duplicate redirection"
CASE Err_Num = 86
  Msg = "Invalid password"
CASE Err_Num = 87
  Msg = "Invalid parameter"
CASE Err_Num = 88
  Msg = "Network device fault"
OTHERWISE
  MSg = "No Message Available"
ENDCASE
RETURN("DOS Error "+TRANSFORM(Err_Num,"999")+"  "+Msg)
