/*
        ADLIB.CH
*/

#include "inkey.ch"

#define LINEFEED    chr(13) + chr(10)
#define FORMFEED    chr(12)

// ADwait() return structure
#define WAIT_KEY	1
#define WAIT_BUTTON	2
#define WAIT_MROW	3
#define WAIT_MCOL	4
#define WAIT_SIZE	4


//ADapp() Configurable attributes
#define APP_COLORS              1
#define APP_INITBLOCK           2
#define APP_MAINBLOCK           3
#define APP_EXITBLOCK           4


//ADget() configurable attributes
#define GET_HELPID      1
#define GET_EXPHELPID   2
#define GET_COORDS      3
#define GET_FRAME       4
#define GET_SHADOW      5
#define GET_EXPLODE     6
#define GET_STDCOLOR    7
#define GET_ENHCOLOR    8
#define GET_UNSCOLOR    9
#define GET_DSPCOLOR    10
#define GET_HDRCOLOR    11
#define GET_TOPPAD      12
#define GET_LEFTPAD     13
#define GET_BOTTOMPAD   14
#define GET_RIGHTPAD    15
#define GET_MIDPAD      16
#define GET_PADCHAR     17
#define GET_INITBLOCK   18
#define GET_EXITBLOCK   19
#define GET_SAVEBLOCK   20
#define GET_ABORTBLOCK  21
#define GET_PAGEBLOCK   22
#define GET_HEADERBLOCK 23
#define GET_READENGINE  24
#define GET_RENGINEBLOCK        25
#define GET_MEMOS       26

//ADget() peekable attributes
#define PKGET_NGETS       1
#define PKGET_BOTTOM      2
#define PKGET_NROWS       3
#define PKGET_LENLABEL    4
#define PKGET_LENVALUE    5
#define PKGET_WIDTH       6
#define PKGET_RIGHT       7
#define PKGET_NPAGES      8
#define PKGET_CURPAGE     9
#define PKGET_AREADENGINE 10
#define PKGET_FIRSTGET    11
#define PKGET_LASTGET     12
#define PKGET_SCN         13
#define PKGET_UPDATED     14

//ADget() return structure
#define RVGET_EXITCODE         1
#define RVGET_UPDATED          2

// ADbox() frames
#define FRAME11		"Ŀ "
#define FRAME11B	"Ĵ "
#define FRAME12		"ķӺ "
#define FRAME22		"ͻȺ "
#define FRAME21		"͸Գ "
#define FRAME21B	"͵Գ "
#define FRAME21T	"͸Ƴ "
#define PDFRAME21 	"ѳԳ "

#define HORLINE121      "͵"

// ADvermenu() configurable attributes
#define VM_CARGO		1
#define VM_BOTTOM		2
#define VM_HPAD			3
#define VM_STDCOLOR		4
#define VM_ENHCOLOR		5
#define VM_TRGCOLOR		6
#define VM_HDRCOLOR		7
#define VM_FTRCOLOR		8
#define VM_ICNCOLOR		9
#define VM_FRAME		10
#define VM_SHADOW		11
#define VM_EXPLODE              12
#define VM_KEYS			13
#define VM_KHANDLER             14
#define VM_LBUTTONS		15
#define VM_LBHANDLER            16
#define VM_RBUTTONS		17
#define VM_RBHANDLER		18
#define VM_INITBLOCK		19
#define VM_MOVEBLOCK		20
#define VM_EXITBLOCK		21
#define VM_TICON		22
#define VM_BICON		23
#define VM_SICON		24
#define VM_SCROLLBAR		25
#define VM_SHOWICON		26
#define VM_HEADER		27
#define VM_FOOTER		28
#define VM_HDRSTART		29
#define VM_FTRSTART		30
#define VM_HELPID		31
#define VM_MULTI		32
#define VM_TAGMARK		33
#define VM_MULTIEXITKEY  	34
#define VM_INITSEL		35
#define VM_LREXIT		36
#define VM_TRIGGER		37
#define VM_SELBLOCK		38
#define VM_ABORTBLOCK		39
#define VM_RETURNTYPE           40

#define PKVM_NROWS              1
#define PKVM_SCN                2
#define PKVM_ROW                3
#define PKVM_CURRENT            4
#define PKVM_INITIALS           5
#define PKVM_TOP                6
#define PKVM_LEFT               7
#define PKVM_RIGHT              8
#define PKVM_ATAGGED            9
#define PKVM_NOPTIONS           10

//ADhormenu() configurable attributes
#define HM_ROW          1
#define HM_FIRSTCOL     2
#define HM_PAD          3
#define HM_HORLINE      4
#define HM_HORLINECHAR  5
#define HM_HORLINEROW   6  
#define HM_STDCOLOR     7
#define HM_ENHCOLOR     8
#define HM_TRGCOLOR     9
#define HM_LINCOLOR     10
#define HM_KEYS         11
#define HM_KHANDLER     12
#define HM_LBUTTONS     13
#define HM_LBHANDLER    14
#define HM_RBUTTONS     15
#define HM_RBHANDLER    16
#define HM_INITBLOCK    17
#define HM_MOVEBLOCK    18
#define HM_EXITBLOCK    19
#define HM_HELPID       20
#define HM_INITSEL      21
#define HM_SELBLOCK     22
#define HM_PULLDOWN     23

//ADhormenu() peekable attributes
#define PKHM_SCN        1
#define PKHM_LEN        2
#define PKHM_STARTCOL   3
#define PKHM_ENDCOL     4
#define PKHM_FCHAR      5
#define PKHM_CURRENT    6
#define PKHM_SPOT       7


//ADboxmenu() configurable attributes
#define BM_CARGO        1
#define BM_PAD          2
#define BM_STDCOLOR     3
#define BM_ENHCOLOR     4
#define BM_TRGCOLOR     5
#define BM_KEYS         6
#define BM_KHANDLER     7
#define BM_LBUTTONS     8
#define BM_LBHANDLER    9
#define BM_RBUTTONS     10
#define BM_RBHANDLER    11
#define BM_INITBLOCK    12
#define BM_MOVEBLOCK    13
#define BM_EXITBLOCK    14
#define BM_HELPID       15
#define BM_INITSEL      16
#define BM_SELBLOCK     17
#define BM_FRAME        18
#define BM_SHADOW       19
#define BM_EXPLODE      20
#define BM_DIVIDER      21
#define BM_TRIGGER      22
#define BM_TOP          23
#define BM_LEFT         24

//ADboxmenu() peekable attributes
#define PKBM_SCN            1
#define PKBM_NOPTIONS       2
#define PKBM_INITIALS       3
#define PKBM_CURRENT        4
#define PKBM_SPOTS          5
#define PKBM_WIDTH          6
#define PKBM_RIGHT          7
#define PKBM_BOTTOM         8
#define PKBM_TOP            9
#define PKBM_LEFT           10


//ADpl_file() sort orders
#define PLFILSORT_NAME  1
#define PLFILSORT_EXT   2
#define PLFILSORT_SIZE  3
#define PLFILSORT_DATE  4

//ADpl_field() configurable attributes
#define PLFLD_DEFINITIONS     1
#define PLFLD_TYPES           2
#define PLFLD_NOMATCHBLOCK    3
#define PLFLD_SORT            4

//ADdv..() configurable attributes
#define DV_CARGO        1 
#define DV_COORDS       2
#define DV_FRAME        3
#define DV_SHADOW       4
#define DV_EXPLODE      5
#define DV_COLOR        6
#define DV_HEADSEP      7
#define DV_COLSEP       8
#define DV_INITBLOCK    9
#define DV_XMOVEBLOCK   10
#define DV_YMOVEBLOCK   11
#define DV_EXITBLOCK    12
#define DV_KEYS         13
#define DV_KHANDLER     14
#define DV_LBUTTONS     15
#define DV_LBHANDLER    16
#define DV_RBUTTONS     17
#define DV_RBHANDLER    18
#define DV_EXPCOORDS    19
#define DV_EXPCOLOR     20
#define DV_HELPID       21
#define DV_CANEDIT      22
#define DV_EDITCLAUSES  23
#define DV_EDITINCLUDE  24
#define DV_EDITDISPONLY 25
#define DV_EDITKEYS     26
#define DV_EDITKHANDLER 27
#define DV_EDITLBUTTONS 28
#define DV_EDITLBHANDLER 29

//ADtv..() peekable attributes
#define PKDV_COLUMNS     1
#define PKDV_OBJ         2
#define PKDV_SCN         3
#define PKDV_COLORARRAY  4
#define PKDV_HLINES      5
#define PKDV_LOGNO       6
#define PKDV_EDITMODE    7
#define PKDV_FLDNUMBERS  8
#define PKDV_MEMOS       9

//ADsb..() configurable attributes
#define SB_DIRECTION   1
#define SB_BARCHAR     2
#define SB_SCROLLCHAR  3
#define SB_LOCATION    4
#define SB_START       5
#define SB_NSPOTS      6
#define SB_BARCOLOR    7
#define SB_SCRCOLOR    8
#define SB_INITB       9

//ADsb..() directions
#define SB_VERTICAL     1
#define SB_HORIZONTAL   2

//ADdd_getinfo() return array
#define DD_GETINFO_LABELS       1
#define DD_GETINFO_PICS         2
#define DD_GETINFO_WHENS        3
#define DD_GETINFO_VALIDS       4


//ADread() configurable attributes
#define R_CARGO       1
#define R_INITBLOCK   2
#define R_MOVEBLOCK   3
#define R_EXITBLOCK   4
#define R_KEYS        5
#define R_KHANDLER    6
#define R_LBUTTONS    7
#define R_LBHANDLER   8
#define R_RBUTTONS    9
#define R_RBHANDLER   10
#define R_EXPCOORDS   11
#define R_EXPCOLOR    12
#define R_HELPID      13  

//ADread() peekable attributes
#define PKREAD_NTHGET      1
#define PKREAD_EXITCODE    2
#define PKREAD_NGETS       3
#define PKREAD_INSERT      4
#define PKREAD_UPDATED     5

//ADread() special exit codes
#define RX_NOCONFIRM       -101
#define RX_SAVE            -102
#define RX_ABORT           -103

// Return values of user-defined key and mouse button handlers for ADread()
#define EXIT_READ       .T.
#define CONTINUE_READ   .F.

//ADeditrec() configurable attributes
#define ER_CARGO       1
#define ER_READENGINE  2
#define ER_COORDS      3
#define ER_FRAME       4
#define ER_SHADOW      5
#define ER_EXPLODE     6
#define ER_STDCOLOR    7
#define ER_ENHCOLOR    8
#define ER_UNSCOLOR    9
#define ER_DSPCOLOR    10
#define ER_HDRCOLOR    11
#define ER_TOPPAD      12
#define ER_LEFTPAD     13
#define ER_BOTTOMPAD   14
#define ER_RIGHTPAD    15
#define ER_MIDPAD      16
#define ER_PADCHAR     17
#define ER_INITBLOCK   18
#define ER_AGAINBLOCK  19
#define ER_PAGEBLOCK   20
#define ER_EXITBLOCK   21
#define ER_LABELS      22
#define ER_PICS        23
#define ER_VALIDS      24
#define ER_WHENS       25
#define ER_DISPS       26  
#define ER_MEMOS       27
#define ER_HELPID      28   

//ADeditrec() return codes
#define ERX_ABORT      1
#define ERX_SAVE       2
#define ERX_NEXT       3
#define ERX_PREVIOUS   4
#define ERX_BOTTOM     5
#define ERX_TOP        6

//ADeditrec() peekable attributes
#define PKER_GETS        1
#define PKER_NGETS       2
#define PKER_SCN         3
#define PKER_NPAGES      4
#define PKER_CURPAGE     5
#define PKER_READCONFIG  6
#define PKER_READPEEK    7
#define PKER_UPDATED     8



#command @ <row>, <col> SAY <sayxpr>                                    ;
                        [<sayClauses,...>]                              ;
                        ADGET <var>                                     ;
                        [<getClauses,...>]                              ;
                                                                        ;
      => @ <row>, <col> SAY <sayxpr> [<sayClauses>]                     ;
       ; @ Row(), Col()+1 GET <var> [<getClauses>]                      ;
       ; ADr_mousify( getlist )


#command @ <row>, <col> ADGET <var>                                     ;
                        [<getClauses,...>]                              ;
                                                                        ;
      => @ <row>, <col> GET <var> [<getClauses>]                      ;
       ; ADr_mousify( getlist )


//ADprn_..() configuration
#define PRN_DESTINATION         1
#define PRN_TOPMARGIN           2
#define PRN_LEFTMARGIN          3
#define PRN_BOTTOMMARGIN        4
#define PRN_RIGHTMARGIN         5
#define PRN_PAGELENGTH          6
#define PRN_PAGEWIDTH           7

//ADprn_init()
#define PRN_NTHLINE     1
#define PRN_NTHCOL      2
#define PRN_NTHPAGE     3
#define PRN_AVAILLINES  4
#define PRN_AVAILCOLS   5

