/****
* Fichero 1STCLASS.CH
* Include for class definitions 
*
* (c) 1993-1994 Grupo EIDOS
*
* Versin: 2.0
*
* Antonio Rojo
*/


// ----------------------------------------------------------------------------
#ifndef _1STCLASS_CH
#define _1STCLASS_CH
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#define VT_DEFAULT         nScpVar
#define VT_PUBLIC          1
#define VT_PROTECTED       2
#define VT_PRIVATE         3
#define VT_STATIC          4
// ----------------------------------------------------------------------------
#define ADD_VAR            1
#define ADD_METHOD         2
#define ADD_INLINE         3
#define ADD_CTOR           4
#define ADD_SUBORDINATE    5
#define ADD_REDEFINE       6
// ----------------------------------------------------------------------------
#define TPO_UNDEFINED      0
#define TPO_NUMERIC        1
#define TPO_CHARACTER      2
#define TPO_LOGICAL        3
#define TPO_DATE           4
#define TPO_CODEBLOCK      5
#define TPO_ARRAY          6
#define TPO_OBJECT         7
#xtranslate TYPE UNDEFINED => TYPE TPO_UNDEFINED
#xtranslate TYPE NUMERIC   => TYPE TPO_NUMERIC
#xtranslate TYPE INTEGER   => TYPE TPO_NUMERIC
#xtranslate TYPE CHARACTER => TYPE TPO_CHARACTER
#xtranslate TYPE CHAR      => TYPE TPO_CHARACTER
#xtranslate TYPE LOGICAL   => TYPE TPO_LOGICAL
#xtranslate TYPE DATE      => TYPE TPO_DATE
#xtranslate TYPE CODEBLOCK => TYPE TPO_CODEBLOCK
#xtranslate TYPE BLOCK     => TYPE TPO_CODEBLOCK
#xtranslate TYPE ARRAY     => TYPE TPO_ARRAY
#xtranslate TYPE OBJECT    => TYPE TPO_OBJECT
#xtranslate AS UNDEFINED   => TYPE TPO_UNDEFINED
#xtranslate AS NUMERIC     => TYPE TPO_NUMERIC
#xtranslate AS INTEGER     => TYPE TPO_NUMERIC
#xtranslate AS CHARACTER   => TYPE TPO_CHARACTER
#xtranslate AS CHAR        => TYPE TPO_CHARACTER
#xtranslate AS LOGICAL     => TYPE TPO_LOGICAL
#xtranslate AS DATE        => TYPE TPO_DATE
#xtranslate AS CODEBLOCK   => TYPE TPO_CODEBLOCK
#xtranslate AS BLOCK       => TYPE TPO_CODEBLOCK
#xtranslate AS ARRAY       => TYPE TPO_ARRAY
#xtranslate AS OBJECT      => TYPE TPO_OBJECT
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#include "1stNew.ch"
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xcommand ;
   _CLASS <class> [FROM <parent>] ;
=> ;
   FUNCTION <class>( lParent ) ;;
      STATIC nHandle, Self, nParent ;;
      LOCAL nScpVar := 1 ;;
      if lParent != nil ;;
         if lParent ;;
            RETURN nParent ;;
         else ;;
            RETURN nHandle ;;
         end ;;
      end ;;
      if nHandle == nil ;;
         nParent := FcNew( <(class)>, [<parent>()] ) ;;
         \#define _PARENT_ <class>


#xcommand ;
   CLASS <class> [<from: INHERIT FROM, FROM, OF> <parent>] ;
=> ;
   _CLASS <class> [FROM <parent>]

#xcommand CREATE CLASS <*def*> => CLASS <def>
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xcommand ;
   VAR <var> [IS <red>] [TO <varobj>] ;
=> ;
   FcDMAdd( ADD_SUBORDINATE, { <(var)>, [<(red)>], [<(varobj)>] } ) ;;
   FcDMAdd( ADD_SUBORDINATE, { "_"+<(var)>, ["_"+<(red)>], [<(varobj)>] } )

#xcommand ;
   VAR <var1> [,<varN>] [TYPE <tpo>] [<type: PUBLIC, SHARED, EXPORT, EXPORTED, VISIBLE>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var1)>, VT_PUBLIC, <.stc.>, <tpo>, [<{dft}>], } ) ;
   [; FcDMAdd( ADD_VAR, { <(varN)>, VT_PUBLIC, <.stc.>, <tpo>, <{dft}>, } ) ]

#xcommand ;
   VAR <var1> [,<varN>] [TYPE <tpo>] [<type: PROTEC, PROTECTED, READONLY, RO, NOASSIGN>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var1)>, VT_PROTECTED, <.stc.>, <tpo>, [<{dft}>], } ) ;
   [; FcDMAdd( ADD_VAR, { <(varN)>, VT_PROTECTED, <.stc.>, <tpo>, <{dft}>, } ) ]

#xcommand ;
   VAR <var1> [,<varN>] [TYPE <tpo>] [<type: PRIVATE, HIDDEN, LOCAL>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var1)>, VT_PRIVATE, <.stc.>, <tpo>, [<{dft}>], } ) ;
   [; FcDMAdd( ADD_VAR, { <(varN)>, VT_PRIVATE, <.stc.>, <tpo>, <{dft}>, } ) ]

#xcommand ;
   VAR <var1> [,<varN>] [TYPE <tpo>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var1)>, VT_DEFAULT, <.stc.>, <tpo>, [<{dft}>], } ) ;
   [; FcDMAdd( ADD_VAR, { <(varN)>, VT_DEFAULT, <.stc.>, <tpo>, <{dft}>, } ) ]

#xcommand ;
   VAR <var> [TYPE <tpo>] [<type: PUBLIC, SHARED, EXPORT, EXPORTED, VISIBLE>] [<stc: STATIC>] [DEFAULT <dft>] [VALID <vld>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_PUBLIC, <.stc.>, <tpo>, [<{dft}>], [{|Self,<var>|<vld>}] } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<type: PROTEC, PROTECTED, READONLY, RO, NOASSIGN>] [<stc: STATIC>] [DEFAULT <dft>] [VALID <vld>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_PROTECTED, <.stc.>, <tpo>, [<{dft}>], [{|Self,<var>|<vld>}] } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<type: PRIVATE, HIDDEN, LOCAL>] [<stc: STATIC>] [DEFAULT <dft>] [VALID <vld>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_PRIVATE, <.stc.>, <tpo>, [<{dft}>], [{|Self,<var>|<vld>}] } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<stc: STATIC>] [DEFAULT <dft>] [VALID <vld>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_DEFAULT, <.stc.>, <tpo>, [<{dft}>], [{|Self,<var>|<vld>}] } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<type: PUBLIC, SHARED, EXPORT, EXPORTED, VISIBLE>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_PUBLIC, <.stc.>, <tpo>, [<{dft}>], } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<type: PROTEC, PROTECTED, READONLY, RO, NOASSIGN>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_PROTECTED, <.stc.>, <tpo>, [<{dft}>], } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<type: PRIVATE, HIDDEN, LOCAL>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_PRIVATE, <.stc.>, <tpo>, [<{dft}>], } )

#xcommand ;
   VAR <var> [TYPE <tpo>] [<stc: STATIC>] [DEFAULT <dft>] ;
=> ;
   FcDMAdd( ADD_VAR, { <(var)>, VT_DEFAULT, <.stc.>, <tpo>, [<{dft}>], } )

#xcommand ;
   VAR <var> SETGET <function> ;
=> ;
   FcDMAdd( ADD_METHOD, { <(var)>, {||<function>()} } ) ;;
   FcDMAdd( ADD_METHOD, { '_'+<(var)>, {||<function>()} } )

#xcommand ;
   VAR <var> INLINE SETGET <code> ;
=> ;
   FcDMAdd( ADD_INLINE, { <(var)>, { |Self| <code> } } ) ;;
   FcDMAdd( ADD_INLINE, { '_'+<(var)>, { |Self,<var>| <code> } } )

#xcommand ;
   VAR <var> ASSIGN <function> ;
=> ;
   FcDMAdd( ADD_METHOD, { '_'+<(var)>, {||<function>()} } )

#xcommand ;
   VAR <var> ACCESS <function> ;
=> ;
   FcDMAdd( ADD_METHOD, { <(var)>, {||<function>()} } )

#xcommand ;
   VAR <var> ASSIGN <function1> ACCESS <function2> ;
=> ;
   FcDMAdd( ADD_METHOD, { '_'+<(var)>, {||<function1>()} } ) ;;
   FcDMAdd( ADD_METHOD, { <(var)>, {||<function2>()} } )

#xcommand ;
   VAR <var> INLINE ASSIGN <code> ;
=> ;
   FcDMAdd( ADD_INLINE, { '_'+<(var)>, { |Self,<var>| <code> } } )

#xcommand ;
   VAR <var> INLINE ACCESS <code> ;
=> ;
   FcDMAdd( ADD_INLINE, { <(var)>, { |Self| <code> } } )

#xcommand ;
   VAR <var> INLINE ASSIGN <code1> ACCESS <code2> ;
=> ;
   FcDMAdd( ADD_INLINE, { '_'+<(var)>, { |Self,<var>| <code1> } } ) ;;
   FcDMAdd( ADD_INLINE, { <(var)>, { |Self| <code2> } } )

#xcommand DATA <*def*>        =>    VAR <def>
#xcommand INSTVAR <*def*>     =>    VAR <def>
#xcommand CLASS VAR <*def*>   =>    VAR <def> STATIC
#xcommand CLASSVAR <*def*>    =>    VAR <def> STATIC

#xcommand PUBLIC:    =>    nScpVar := VT_PUBLIC
#xcommand SHARED:    =>    PUBLIC:
#xcommand EXPORT:    =>    PUBLIC:
#xcommand EXPORTED:  =>    PUBLIC:
#xcommand VISIBLE:   =>    PUBLIC:

#xcommand PROTECTED: =>    nScpVar := VT_PROTECTED
#xcommand PROTEC:    =>    PROTECTED:
#xcommand READONLY:  =>    PROTECTED:
#xcommand RO:        =>    PROTECTED:
#xcommand NOASSIGN:  =>    PROTECTED:

#xcommand PRIVATE:   =>    nScpVar := VT_PRIVATE
#xcommand HIDDEN:    =>    PRIVATE:
#xcommand LOCAL:     =>    PRIVATE:
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xcommand ;
   MESSAGE <message> [IS <red>] [TO <varobj>] ;
=> ;
   FcDMAdd( ADD_SUBORDINATE, { <(message)>, [<(red)>], [<(varobj)>] } )

#xcommand ;
   MESSAGE <message> <block: BLOCK, INLINE> <code> [PARAMETERS <pars,...>] ;
=> ;
   FcDMAdd( ADD_INLINE, { <(message)>, { |Self[,<pars>]| <code> } } )

#xcommand ;
   MESSAGE <message> <ctor: CONSTRUCTOR, CTOR> ;
=> ;
   FcDMAdd( ADD_CTOR, { <(message)>, {||<message>()} } )

#xcommand ;
   MESSAGE <message1> METHOD <method1> [,<messageN> METHOD <methodN>] ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||<method1>()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||<methodN>()} } ) ]

#xcommand ;
   MESSAGE <message1> [, <messageN> ] ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||<message1>()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||<messageN>()} } ) ]

#xcommand ;
   MESSAGE <message1> = <method1> [,<messageN> = <methodN>] ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||<method1>()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||<methodN>()} } ) ]

#xcommand ;
   MESSAGE <message>([<pars,...>]) <ctor: CONSTRUCTOR, CTOR> ;
=> ;
   FcDMAdd( ADD_CTOR, { <(message)>, {||<message>()} } )

#xcommand ;
   MESSAGE <message1> METHOD <method1>([<pars1,...>]) [,<messageN> METHOD <methodN>([<pars2,...>]) ] ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||<method1>()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||<methodN>()} } ) ]

#xcommand ;
   MESSAGE <message1> [,<messageN>] [IS] <virt: VIRTUAL, ISNULL, NULL, DEFERRED> ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||__1st_070()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||__1st_070()} } ) ]

#xcommand ;
   MESSAGE <message1>([<pars1,...>]) [, <messageN>([<pars2,...>]) ] ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||<message1>()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||<messageN>()} } ) ]

#xcommand ;
   MESSAGE <message1> = <method1>([<pars1,...>]) [,<messageN> = <methodN>([<pars2,...>])] ;
=> ;
   FcDMAdd( ADD_METHOD, { <(message1)>, {||<method1>()} } ) ;
   [; FcDMAdd( ADD_METHOD, { <(messageN)>, {||<methodN>()} } ) ]

#xcommand ;
   CONSTRUCTOR <message> ;
=> ;
   MESSAGE <message> CONSTRUCTOR

#xtranslate CLASS MESSAGE <*def*> => MESSAGE <def>
#xtranslate CLASS METHOD <*def*> => MESSAGE <def>
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xcommand ;
   ENDCLASS ;
=> ;
         nHandle = FcCreate() ;;
         (Self:=__ClassIns(nHandle)):InitClass() ;;
         __1st_065( nHandle, Self ) ;;
      end ;;
   RETURN Self ;;
   #include "1stEnd.ch"

#xcommand END CLASS => ENDCLASS
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xtranslate @:<message>([<pars,...>]) => Self:Super(_PARENT_(.f.)):<message>([<pars>])
#xtranslate :: => Self:
#xtranslate This => Self
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xcommand ;
   _METHOD [<fun:PROCEDURE,FUNCTION>] <method> [<friend:SHARED,PUBLIC,FRIEND>] [CLASS <class>] ;
=> ;
   FUNCTION <method>() ;;
      LOCAL Self := QSelf()

#xcommand ;
   _METHOD [<fun:PROCEDURE,FUNCTION>] <method> [CLASS <class>] ;
=> ;
   STATIC FUNCTION <method>() ;;
      LOCAL Self := QSelf()

#xcommand ;
   _METHOD [<fun:PROCEDURE,FUNCTION>] <method>([<pars,...>]), <mthsup>([<psup,...>]) [CLASS <class>] ;
=> ;
   STATIC FUNCTION <method>( [<pars>] ) ;;
      LOCAL Self := ( QSelf():Super:<mthsup>([<psup>]), QSelf() )

#xcommand ;
   _METHOD [<fun:PROCEDURE,FUNCTION>] <method>([<pars,...>]), ([<psup,...>]) [CLASS <class>] ;
=> ;
   STATIC FUNCTION <method>( [<pars>] ) ;;
      LOCAL Self := ( QSelf():Super:<method>([<psup>]), QSelf() )

#xcommand ;
   _METHOD [<fun:PROCEDURE,FUNCTION>] <method>([<pars,...>]) [<friend:SHARED,PUBLIC,FRIEND>] [CLASS <class>] ;
=> ;
   FUNCTION <method>( [<pars>] ) ;;
      LOCAL Self := QSelf()

#xcommand ;
   _METHOD [<fun:PROCEDURE,FUNCTION>] <method>([<pars,...>]) [CLASS <class>] ;
=> ;
   STATIC FUNCTION <method>( [<pars>] ) ;;
      LOCAL Self := QSelf()
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#xtranslate ;
   Super:<message> ;
=> ;
   Super(_PARENT_(.t.)):<message>()

#xtranslate ;
   ::QParent(<var>):<message> ;
=> ;
   __1st_068( if( <var> = nil, <var> := __1st_069( <(message)>, _PARENT_(.t.) ), <var> ) )

#xtranslate ;
   Super:<message>( [<pars,...>] ) ;
=> ;
   Super(_PARENT_(.t.)):<message>( [<pars>] )

#xtranslate ;
   ::QParent(<var>):<message>( [<pars,...>] ) ;
=> ;
   __1st_068( [<pars>,] if( <var> = nil, <var> := __1st_069( <(message)>, _PARENT_(.t.) ), <var> ) )

#xtranslate QSuper => QParent
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#command INITIALIZE CLASS => #include "1stNew.ch"
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
#endif
// ----------------------------------------------------------------------------
