/***
* EJ_TSBROW.PRG file
* First Class' classes collection
*
* (c) 1994 Grupo EIDOS
*
* Ramn Delgado
* Alfonso Fraguas
* Antonio Rojo
*/
//
#define NUM_FIELDS     100
#define NUM_RECS      1000

#include "Directry.ch"
#include "TSBrw.ch"
#include "Inkey.ch"
#include "SetCurs.ch"


FUNCTION Start()
   LOCAL oBrw  := TSpeedBrowse():New(1,1,20,78)                              ,;
         oBrw2 := TBrowseDb(1,1,20,78)                                       ,;
         oErr                                                                ,;
         nT                                                                  ,;
         nLenOb1                                                             ,;
         nLenOb2

   // Opening and/or creating a DataBase
   OpenDbf()
   CLS

   // Establishing SpeedBrowse's features
   oBrw:HeadSep      :=""
   oBrw:ColSep       :="  "
   oBrw:FootSep      :=""
   oBrw:ColorSpec    := "W+/B,W+/R"

   // Establishing second Browse's features
   oBrw2:HeadSep     :=""
   oBrw2:ColSep      :="  "
   oBrw2:FootSep     :=""
   oBrw2:ColorSpec   := "W+/B,W+/R"

   // We add a first fixed column with RecNo()
   oBrw:AddColumn( TBColumnNew( "Register" , { || RecNo() }  ) )
   oBrw:Freeze := 1

   // We add a first fixed column with RecNo()
   oBrw2:AddColumn( TBColumnNew( "Register" , { || RecNo() }  ) )
   oBrw2:Freeze := 1

   // Adding a column for every field of the DataBase
   FOR nT:= 1 TO FCount()
      oBrw:AddColumn( TBColumnNew( FieldName( nT ),                        ;
                      FieldBlock( FieldName( nT ) ) ) )
      oBrw2:AddColumn( TBColumnNew( FieldName( nT ),                       ;
                      FieldBlock( FieldName( nT ) ) ) )
   NEXT nT


   Alert( "First a normal TBrowseDb() from Clipper" )
   Dispbox(0,0,21,79,2)
   RunBrow(oBrw2)     // Sending the normal Object
   CLS

   Alert( "Now with TSpeedBrowse" )
   Dispbox(0,0,21,79,2)
   RunBrow(oBrw)      // Sending SpeedBrowse Object
   CLS

   Alert( "Again the normal Browse" )
   Dispbox(0,0,21,79,2)
   RunBrow(oBrw2)     // We only change object
   CLS


   // A minimum sense of humour is always wellcome :-).... or not
   IF alert("Have you found any difference ?",{"No","Yes"}) >1
      ? "   We have been working with "+AllTrim(Str(NUM_FIELDS))+" fields"
      InKey(.5)
      ?
      ? "I've nothing else to tell you !"
      ?

   ELSE
      ? "Try it with 200 fields and if"
      ? "you don't see it..."
      InKey(.5)
      ?
      ? "You probably need a doctor !!! "
      ?
   END IF

   ? 'Press any key to finish'
   InKey(0)

RETURN nil
// -
FUNCTION OpenDbf()
   LOCAL aDbf:={},nT, nVal:=1

   IF !File( "EJ_TSBRW.DBF" )
      DispBox( 9, 22, 11, 57, 2, "R+/W" )
      @ 10,23 SAY "    Creating the test DataBase    " COLOR "W*/B"
      InKey(1)
      FOR nT := 1 TO NUM_FIELDS
         AAdd( aDbf, { "N" + PadL( Nt, 3, "0" ), "N", 8 , 0 } )
      NEXT nT
      DbCreate( "EJ_TSBRW.DBF", aDbf )
   END IF

   USE EJ_TSBRW

   WHILE LastRec() < NUM_RECS
      DbAppend()
      FOR nT := 1 TO NUM_FIELDS
         FieldPut( nT, nVal++ )
      NEXT nT
   END WHILE

RETURN NIL
// -
FUNCTION RunBrow(o)
LOCAL nPos                                                               ,;
      nKey:=0                                                            ,;
      nCur:=SetCursor(SC_NONE)                                           ,;
      aK                                                                 ,;
      lContinue:=.t.

   aK:=SPEED_TBROWSE_KEYS

   o:GoTop()
   o:colPos:=1

   WHILE valtype(lContinue)<>"L" .or. lContinue

      o:ForceStable()

      nKey:=inkey(0)

      DO CASE
      CASE !empty(Setkey(nKey))
           eval(SetKey(nKey),o)

      CASE (nPos:=ascan(aK,{ | k | k[1]=nKey} ) ) >0
           lContinue:=eval(aK[nPos][2],o)

      END CASE
   END WHILE

   SetCursor(nCur)

RETURN lContinue