GLSPERIOD    FILE,PRE(PER),NAME(GLSPERIODS),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
START		 LONG,DIM(13)			 !Period X Start
STOP		 LONG,DIM(13)			 !Period X Stop
CURRENT		 BYTE				 !Current Period
	     . .

GLSACCTS     FILE,PRE(ACC),NAME(GLSACCOUNTS),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(ACC:GL_CODE),NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !Account Code
DESCRIPTION	 STRING(30)			 !Account Description
TB_SUBTOTAL	 BYTE				 !Trial Balance Subtotal Level
FIN_STMT	 STRING(1)			 !Financial Statement Type
SAF_TYPE	 STRING(1)			 !Source/Application of Funds
NORMAL_BAL	 STRING(1)			 !NORMAL BALANCE - DEBIT OR CREDIT
COMPRESS	 STRING(1)			 !Compression Code
	     . .

GLSBDGET     FILE,PRE(BUD),NAME(GLSBUDGET),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(BUD:GL_CODE),NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Account Code
PER		 DECIMAL(11,2),DIM(13)		 !Budget Amount Period X
	     . .

GLSBLANCES   FILE,PRE(BAL),NAME(GLSBALANCES),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(BAL:GL_CODE),NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Account Code
BEG_BAL		 DECIMAL(11,2)			 !Beginning Balance
DEBITS		 DECIMAL(11,2),DIM(13)		 !PERIOD X TOTAL DEBITS
CREDITS		 DECIMAL(11,2),DIM(13)		 !PERIOD X TOTAL CREDITS
PER_LOCK	 STRING(1),DIM(13)		 !Period X Lock
END_BAL		 DECIMAL(11,2)			 !Ending Balance
	     . .

GLSHSTORY    FILE,PRE(HIS),NAME(GLSHISTORY),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(HIS:GL_CODE),NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Code
PER_0		 DECIMAL(11,2),DIM(13)		 !Period X (Current Year)
PER_1		 DECIMAL(11,2),DIM(13)		 !Period X Year -1
PER_2		 DECIMAL(11,2),DIM(13)		 !Period X Year -2
PER_3		 DECIMAL(11,2),DIM(13)		 !Period X Year -3
PER_4		 DECIMAL(11,2),DIM(13)		 !Period X Year -4
PER_5		 DECIMAL(11,2),DIM(13)		 !Period X Year -5
	     . .

GLSSTDTRN    FILE,PRE(STD),NAME(GLSSTDTRAN),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(STD:GL_CODE),DUP,NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Code
DB_AMOUNT	 DECIMAL(11,2)			 !Transaction Amount (Debit)
CR_AMOUNT	 DECIMAL(11,2)			 !Transaction Amount (Credit)
STD_SOURCE	 STRING(10)			 !Transaction Source
STD_REF		 STRING(25)			 !Transaction Reference
REVERSE		 STRING(1)			 !Reverse Next Period?
TRAN_TYPE	 STRING(1)			 !Transaction Type
	     . .

GLSGENTRN    FILE,PRE(GEN),NAME(GLSGENTRAN),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
DOC_KEY	       KEY(GEN:DOCUMENT)
RECORD	       RECORD
DOCUMENT	 LONG				 !DOCUMENT NBR
GL_CODE		 STRING(12)			 !General Ledger Code
TRAN_DATE	 LONG				 !Transaction Date
TRAN_TIME	 LONG				 !Transaction Time (system time)
TRAN_DEBIT	 DECIMAL(11,2)			 !Transaction Amount (Debit)
TRAN_CREDIT	 DECIMAL(11,2)			 !Transaction Amount (Credit)
GEN_SOURCE	 STRING(10)			 !Transaction Source
GEN_REF		 STRING(25)			 !Reference
REVERSE		 STRING(1)			 !Reverse Next Period?
PERIOD		 BYTE				 !Posting Period
	     . .

GLSREVTRN    FILE,PRE(REV),NAME(GLSREVTRAN),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(REV:GL_CODE),DUP,NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Code
TRAN_DATE	 LONG				 !Transaction Date
TRAN_TIME	 LONG				 !Transaction Time (system time)
TRAN_DEBIT	 DECIMAL(11,2)			 !Transaction Amount (Debit)
TRAN_CREDIT	 DECIMAL(11,2)			 !Transaction Amount (Credit)
GEN_SOURCE	 STRING(10)			 !Transaction Source
GEN_REF		 STRING(25)			 !Reference
	     . .

GLSARKHIVE   FILE,PRE(ARC),NAME(GLSARCHIVE),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
DATE_KEY       KEY(ARC:GL_CODE,ARC:TRAN_DATE),DUP,NOCASE
SOURCE_KEY     KEY(ARC:TRN_SRC,ARC:GL_CODE),DUP,NOCASE
RECORD	       RECORD
DOCUMENT	 LONG				 !DOCUMENT NBR
GL_CODE		 STRING(12)			 !General Ledger Code
TRAN_DATE	 LONG				 !Transaction Date
TRAN_DEBIT	 DECIMAL(11,2)			 !Transaction Amount
TRAN_CREDIT	 DECIMAL(11,2)			 !Transaction Amount
TRN_SRC		 STRING(10)			 !Transaction Source
TRN_REF		 STRING(25)			 !Transaction Reference
	     . .

GLSSYSINFO   FILE,PRE(GNF),NAME(GSYSINFO),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
DOC_NBR		 LONG				 !INTERNAL DOCUMENT NBR
	     . .

GLSLAYOUT    FILE,PRE(LAY),NAME(LAYNAME),CREATE,RECLAIM,PROTECT
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(LAY:CODE),NOCASE,OPT
RECORD	       RECORD
CODE		 STRING(10)			 !Layout Code
NAME		 STRING(30)			 !Layout Name
TYPE		 STRING(1)			 !TYPE OF LAYOUT
ACCT_NBRS	 STRING(1)			 !SHOW ACCT NBRS
RATIOS		 STRING(1)			 !SHOW RATIOS
B_C		 STRING(1)			 !SHOW BUDGET/COMPARATIVES
MARK		 BYTE				 !SELECTION MARK
	     . .

GLSLAYDETL   FILE,PRE(LDT),NAME(LAYDETNAME),CREATE,RECLAIM,PROTECT
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(LDT:CODE,LDT:SEQ),NOCASE,OPT
RECORD	       RECORD
CODE		 STRING(10)			 !Layout Code
SEQ		 LONG				 !Report Sequencen Number
FUNC		 STRING(12)			 !What to print?
NAME		 STRING(30)			 !Detail line to print
P_A		 STRING(1)			 !Print or Accumulate
COLUMN		 BYTE				 !Column to print in
PAREN		 STRING(1)			 !PARENTHISES CONTROL
	     . .

CONFIG	     FILE,NAME('CONFIG.DAT'),PRE(CFG),PROTECT
	     OWNER('MjamesA'),ENCRYPT
RECORD	     RECORD
TYPE	       BYTE
	     . .

GLS	     FILE,PRE(GLS),NAME('GLS.DAT'),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
DRECORD	       RECORD
FILE1		 STRING(50)			 !FILE SPEC BUDGET FILE
FILE2		 STRING(50)			 !FILE SPEC HISTORY FILE
FILE3		 STRING(50)			 !FILE SPEC ACCOUNTS FILE
FILE4		 STRING(50)			 !FILE SPEC STD TRANSACTION FILE
FILE5		 STRING(50)			 !FILE SPEC GEN TRANSACTION FILE
FILE6		 STRING(50)			 !FILE SPEC ARCHIVE FILE
FILE7		 STRING(50)			 !FILE SPEC SYSINFO FILE
FILE8		 STRING(50)			 !FILE SPEC PERIODS FILE
FILE9		 STRING(50)			 !FILE SPEC BALANCES FILE
FILE10		 STRING(50)			 !FILE SPEC REVERSED TRANACTION FILE
FILE11		 STRING(50)			 !FILE SPEC LAYOUT NAME
FILE12		 STRING(50)			 !FILE SPEC LAYOUT DETAIL
DEAD_DATE	 LONG				 !DEMONSTRATION DEATH DATE
NAME		 STRING(30)			 !SYSTEM LICENSED TO . . .
	     . .

GLSBUDGET    STRING(50)
GLSHISTORY   STRING(50)
GLSACCOUNTS  STRING(50)
GLSSTDTRAN   STRING(50)
GLSGENTRAN   STRING(50)
GLSREVTRAN   STRING(50)
GLSARCHIVE   STRING(50)
GSYSINFO     STRING(50)
GLSPERIODS   STRING(50)
GLSBALANCES  STRING(50)
LAYNAME	     STRING(50)
LAYDETNAME   STRING(50)

!
! SYSTEM-WIDE FILES
!
GAS	     FILE,PRE(GAS),NAME('GAS.DAT'),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
DRECORD	       RECORD
FILE1		 STRING(50)			 !FILE SPEC INFO FILE
FILE2		 STRING(50)			 !FILE SPEC PRINTER FILE
DEAD_DATE	 LONG				 !DEMONSTRATION DEATH DATE
NAME		 STRING(30)			 !SYSTEM LICENSED TO . . .
	     . .

INFO	     FILE,NAME(INFNAME),PRE(INF),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
CO_RPT		 STRING(60)			 !Company Report Name
CO_DISP		 STRING(30)			 !Company Display Name
CO_ADDR1	 STRING(30)			 !Company Address Line 1
CO_ADDR2	 STRING(30)			 !Company Address Line 2
CO_CITY		 STRING(25)			 !Company City
CO_STATE	 STRING(2)			 !Company State
CO_ZIP		 LONG				 !Company Zip Code
CO_PHONE	 STRING(12)			 !Company Phone Number
PRINTER_1	 STRING(40)			 !Printer Name
PRINT1_TYPE	 STRING(1)			 !Printer Type
PRINT_LOC1	 STRING(4)			 !Printer Location
PRINTER_2	 STRING(40)			 !Printer 2 Type
PRINT2_TYPE	 STRING(1)			 !Printer Type
PRINT_LOC2	 STRING(4)			 !Printer Location
	     . .

PRTFILE	  FILE,NAME(PRTNAME),RECLAIM,PROTECT
	  OWNER('MjamesA'),ENCRYPT
PRTKEY	    KEY(PRINTER,DESCRIP)		 !PRINTER KEY
RECORD	    RECORD
KEYGRP	      GROUP				 !KEY GROUP
PRINTER		STRING(8)			 !  PRINTER CODE
DESCRIP		STRING(25)			 !  FULL DESCRIPTION OF PRINTER
	      .					 !END KEY GROUP
CODEGRP	      GROUP				 !CODE GROUP
DPPRNT		STRING(5)			 !  DATA PROCESSING MODE ON
LQPRNT		STRING(5)			 !  LETTER QUALITY MODE ON
DWON		STRING(5)			 !  DOUBLE WIDE ON
DWOFF		STRING(5)			 !  DOUBLE WIDE OFF
DHON		STRING(5)			 !  DOUBLE HIGH ON
DHOFF		STRING(5)			 !  DOUBLE HIGH OFF
ULON		STRING(5)			 !  UNDERLINE ON
ULOFF		STRING(5)			 !  UNDERLINE OFF
BOLDON		STRING(5)			 !  BOLDFACE ON
BOLDOFF		STRING(5)			 !  BOLDFACE OFF
OVERON		STRING(5)			 !  OVERSTRIKE ON
OVEROFF		STRING(5)			 !  OVERSTRIKE OFF
SUPERON		STRING(5)			 !  SUPERSCRIPT ON
SUBON		STRING(5)			 !  SUBSCRIPT ON
SSOFF		STRING(5)			 !  SUPER/SUBSCRIPT OFF
ITLICON		STRING(5)			 !  ITALICS ON
ITLICOFF	STRING(5)			 !  ITALICS OFF
CPI10		STRING(5)			 !  10 CHARACTERS PER INCH(PICA)
CPI12		STRING(5)			 !  12 CHARACTERS PER INCH(ELITE)
CPI17		STRING(5)			 !  CONDENSED MODE
CPI17CANCEL	STRING(5)			 !  CANCEL CONDENSED MODE
BACKSPC		STRING(5)			 !  BACKSPACE CHARACTER
LINEFD		STRING(5)			 !  LINEFEED
FORMFD		STRING(5)			 !  FORMFEED
CR		STRING(5)			 !  CARRIAGE RETURN
MODELFCR	STRING(5)			 !  EACH LF = LF+CR
MODELF		STRING(5)			 !  LF ONLY, NO CR
MODECR		STRING(5)			 !  CR ONLY, NO LF
MODECRLF	STRING(5)			 !  EACH CR = CR+LF
UNIDIREC	STRING(5)			 !  UNIDERECTIONAL PRINT ONLY
BIDIREC		STRING(5)			 !  BIDIRECTIONAL PRINTING
RESET		STRING(5)			 !  PRINTER RESET
DUMMY1		STRING(5)			 !
DUMMY2		STRING(5)			 !
DUMMY3		STRING(5)			 ! RESERVED FOR FUTURE
DUMMY4		STRING(5)			 !	    USE
DUMMY5		STRING(5)			 !
DUMMY6		STRING(5)			 !
REVPRT		STRING(5)			 ! REVERSE PRINT
CANREVPRT	STRING(5)			 ! CANCEL REVERSE PRINT
	  . . .					 !END FILE, RECORD, GROUP

INFNAME	     STRING(50)
PRTNAME	     STRING(50)
