                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Update_Detail PROCEDURE

LocalRequest         LONG,AUTO
OriginalRequest      LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
WindowInitialized    LONG
ForceRefresh         LONG,AUTO
ActionMessage        CSTRING(40)
RecordChanged        BYTE,AUTO
RecordFiltered       LONG
SAV::det:Record      STRING(SIZE(det:Record))
Queue:Browse         QUEUE                        ! Browsing Queue
BRW4::PRO:Product      LIKE(PRO:Product)          ! Queue Display field
BRW4::PRO:Cost         LIKE(PRO:Cost)             ! Queue Display field
BRW4::PRO:Distributor  LIKE(PRO:Distributor)      ! Queue Display field
BRW4::PRO:Contact      LIKE(PRO:Contact)          ! Queue Display field
BRW4::PRO:Phone        LIKE(PRO:Phone)            ! Queue Display field
BRW4::PRO:Terms        LIKE(PRO:Terms)            ! Queue Display field
BRW4::Position         STRING(255)                ! Queue POSITION information
BRW4::Mark             BYTE                       ! Queue POSITION information
                     END                          ! END (Browsing Queue)
BRW4::RecordStatus   BYTE                         ! Flag for Range/Filter test
BRW4::InitializePage BYTE                         ! Flag for Range/Filter test
BRW4::ItemsToFill    LONG                         ! Controls records retrieved
BRW4::MaxItemsInList LONG                         ! Retrieved after window opened
BRW4::LocatedPosition STRING(255)                 ! POSITION of located record
BRW4::QueuePointer   LONG                         ! Queue position of located record
BRW4::NextChoice     LONG                         ! Queue position of located record
BRW4::CurrentScroll  BYTE                         ! Queue position of scroll thumb
BRW4::CurrentScrollRecord LONG                    ! Queue position of scroll thumb
FormWindow           WINDOW('Update Estimate Details'),AT(8,5,243,159),CENTER,SYSTEM,GRAY,MDI
                       ENTRY(@s20),AT(40,4,,),USE(det:Product)
                       ENTRY(@n5),AT(40,18,,),USE(det:quantity)
                       ENTRY(@n10.2),AT(110,18,42,12),USE(det:cost)
                       ENTRY(@n10.2),AT(196,18,,),USE(det:total_cost),READONLY
                       ENTRY(@n10.2),AT(110,32,42,12),USE(det:sell)
                       ENTRY(@n10.2),AT(196,32,,),USE(det:total_sell),READONLY
                       ENTRY(@N$-10.2),AT(196,46,44,12),USE(det:profit),READONLY
                       ENTRY(@s35),AT(40,60,200,12),USE(det:note)
                       BUTTON('OK'),AT(6,142,40,12),USE(?OK),DEFAULT
                       BUTTON('Cancel'),AT(48,142,40,12),USE(?Cancel)
                       BUTTON('&Insert'),AT(112,142,42,12),USE(?Insert)
                       BUTTON('&Change'),AT(154,142,42,12),USE(?Change)
                       BUTTON('&Delete'),AT(196,142,42,12),USE(?Delete)
                       STRING('Product / Service Reference List'),AT(8,76,,),FONT('Arial',10,0800000H,FONT:bold+FONT:italic),USE(?String2)
                       LIST,AT(8,86,231,54),MSG('Browsing Records'),USE(?List),IMM,HVSCROLL,FORMAT('83L~Product~@s20@?43L~Cost~@n10.2@104L~Distributor~@s25@104L~Contact~@s25@67L~Ph' &|
         'one~@s15@100L~Terms~@s25@'),FROM(Queue:Browse)
                       PROMPT('&Qty:'),AT(22,18,16,10),USE(?det:quantity:Prompt)
                       PROMPT('&Cost Each:'),AT(74,18,36,10),USE(?det:cost:Prompt)
                       PROMPT('&Sell Each:'),AT(76,32,33,10),USE(?det:sell:Prompt:1)
                       STRING('Product:'),AT(8,4,,),USE(?String1)
                       PROMPT('&Total cost:'),AT(158,18,36,10),USE(?det:total_cost:Prompt)
                       PROMPT('&Total sell:'),AT(160,32,35,10),USE(?det:total_sell:Prompt)
                       PROMPT('&Profit $$:'),AT(162,46,32,10),USE(?det:profit:Prompt)
                       PROMPT('&Notes:'),AT(16,60,22,10),USE(?det:note:Prompt)
                     END
  CODE
  LocalRequest = GlobalRequest
  OriginalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  ForceRefresh = False
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Product::Used = 0
    CheckOpen(Product,1)
  END
  Product::Used += 1
  IF detail::Used = 0
    CheckOpen(detail,1)
  END
  detail::Used += 1
  SAV::det:Record = det:Record
  IF LocalRequest = InsertRecord
    DO PrimeFields
  END
    IF LocalRequest = DeleteRecord
      IF StandardWarning(Warn:StandardDelete) = Button:OK
        LOOP
          LocalResponse = RequestCancelled
          SETCURSOR(Cursor:Wait)
          IF RIDelete:detail()
            SETCURSOR()
            CASE StandardWarning(Warn:DeleteError)
            OF Button:Yes
              CYCLE
            OF Button:No OROF Button:Cancel
              BREAK
            END
          ELSE
            SETCURSOR()
            LocalResponse = RequestCompleted
          END
          BREAK
        END
      END
      DO ProcedureReturn
    END
  OPEN(FormWindow)
  WindowOpened=True
  CASE LocalRequest
  OF InsertRecord
    ActionMessage = 'Record will be Added'
  OF ChangeRecord
    ActionMessage = 'Record will be Changed'
  OF DeleteRecord
  END
  FormWindow{Prop:StatusText,1} = ActionMessage
  SET(PRO:Key_Product)
  ?List{Prop:Alrt,251} = MouseLeft2
  ?List{Prop:Alrt,255} = InsertKey
  ?List{Prop:Alrt,254} = DeleteKey
  ?List{Prop:Alrt,253} = CtrlEnter
  ACCEPT
    CASE EVENT()
    OF EVENT:CloseWindow
      IF LocalResponse <> RequestCompleted
        RecordChanged = False
        IF LocalRequest = InsertRecord OR LocalRequest = ChangeRecord
          IF SAV::det:Record <> det:Record
            RecordChanged = True
          END
        END
        IF RecordChanged
          CASE StandardWarning(Warn:ConfirmCancel)
          OF Button:Yes
            POST(Event:Accepted,?OK)
            CYCLE
          OF Button:No
          OF BUTTON:Cancel
            SELECT(?det:Product)
            CYCLE
          END
        END
      END
    OF EVENT:CloseDown
      IF LocalResponse <> RequestCompleted
        RecordChanged = False
        IF LocalRequest = InsertRecord OR LocalRequest = ChangeRecord
          IF SAV::det:Record <> det:Record
            RecordChanged = True
          END
        END
        IF RecordChanged
          CASE StandardWarning(Warn:ConfirmCancel)
          OF Button:Yes
            POST(Event:Accepted,?OK)
            CYCLE
          OF Button:No
          OF BUTTON:Cancel
            SELECT(?det:Product)
            CYCLE
          END
        END
      END
    OF EVENT:OpenWindow
      IF NOT WindowInitialized
        DO InitializeWindow
      END
      SELECT(?det:Product)
    OF EVENT:GainFocus
      WindowInitialized = True
      DO InitializeWindow
    ELSE
      IF EVENT() = Event:Completed
        CASE LocalRequest
        OF InsertRecord
          ADD(detail)
          CASE ERRORCODE()
          OF NoError
            LocalResponse = RequestCompleted
            POST(Event:CloseWindow)
          ELSE
            IF StandardWarning(Warn:InsertError)
              SELECT(?det:Product)
              CYCLE
            END
          END
        OF ChangeRecord
          LOOP
            LocalResponse = RequestCancelled
            SETCURSOR(Cursor:Wait)
            IF RIUpdate:detail(SAV::det:Record)
              SETCURSOR()
              CASE StandardWarning(Warn:UpdateError)
              OF Button:Yes
                CYCLE
              OF Button:No
                POST(Event:CloseWindow)
                BREAK
              OF Button:Cancel
                SELECT(?det:Product)
                BREAK
              END
            ELSE
              SETCURSOR()
              LocalResponse = RequestCompleted
              POST(Event:CloseWindow)
            END
            BREAK
          END
        END
      END
    END
    CASE FIELD()
    OF ?det:cost
      CASE EVENT()
      OF EVENT:Accepted
        det:total_cost=det:quantity*det:cost
      END
    OF ?det:sell
      CASE EVENT()
      OF EVENT:Accepted
        det:total_sell=det:quantity*det:sell
        det:profit=det:total_sell-det:total_cost
      END
    OF ?OK
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF OriginalRequest = ChangeRecord OR OriginalRequest = InsertRecord
          SELECT()
        ELSE
          POST(EVENT:Completed)
        END
      END
    OF ?Cancel
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    OF ?Insert
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW4::ButtonInsert
      END
    OF ?Change
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW4::ButtonChange
      END
    OF ?Delete
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW4::ButtonDelete
      END
    OF ?List
      CASE EVENT()
      OF EVENT:NewSelection
        DO BRW4::NewSelection
      OF EVENT:ScrollUp
        DO BRW4::ScrollUp
      OF EVENT:ScrollDown
        DO BRW4::ScrollDown
      OF EVENT:PageUp
        DO BRW4::PageUp
      OF EVENT:PageDown
        DO BRW4::PageDown
      OF EVENT:ScrollTop
        DO BRW4::ScrollTop
      OF EVENT:ScrollBottom
        DO BRW4::ScrollBottom
      OF EVENT:AlertKey
        DO BRW4::AlertKey
      OF EVENT:ScrollDrag
        IF ?List{Prop:VScrollPos} = 1
          POST(Event:ScrollTop,?List)
        ELSIF ?List{Prop:VScrollPos} = 100
          POST(Event:ScrollBottom,?List)
        ELSE
          CYCLE
        END
      END
    END
  END
  DO ProcedureReturn
!---------------------------------------------------------------------------
ProcedureReturn ROUTINE
  Product::Used -= 1
  IF Product::Used = 0 THEN CLOSE(Product).
  detail::Used -= 1
  IF detail::Used = 0 THEN CLOSE(detail).
  IF WindowOpened
    CLOSE(FormWindow)
  END
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!---------------------------------------------------------------------------
InitializeWindow ROUTINE
  DO BRW4::OpenWindow
  DO RefreshWindow
!---------------------------------------------------------------------------
RefreshWindow ROUTINE
  IF ForceRefresh
    GET(Queue:Browse,CHOICE(?List))
    REGET(PRO:Key_Product,BRW4::Position)
  ELSE
    DO BRW4::FillBuffer
  END
  DO BRW4::ValidateRecord
  IF BRW4::RecordStatus <> Record:OK
    DO BRW4::InitializeBrowse
  ELSE
    IF ForceRefresh
      DO BRW4::LocateRecord
    ELSE
      DO BRW4::FillBuffer
    END
  END
  ?List{Prop:VScrollPos} = BRW4::CurrentScroll
  DISPLAY()
  ForceRefresh = False
!---------------------------------------------------------------------------
SyncWindow ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,CHOICE(?List))
    REGET(PRO:Key_Product,BRW4::Position)
  END
!---------------------------------------------------------------------------
PrimeFields ROUTINE
  det:Record = SAV::det:Record
  SAV::det:Record = det:Record
BRW4::OpenWindow ROUTINE
  IF LocalRequest = SelectRecord
    SET(PRO:Key_Product,PRO:Key_Product)
    DO BRW4::LocateRecord
  ELSE
    DO BRW4::InitializeBrowse
    SELECT(?List,1)
  END
  DO BRW4::FillBuffer
!----------------------------------------------------------------------
BRW4::InitializeBrowse ROUTINE
  BRW4::InitializePage = True
  DO BRW4::RefreshPage
  GET(Queue:Browse,1)
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::FillBuffer ROUTINE
  GET(Queue:Browse,CHOICE(?List))
  PRO:Product = BRW4::PRO:Product
  PRO:Cost = BRW4::PRO:Cost
  PRO:Distributor = BRW4::PRO:Distributor
  PRO:Contact = BRW4::PRO:Contact
  PRO:Phone = BRW4::PRO:Phone
  PRO:Terms = BRW4::PRO:Terms
!----------------------------------------------------------------------
BRW4::ResetLow ROUTINE
  SET(PRO:Key_Product)
!----------------------------------------------------------------------
BRW4::ResetHigh ROUTINE
  SET(PRO:Key_Product)
!----------------------------------------------------------------------
BRW4::ResetClear ROUTINE
  SET(PRO:Key_Product)
!----------------------------------------------------------------------
BRW4::FillQueue ROUTINE
  BRW4::PRO:Product = PRO:Product
  BRW4::PRO:Cost = PRO:Cost
  BRW4::PRO:Distributor = PRO:Distributor
  BRW4::PRO:Contact = PRO:Contact
  BRW4::PRO:Phone = PRO:Phone
  BRW4::PRO:Terms = PRO:Terms
  BRW4::Position = POSITION(PRO:Key_Product)
!----------------------------------------------------------------------
BRW4::NewSelection ROUTINE
  IF RECORDS(Queue:Browse)
    DO BRW4::FillBuffer
    DO RefreshWindow
  END
!----------------------------------------------------------------------
BRW4::ScrollUp ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)>1
      SELECT(?List, CHOICE(?List)-1)
    ELSE
      GET(Queue:Browse,1)                         ! Get the first queue item
      RESET(PRO:Key_Product,BRW4::Position)       ! Reset for sequential processing
      PREVIOUS(Product)                           ! Retrieve record, reverse access
      BRW4::ItemsToFill = 1                       ! Load a single item
      DO BRW4::FillBackward                       ! Fill with previous read(s)
      IF BRW4::ItemsToFill                        ! If Load failed
        BRW4::CurrentScroll = 0                   ! Move Thumb to top
      ELSE
        BRW4::CurrentScroll = 50                  ! Move Thumb to center
      END
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ScrollDown ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)<RECORDS(Queue:Browse)
      SELECT(?List, CHOICE(?List)+1)
    ELSE
      GET(Queue:Browse,RECORDS(Queue:Browse))     ! Get the last queue item
      RESET(PRO:Key_Product,BRW4::Position)       ! Reset for sequential processing
      NEXT(Product)                               ! Retrieve record, forward access
      BRW4::ItemsToFill = 1                       ! load a single item
      DO BRW4::FillForward                        ! Fill with next read(s)
      IF BRW4::ItemsToFill                        ! If Load failed
        BRW4::CurrentScroll = 100                 ! Move Thumb to top
      ELSE
        BRW4::CurrentScroll = 50                  ! Move Thumb to center
      END
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::PageUp ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,1)                           ! Get the first queue item
    RESET(PRO:Key_Product,BRW4::Position)         ! Reset for sequential processing
    PREVIOUS(Product)                             ! Retrieve record, reverse access
    BRW4::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW4::FillBackward                         ! Fill with previous read(s)
    IF BRW4::ItemsToFill
      BRW4::NextChoice = CHOICE(?List)-BRW4::ItemsToFill
      IF BRW4::NextChoice < 1
        BRW4::NextChoice = 1
      END
      SELECT(?List, BRW4::NextChoice)
      BRW4::CurrentScroll = 0                     ! Move Thumb to top
    ELSE
      BRW4::CurrentScroll = 50                    ! Move Thumb to center
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::PageDown ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,RECORDS(Queue:Browse))       ! Get the last queue item
    RESET(PRO:Key_Product,BRW4::Position)         ! Reset for sequential processing
    NEXT(Product)                                 ! Retrieve record, forward access
    BRW4::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW4::FillForward                          ! Fill with next read(s)
    IF BRW4::ItemsToFill
      BRW4::NextChoice = CHOICE(?List)+BRW4::ItemsToFill
      IF BRW4::NextChoice > RECORDS(Queue:Browse)
        BRW4::NextChoice = RECORDS(Queue:Browse)
      END
      SELECT(?List, BRW4::NextChoice)
      BRW4::CurrentScroll = 100                   ! Move Thumb to top
    ELSE
      BRW4::CurrentScroll = 50                    ! Move Thumb to center
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ScrollTop ROUTINE
  IF RECORDS(Queue:Browse)
    BRW4::InitializePage = True
    DO BRW4::RefreshPage
    SELECT(?List,1)                               ! Select first list item
    BRW4::CurrentScroll = 0
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ScrollBottom ROUTINE
  IF RECORDS(Queue:Browse)
    SETCURSOR(Cursor:Wait)
    FREE(Queue:Browse)                            ! Free the browse queue
    DO BRW4::ResetHigh                            ! Reset for first page access
    BRW4::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW4::FillBackward                         ! Fill with previous read(s)
    SELECT(?List, RECORDS(Queue:Browse))          ! Select last list item
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      BRW4::CurrentScroll = 100
    ELSE
      BRW4::CurrentScroll = 0
    END
    SETCURSOR()
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::AlertKey ROUTINE
  IF RECORDS(Queue:Browse)
    CASE KEYCODE()                                ! What keycode was hit
    OF MouseLeft2
      POST(Event:Accepted,?Change)
      DO BRW4::FillBuffer
    OF InsertKey
      POST(Event:Accepted,?Insert)
    OF DeleteKey
      POST(Event:Accepted,?Delete)
    OF CtrlEnter
      POST(Event:Accepted,?Change)
    ELSE                                          ! ELSE (What keycode was hit)
      IF CHR(KEYCHAR())
        DO BRW4::ResetClear
        PRO:Product = CHR(KEYCHAR())
        DO BRW4::LocateRecord                     ! Find the record
      END
    END                                           ! END (What keycode was hit)
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ValidateRecord ROUTINE
  BRW4::RecordStatus = Record:OutOfRange
  BRW4::RecordStatus = Record:OK
  EXIT
!----------------------------------------------------------------------
BRW4::FillForward ROUTINE
  LOOP WHILE BRW4::ItemsToFill
    NEXT(Product)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BEGIN
        DO BRW4::ResetHigh                        ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,1)
      DELETE(Queue:Browse)
    END
    BRW4::ItemsToFill -= 1
    DO BRW4::FillQueue
    ADD(Queue:Browse)
  END
  EXIT
!----------------------------------------------------------------------
BRW4::FillBackward ROUTINE
  LOOP WHILE BRW4::ItemsToFill
    PREVIOUS(Product)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BEGIN
        DO BRW4::ResetLow                         ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,RECORDS(Queue:Browse))
      DELETE(Queue:Browse)
    END
    BRW4::ItemsToFill -= 1
    DO BRW4::FillQueue
    ADD(Queue:Browse,1)
  END
  EXIT
!----------------------------------------------------------------------
BRW4::LocateRecord ROUTINE
  SETCURSOR(Cursor:Wait)
  FREE(Queue:Browse)
  SET(PRO:Key_Product,PRO:Key_Product)
  BRW4::LocatedPosition = ''
  LOOP
    NEXT(Product)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BREAK
      CYCLE
    END
    BRW4::LocatedPosition = POSITION(PRO:Key_Product)
    RESET(PRO:Key_Product,BRW4::LocatedPosition)
    BREAK
  END
  BRW4::ItemsToFill = ?List{Prop:Items}
  BRW4::CurrentScroll = 50
  DO BRW4::FillForward
  IF BRW4::ItemsToFill
    BRW4::CurrentScroll = 100
    IF ~RECORDS(Queue:Browse)
      DO BRW4::ResetHigh                          ! Reset for first page access
    ELSE
      GET(Queue:Browse,1)
      RESET(PRO:Key_Product,BRW4::Position)
      PREVIOUS(Product)
    END
    DO BRW4::FillBackward
    IF BRW4::ItemsToFill
      BRW4::CurrentScroll = 0
    END
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(PRO:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
    ?Delete{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    IF BRW4::LocatedPosition
      BRW4::QueuePointer = 1
      LOOP
        GET(Queue:Browse,BRW4::QueuePointer)
        IF ERRORCODE() THEN BREAK.
        IF BRW4::Position = BRW4::LocatedPosition THEN BREAK.
        BRW4::QueuePointer += 1
      END
    ELSE
      BRW4::QueuePointer = RECORDS(Queue:Browse)
    END
    SELECT(?List,BRW4::QueuePointer)
    DO BRW4::FillBuffer
    ?Change{Prop:Disable} = 0
    ?Delete{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------------
BRW4::RefreshPage ROUTINE
  SETCURSOR(Cursor:Wait)
  IF BRW4::InitializePage
    DO BRW4::ResetLow
  ELSE
    FREE(Queue:Browse)
    GET(Queue:Browse,1)
    RESET(PRO:Key_Product,BRW4::Position)
  END
  FREE(Queue:Browse)
  BRW4::ItemsToFill = ?List{Prop:Items}
  BRW4::CurrentScroll = 50
  DO BRW4::FillForward
  IF NOT BRW4::InitializePage
    IF BRW4::ItemsToFill
      GET(Queue:Browse,1)
      RESET(PRO:Key_Product,BRW4::Position)
      PREVIOUS(Product)
      BRW4::CurrentScroll = 100
      DO BRW4::FillBackward
    END
  END
  IF BRW4::ItemsToFill
    BRW4::CurrentScroll = 0
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(PRO:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
    ?Delete{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    DO BRW4::FillBuffer
    ?Change{Prop:Disable} = 0
    ?Delete{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------
BRW4::ButtonInsert ROUTINE
  GET(Product,0)
  CLEAR(PRO:Record,0)
  SET(PRO:Key_Product)
  LocalRequest = InsertRecord
  DO BRW4::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW4::ValidateRecord
    IF BRW4::RecordStatus = Record:OK
      DO BRW4::LocateRecord
    END
  END
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW4::ButtonChange ROUTINE
  LocalRequest = ChangeRecord
  DO BRW4::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW4::ValidateRecord
    IF BRW4::RecordStatus = Record:OK
      DO BRW4::LocateRecord
    ELSE
      SELECT(?List,CHOICE(?List))
    END
  END
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW4::ButtonDelete ROUTINE
  LocalRequest = DeleteRecord
  DO BRW4::CallUpdate
  IF LocalResponse = RequestCompleted
    DELETE(Queue:Browse)
    DO BRW4::RefreshPage
  END
  SELECT(?List,CHOICE(?List))
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW4::CallUpdate ROUTINE
  GlobalRequest = LocalRequest
  Update_Product
  LocalResponse = GlobalResponse
