                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Browse_company PROCEDURE

LocalRequest         LONG,AUTO
OriginalRequest      LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
WindowInitialized    LONG
ForceRefresh         LONG,AUTO
RecordFiltered       LONG
Queue:Browse         QUEUE                        ! Browsing Queue
BRW1::COM:Companyname  LIKE(COM:Companyname)      ! Queue Display field
BRW1::COM:Phone        LIKE(COM:Phone)            ! Queue Display field
BRW1::COM:Contact      LIKE(COM:Contact)          ! Queue Display field
BRW1::Position         STRING(255)                ! Queue POSITION information
BRW1::Mark             BYTE                       ! Queue POSITION information
                     END                          ! END (Browsing Queue)
BRW1::RecordStatus   BYTE                         ! Flag for Range/Filter test
BRW1::InitializePage BYTE                         ! Flag for Range/Filter test
BRW1::ItemsToFill    LONG                         ! Controls records retrieved
BRW1::MaxItemsInList LONG                         ! Retrieved after window opened
BRW1::LocatedPosition STRING(255)                 ! POSITION of located record
BRW1::QueuePointer   LONG                         ! Queue position of located record
BRW1::NextChoice     LONG                         ! Queue position of located record
BrowseWindow         WINDOW('Your Company Information'),AT(-1,-1,271,50),SYSTEM,GRAY,MDI
                       LIST,AT(5,5,259,19),MSG('Browsing Records'),USE(?List),IMM,FORMAT('124L~Company~@s30@65L~Phone~@s15@80L~Contact~@s20@'),FROM(Queue:Browse)
                       BUTTON('&Change'),AT(6,33,40,12),KEY(CtrlEnter),USE(?Change),DEFAULT
                       BUTTON('&Select'),AT(48,33,40,12),KEY(EnterKey),USE(?Select)
                       BUTTON('Close'),AT(225,32,40,12),USE(?Close)
                     END
  CODE
  LocalRequest = GlobalRequest
  OriginalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  ForceRefresh = False
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Company::Used = 0
    CheckOpen(Company,1)
  END
  Company::Used += 1
  OPEN(BrowseWindow)
  WindowOpened=True
  SET(COM:Key_Companyname)
  ?List{Prop:Alrt,251} = MouseLeft2
  IF LocalRequest = SelectRecord
    ?Select{Prop:Hide} = False
    ENABLE(?Select)
    ?Select{Prop:Default} = True
  ELSE
    ?Select{Prop:Hide} = True
    DISABLE(?Select)
  END
  ?List{Prop:Alrt,253} = CtrlEnter
  ACCEPT
    CASE EVENT()
    OF EVENT:OpenWindow
      IF NOT WindowInitialized
        DO InitializeWindow
      END
      SELECT(?List)
    OF EVENT:GainFocus
      WindowInitialized = True
      DO InitializeWindow
    END
    CASE FIELD()
    OF ?List
      CASE EVENT()
      OF EVENT:NewSelection
        DO BRW1::NewSelection
      OF EVENT:ScrollUp
        DO BRW1::ScrollUp
      OF EVENT:ScrollDown
        DO BRW1::ScrollDown
      OF EVENT:PageUp
        DO BRW1::PageUp
      OF EVENT:PageDown
        DO BRW1::PageDown
      OF EVENT:ScrollTop
        DO BRW1::ScrollTop
      OF EVENT:ScrollBottom
        DO BRW1::ScrollBottom
      OF EVENT:AlertKey
        DO BRW1::AlertKey
      END
    OF ?Change
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW1::ButtonChange
      END
    OF ?Select
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCompleted
        POST(Event:CloseWindow)
      END
    OF ?Close
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    END
  END
  DO ProcedureReturn
!---------------------------------------------------------------------------
ProcedureReturn ROUTINE
  Company::Used -= 1
  IF Company::Used = 0 THEN CLOSE(Company).
  IF WindowOpened
    CLOSE(BrowseWindow)
  END
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!---------------------------------------------------------------------------
InitializeWindow ROUTINE
  DO BRW1::OpenWindow
  DO RefreshWindow
!---------------------------------------------------------------------------
RefreshWindow ROUTINE
  IF ForceRefresh
    GET(Queue:Browse,CHOICE(?List))
    REGET(COM:Key_Companyname,BRW1::Position)
  ELSE
    DO BRW1::FillBuffer
  END
  DO BRW1::ValidateRecord
  IF BRW1::RecordStatus <> Record:OK
    DO BRW1::InitializeBrowse
  ELSE
    IF ForceRefresh
      DO BRW1::LocateRecord
    ELSE
      DO BRW1::FillBuffer
    END
  END
  DISPLAY()
  ForceRefresh = False
!---------------------------------------------------------------------------
SyncWindow ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,CHOICE(?List))
    REGET(COM:Key_Companyname,BRW1::Position)
  END
!---------------------------------------------------------------------------
BRW1::OpenWindow ROUTINE
  IF LocalRequest = SelectRecord
    SET(COM:Key_Companyname,COM:Key_Companyname)
    DO BRW1::LocateRecord
  ELSE
    DO BRW1::InitializeBrowse
    SELECT(?List,1)
  END
  DO BRW1::FillBuffer
!----------------------------------------------------------------------
BRW1::InitializeBrowse ROUTINE
  BRW1::InitializePage = True
  DO BRW1::RefreshPage
  GET(Queue:Browse,1)
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::FillBuffer ROUTINE
  GET(Queue:Browse,CHOICE(?List))
  COM:Companyname = BRW1::COM:Companyname
  COM:Phone = BRW1::COM:Phone
  COM:Contact = BRW1::COM:Contact
!----------------------------------------------------------------------
BRW1::ResetLow ROUTINE
  SET(COM:Key_Companyname)
!----------------------------------------------------------------------
BRW1::ResetHigh ROUTINE
  SET(COM:Key_Companyname)
!----------------------------------------------------------------------
BRW1::ResetClear ROUTINE
  SET(COM:Key_Companyname)
!----------------------------------------------------------------------
BRW1::FillQueue ROUTINE
  BRW1::COM:Companyname = COM:Companyname
  BRW1::COM:Phone = COM:Phone
  BRW1::COM:Contact = COM:Contact
  BRW1::Position = POSITION(COM:Key_Companyname)
!----------------------------------------------------------------------
BRW1::NewSelection ROUTINE
  IF RECORDS(Queue:Browse)
    DO BRW1::FillBuffer
    DO RefreshWindow
  END
!----------------------------------------------------------------------
BRW1::ScrollUp ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)>1
      SELECT(?List, CHOICE(?List)-1)
    ELSE
      GET(Queue:Browse,1)                         ! Get the first queue item
      RESET(COM:Key_Companyname,BRW1::Position)   ! Reset for sequential processing
      PREVIOUS(Company)                           ! Retrieve record, reverse access
      BRW1::ItemsToFill = 1                       ! Load a single item
      DO BRW1::FillBackward                       ! Fill with previous read(s)
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ScrollDown ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)<RECORDS(Queue:Browse)
      SELECT(?List, CHOICE(?List)+1)
    ELSE
      GET(Queue:Browse,RECORDS(Queue:Browse))     ! Get the last queue item
      RESET(COM:Key_Companyname,BRW1::Position)   ! Reset for sequential processing
      NEXT(Company)                               ! Retrieve record, forward access
      BRW1::ItemsToFill = 1                       ! load a single item
      DO BRW1::FillForward                        ! Fill with next read(s)
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::PageUp ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,1)                           ! Get the first queue item
    RESET(COM:Key_Companyname,BRW1::Position)     ! Reset for sequential processing
    PREVIOUS(Company)                             ! Retrieve record, reverse access
    BRW1::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW1::FillBackward                         ! Fill with previous read(s)
    IF BRW1::ItemsToFill
      BRW1::NextChoice = CHOICE(?List)-BRW1::ItemsToFill
      IF BRW1::NextChoice < 1
        BRW1::NextChoice = 1
      END
      SELECT(?List, BRW1::NextChoice)
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::PageDown ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,RECORDS(Queue:Browse))       ! Get the last queue item
    RESET(COM:Key_Companyname,BRW1::Position)     ! Reset for sequential processing
    NEXT(Company)                                 ! Retrieve record, forward access
    BRW1::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW1::FillForward                          ! Fill with next read(s)
    IF BRW1::ItemsToFill
      BRW1::NextChoice = CHOICE(?List)+BRW1::ItemsToFill
      IF BRW1::NextChoice > RECORDS(Queue:Browse)
        BRW1::NextChoice = RECORDS(Queue:Browse)
      END
      SELECT(?List, BRW1::NextChoice)
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ScrollTop ROUTINE
  IF RECORDS(Queue:Browse)
    BRW1::InitializePage = True
    DO BRW1::RefreshPage
    SELECT(?List,1)                               ! Select first list item
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ScrollBottom ROUTINE
  IF RECORDS(Queue:Browse)
    SETCURSOR(Cursor:Wait)
    FREE(Queue:Browse)                            ! Free the browse queue
    DO BRW1::ResetHigh                            ! Reset for first page access
    BRW1::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW1::FillBackward                         ! Fill with previous read(s)
    SELECT(?List, RECORDS(Queue:Browse))          ! Select last list item
    SETCURSOR()
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::AlertKey ROUTINE
  IF RECORDS(Queue:Browse)
    CASE KEYCODE()                                ! What keycode was hit
    OF MouseLeft2
      IF LocalRequest = SelectRecord
        POST(Event:Accepted,?Select)
        EXIT
      END
      POST(Event:Accepted,?Change)
      DO BRW1::FillBuffer
    OF CtrlEnter
      POST(Event:Accepted,?Change)
    ELSE                                          ! ELSE (What keycode was hit)
      IF CHR(KEYCHAR())
        DO BRW1::ResetClear
        COM:Companyname = CHR(KEYCHAR())
        DO BRW1::LocateRecord                     ! Find the record
      END
    END                                           ! END (What keycode was hit)
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ValidateRecord ROUTINE
  BRW1::RecordStatus = Record:OutOfRange
  BRW1::RecordStatus = Record:OK
  EXIT
!----------------------------------------------------------------------
BRW1::FillForward ROUTINE
  LOOP WHILE BRW1::ItemsToFill
    NEXT(Company)
    IF ERRORCODE() THEN BREAK.
    DO BRW1::ValidateRecord
    EXECUTE(BRW1::RecordStatus)
      BEGIN
        DO BRW1::ResetHigh                        ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,1)
      DELETE(Queue:Browse)
    END
    BRW1::ItemsToFill -= 1
    DO BRW1::FillQueue
    ADD(Queue:Browse)
  END
  EXIT
!----------------------------------------------------------------------
BRW1::FillBackward ROUTINE
  LOOP WHILE BRW1::ItemsToFill
    PREVIOUS(Company)
    IF ERRORCODE() THEN BREAK.
    DO BRW1::ValidateRecord
    EXECUTE(BRW1::RecordStatus)
      BEGIN
        DO BRW1::ResetLow                         ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,RECORDS(Queue:Browse))
      DELETE(Queue:Browse)
    END
    BRW1::ItemsToFill -= 1
    DO BRW1::FillQueue
    ADD(Queue:Browse,1)
  END
  EXIT
!----------------------------------------------------------------------
BRW1::LocateRecord ROUTINE
  SETCURSOR(Cursor:Wait)
  FREE(Queue:Browse)
  SET(COM:Key_Companyname,COM:Key_Companyname)
  BRW1::LocatedPosition = ''
  LOOP
    NEXT(Company)
    IF ERRORCODE() THEN BREAK.
    DO BRW1::ValidateRecord
    EXECUTE(BRW1::RecordStatus)
      BREAK
      CYCLE
    END
    BRW1::LocatedPosition = POSITION(COM:Key_Companyname)
    RESET(COM:Key_Companyname,BRW1::LocatedPosition)
    BREAK
  END
  BRW1::ItemsToFill = ?List{Prop:Items}
  DO BRW1::FillForward
  IF BRW1::ItemsToFill
    IF ~RECORDS(Queue:Browse)
      DO BRW1::ResetHigh                          ! Reset for first page access
    ELSE
      GET(Queue:Browse,1)
      RESET(COM:Key_Companyname,BRW1::Position)
      PREVIOUS(Company)
    END
    DO BRW1::FillBackward
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(COM:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    IF BRW1::LocatedPosition
      BRW1::QueuePointer = 1
      LOOP
        GET(Queue:Browse,BRW1::QueuePointer)
        IF ERRORCODE() THEN BREAK.
        IF BRW1::Position = BRW1::LocatedPosition THEN BREAK.
        BRW1::QueuePointer += 1
      END
    ELSE
      BRW1::QueuePointer = RECORDS(Queue:Browse)
    END
    SELECT(?List,BRW1::QueuePointer)
    DO BRW1::FillBuffer
    ?Change{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------------
BRW1::RefreshPage ROUTINE
  SETCURSOR(Cursor:Wait)
  IF BRW1::InitializePage
    DO BRW1::ResetLow
  ELSE
    FREE(Queue:Browse)
    GET(Queue:Browse,1)
    RESET(COM:Key_Companyname,BRW1::Position)
  END
  FREE(Queue:Browse)
  BRW1::ItemsToFill = ?List{Prop:Items}
  DO BRW1::FillForward
  IF NOT BRW1::InitializePage
    IF BRW1::ItemsToFill
      GET(Queue:Browse,1)
      RESET(COM:Key_Companyname,BRW1::Position)
      PREVIOUS(Company)
      DO BRW1::FillBackward
    END
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(COM:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    DO BRW1::FillBuffer
    ?Change{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------
BRW1::ButtonChange ROUTINE
  LocalRequest = ChangeRecord
  DO BRW1::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW1::ValidateRecord
    IF BRW1::RecordStatus = Record:OK
      DO BRW1::LocateRecord
    ELSE
      SELECT(?List,CHOICE(?List))
    END
  END
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW1::CallUpdate ROUTINE
  GlobalRequest = LocalRequest
  Company
  LocalResponse = GlobalResponse

