                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Price_List PROCEDURE
RejectRecord         LONG,AUTO
LocalRequest         LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG,AUTO
RecordsToProcess     LONG,AUTO
RecordsProcessed     LONG,AUTO
RecordsPerCycle      LONG,AUTO
RecordsThisCycle     LONG,AUTO
PercentProgress      DECIMAL(4,1)
RecordStatus         BYTE,AUTO
Report               REPORT,AT(1000,2000,6000,7135),PRE(RPT),THOUS
                       HEADER,AT(1000,1000,6000,750),FONT('Arial',10,,)
                         STRING('Product / Service Price List'),AT(104,104,2917,313),FONT('Arial',16,0FF0000H,FONT:bold+FONT:italic),USE(?String8)
                         STRING('Product'),AT(104,417,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String9)
                         STRING('Cost'),AT(1979,417,417,208),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String10)
                         STRING('Supplier Information'),AT(2813,417,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String11)
                         LINE,AT(104,729,5833,0),USE(?Line1),COLOR(0FFH)
                       END
detail                 DETAIL,AT(,,,990)
                         STRING(@s20),AT(104,104,,),FONT('Arial',10,,FONT:bold),USE(PRO:Product)
                         STRING(@n10.2),AT(1667,104,,),FONT('Arial',10,,),USE(PRO:Cost)
                         STRING(@s25),AT(2708,104,,),FONT('Arial',10,,FONT:bold),USE(PRO:Distributor)
                         STRING(@s25),AT(2708,313,,),FONT('Arial',10,,),USE(PRO:Contact)
                         STRING(@s15),AT(4583,104,,),FONT('Arial',10,,),USE(PRO:Phone)
                         STRING(@s25),AT(2708,521,,),FONT('Arial',10,,),USE(PRO:Terms)
                         STRING(@s40),AT(2708,729,,),FONT('Arial',10,,),USE(PRO:Notes)
                         LINE,AT(2708,938,3229,0),USE(?Line2),COLOR(0FF0000H)
                       END
                       FOOTER,AT(1010,9302,5990,448)
                         STRING('Estimator 3.0 - (c) RDR Limited. 1995'),AT(1667,208,,),FONT('Arial',10,0FF0000H,FONT:bold+FONT:italic),USE(?String12)
                       END
                       FORM,AT(1000,1000,6000,9000)
                       END
                     END
ProgressWindow       WINDOW('Progress...'),AT(,,142,59),CENTER,TIMER(1),GRAY,DOUBLE
                       STRING(''),AT(0,3,141,10),USE(?Progress:UserString),CENTER
                       BOX,AT(15,15,111,12),COLOR(00H),FILL(0FFFFFFH)
                       BOX,AT(21,18,100,6),COLOR(00H),FILL(0C0C0C0H)
                       BOX,AT(21,18,100,6),USE(?Progress:Thermometer),FILL(0FFH)
                       STRING(''),AT(0,30,141,10),USE(?Progress:PctText),CENTER
                       BUTTON('Cancel'),AT(45,42,50,15),USE(?Progress:Cancel)
                     END
  CODE
  LocalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Product::Used = 0
    CheckOpen(Product,1)
  END
  Product::Used += 1
  RecordsToProcess = RECORDS(Product)
  RecordsPerCycle = 25
  RecordsProcessed = 0
  PercentProgress = 0
  OPEN(ProgressWindow)
  ?Progress:Thermometer{Prop:Width} = 0
  ?Progress:PctText{Prop:Text} = '0.0% Completed'
    ProgressWindow{Prop:Text} = 'Generating Report'
  ?Progress:UserString{Prop:Text}=''
  ACCEPT
    CASE EVENT()
    OF Event:OpenWindow
      SET(PRO:Key_Product)
      LOOP
        DO GetNextProduct
        DO ValidateRecord
        EXECUTE RecordStatus
          BEGIN
            LocalResponse = RequestCancelled
            BREAK
          END
          CYCLE
        END
        BREAK
      END
      IF LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
        CYCLE
      END
      OPEN(Report)
      Report{Prop:Preview} = PrintPreviewImage
    OF Event:Timer
      LOOP RecordsPerCycle TIMES
        PRINT(RPT:detail)
        LOOP
          DO GetNextRecord
          DO ValidateRecord
          EXECUTE RecordStatus
            BEGIN
              LocalResponse = RequestCancelled
              BREAK
            END
            CYCLE
          END
          BREAK
        END
        IF LocalResponse = RequestCancelled
          LocalResponse = RequestCompleted
          BREAK
        END
        LocalResponse = RequestCancelled
      END
      IF LocalResponse = RequestCompleted
        POST(Event:CloseWindow)
      END
    END
    CASE FIELD()
    OF ?Progress:Cancel
      CASE Event()
      OF Event:Accepted
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    END
  END
  IF LocalResponse = RequestCompleted
    ENDPAGE(Report)
    ReportPreview
    IF GlobalResponse = RequestCompleted
      Report{PROP:FlushPreview} = True
    END
  END
  CLOSE(Report)
  FREE(PrintPreviewQueue)
  DO ProcedureReturn
ProcedureReturn ROUTINE
  Product::Used -= 1
  IF Product::Used = 0 THEN CLOSE(Product).
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!-----------------------------------------------------------------------------
ValidateRecord       ROUTINE
  RecordStatus = Record:OutOfRange
  IF LocalResponse = RequestCancelled THEN EXIT.
  IF ERRORCODE() THEN EXIT.
  RecordStatus = Record:OK
  EXIT
GetNextProduct ROUTINE
  LocalResponse = RequestCancelled
  LOOP
    NEXT(Product)
    IF ERRORCODE() THEN EXIT.
    RecordsProcessed += 1
    RecordsThisCycle += 1
    IF PercentProgress < 100
      PercentProgress = (RecordsProcessed / RecordsToProcess)*100
      IF PercentProgress > 100
        PercentProgress = 100
      END
      ?Progress:Thermometer{Prop:Width} = ROUND(PercentProgress,0)
      ?Progress:PctText{Prop:Text} = FORMAT(PercentProgress,@N5.1) & '% Completed'
      DISPLAY()
    END
    BREAK
  END
  LocalResponse = RequestCompleted
  EXIT

GetNextRecord ROUTINE
  DO GetNextProduct
  IF LocalResponse = RequestCompleted THEN EXIT.
