                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Update_Estimate PROCEDURE

LocalRequest         LONG,AUTO
OriginalRequest      LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
WindowInitialized    LONG
ForceRefresh         LONG,AUTO
ActionMessage        CSTRING(40)
RecordChanged        BYTE,AUTO
RecordFiltered       LONG
SAV::MAS:Record      STRING(SIZE(MAS:Record))
Auto::Attempts       LONG,AUTO
Auto::SaveMAS:estimate_no LIKE(MAS:estimate_no)
Queue:Browse         QUEUE                        ! Browsing Queue
BRW4::det:Product      LIKE(det:Product)          ! Queue Display field
BRW4::det:quantity     LIKE(det:quantity)         ! Queue Display field
BRW4::det:cost         LIKE(det:cost)             ! Queue Display field
BRW4::det:total_cost   LIKE(det:total_cost)       ! Queue Display field
BRW4::det:sell         LIKE(det:sell)             ! Queue Display field
BRW4::det:total_sell   LIKE(det:total_sell)       ! Queue Display field
BRW4::det:profit       LIKE(det:profit)           ! Queue Display field
BRW4::det:note         LIKE(det:note)             ! Queue Display field
BRW4::det:estimate_no  LIKE(det:estimate_no)      ! Queue Display field
BRW4::Position         STRING(255)                ! Queue POSITION information
BRW4::Mark             BYTE                       ! Queue POSITION information
                     END                          ! END (Browsing Queue)
BRW4::RecordStatus   BYTE                         ! Flag for Range/Filter test
BRW4::InitializePage BYTE                         ! Flag for Range/Filter test
BRW4::ItemsToFill    LONG                         ! Controls records retrieved
BRW4::MaxItemsInList LONG                         ! Retrieved after window opened
BRW4::LocatedPosition STRING(255)                 ! POSITION of located record
BRW4::QueuePointer   LONG                         ! Queue position of located record
BRW4::NextChoice     LONG                         ! Queue position of located record
BRW4::MAS:Cost:Sum:Value REAL                     ! Queue position of scroll thumb
BRW4::MAS:Cost:Sum:Temp REAL                      ! Queue position of scroll thumb
BRW4::MAS:Sell:Sum:Value REAL                     ! Queue position of scroll thumb
BRW4::MAS:Sell:Sum:Temp REAL                      ! Queue position of scroll thumb
BRW4::MAS:Profit:Sum:Value REAL                   ! Queue position of scroll thumb
BRW4::MAS:Profit:Sum:Temp REAL                    ! Queue position of scroll thumb
BRW4::CurrentScroll  BYTE                         ! Queue position of scroll thumb
BRW4::CurrentScrollRecord LONG                    ! Queue position of scroll thumb
FormWindow           WINDOW('Update Estimate'),AT(5,2,306,172),STATUS,SYSTEM,GRAY,MAX,MDI,IMM
                       ENTRY(@s30),AT(42,4,125,12),FONT(,0,0800000H,FONT:bold),USE(MAS:customer)
                       ENTRY(@s30),AT(42,18,125,12),USE(MAS:address)
                       ENTRY(@s15),AT(42,32,62,12),USE(MAS:city)
                       ENTRY(@K#####-####K),AT(140,32,42,12),USE(MAS:zip)
                       LIST,AT(108,32,29,12),USE(MAS:state),VSCROLL,DROP(5),FROM('MD|DC|VA|NY|CA|FL|SC|NC|AT|TX')
                       ENTRY(@s20),AT(42,48,80,12),USE(MAS:contact)
                       ENTRY(@K(###) ###-####K),AT(42,62,,),USE(MAS:phone)
                       ENTRY(@s20),AT(42,76,,),USE(MAS:Project)
                       ENTRY(@D1),AT(204,4,,),USE(MAS:date_issued)
                       LIST,AT(204,18,92,12),USE(MAS:status),DROP(5),FROM('Open, Submitted|Open, Billed|Closed, Completed|Closed, Rejected')
                       BUTTON('OK'),AT(4,152,33,12),USE(?OK),DEFAULT
                       BUTTON('Cancel'),AT(40,152,33,12),USE(?Cancel)
                       BUTTON('&Worksheet'),AT(84,152,52,12),USE(?Button8)
                       BUTTON('&Proposal'),AT(140,152,46,12),USE(?Button7)
                       BUTTON('&Insert'),AT(192,152,33,12),USE(?Insert)
                       BUTTON('&Change'),AT(228,152,33,12),USE(?Change)
                       BUTTON('&Delete'),AT(264,152,33,12),USE(?Delete)
                       PROMPT('Status:'),AT(180,18,,),USE(?MAS:status:Prompt)
                       LIST,AT(4,94,293,54),MSG('Browsing Records'),USE(?List),IMM,HVSCROLL,FORMAT('60L~Product~@s15@20R~Qty~C@n5@40R~Cost~@n10.2@40R~Total Cost~@n10.2@40R~Sell~@n1' &|
         '0.2@40R~Total Sell~@n10.2@41R~Profit $~@n$-10.2@140L(5)~Notes~@s35@'),FROM(Queue:Browse)
                       PROMPT('&Customer:'),AT(5,4,35,10),USE(?MAS:customer:Prompt)
                       PROMPT('C&ontact:'),AT(12,48,28,10),USE(?MAS:contact:Prompt)
                       PROMPT('&Phone:'),AT(16,62,24,10),USE(?MAS:phone:Prompt)
                       PROMPT('Project:'),AT(14,76,,),USE(?MAS:Project:Prompt)
                       STRING('Date:'),AT(185,4,,),USE(?String1)
                       GROUP('Estimate Totals'),AT(160,50,136,39),USE(?Group1),BOXED
                         STRING('Sell $'),AT(216,61,,),USE(?String3)
                         STRING('Profit $'),AT(256,61,,),USE(?String4)
                         STRING('Cost $'),AT(176,61,,),USE(?String2)
                         ENTRY(@n10.2),AT(164,73,36,12),FONT(,0,0FFH,),USE(MAS:Cost),CENTER,READONLY
                         ENTRY(@n10.2),AT(204,73,36,12),FONT(,0,08000H,),USE(MAS:Sell),CENTER,READONLY
                         ENTRY(@N$-10.2),AT(244,73,48,12),FONT(,0,08000H,FONT:bold),USE(MAS:Profit),CENTER,READONLY
                       END
                     END
  CODE
  LocalRequest = GlobalRequest
  OriginalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  ForceRefresh = False
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Master::Used = 0
    CheckOpen(Master,1)
  END
  Master::Used += 1
  IF detail::Used = 0
    CheckOpen(detail,1)
  END
  detail::Used += 1
  SAV::MAS:Record = MAS:Record
  IF LocalRequest = InsertRecord
    DO PrimeFields
  END
    IF LocalRequest = DeleteRecord
      IF StandardWarning(Warn:StandardDelete) = Button:OK
        LOOP
          LocalResponse = RequestCancelled
          SETCURSOR(Cursor:Wait)
          IF RIDelete:Master()
            SETCURSOR()
            CASE StandardWarning(Warn:DeleteError)
            OF Button:Yes
              CYCLE
            OF Button:No OROF Button:Cancel
              BREAK
            END
          ELSE
            SETCURSOR()
            LocalResponse = RequestCompleted
          END
          BREAK
        END
      END
      DO ProcedureReturn
    END
  OPEN(FormWindow)
  WindowOpened=True
  CASE LocalRequest
  OF InsertRecord
    ActionMessage = 'Record will be Added'
  OF ChangeRecord
    ActionMessage = 'Record will be Changed'
  OF DeleteRecord
  END
  FormWindow{Prop:StatusText,1} = ActionMessage
  det:estimate_no = MAS:estimate_no
  ?List{Prop:Alrt,251} = MouseLeft2
  ?List{Prop:Alrt,255} = InsertKey
  ?List{Prop:Alrt,254} = DeleteKey
  ?List{Prop:Alrt,253} = CtrlEnter
  ACCEPT
    CASE EVENT()
    OF EVENT:CloseWindow
      IF LocalResponse <> RequestCompleted
        RecordChanged = False
        IF LocalRequest = InsertRecord OR LocalRequest = ChangeRecord
          IF SAV::MAS:Record <> MAS:Record
            RecordChanged = True
          END
        END
        IF RecordChanged
          CASE StandardWarning(Warn:ConfirmCancel)
          OF Button:Yes
            POST(Event:Accepted,?OK)
            CYCLE
          OF Button:No
          OF BUTTON:Cancel
            SELECT(?MAS:customer)
            CYCLE
          END
        END
        IF OriginalRequest = InsertRecord
          IF LocalResponse = RequestCancelled
            DELETE(Master)
          END
        END
      END
    OF EVENT:CloseDown
      IF LocalResponse <> RequestCompleted
        RecordChanged = False
        IF LocalRequest = InsertRecord OR LocalRequest = ChangeRecord
          IF SAV::MAS:Record <> MAS:Record
            RecordChanged = True
          END
        END
        IF RecordChanged
          CASE StandardWarning(Warn:ConfirmCancel)
          OF Button:Yes
            POST(Event:Accepted,?OK)
            CYCLE
          OF Button:No
          OF BUTTON:Cancel
            SELECT(?MAS:customer)
            CYCLE
          END
        END
        IF OriginalRequest = InsertRecord
          IF LocalResponse = RequestCancelled
            DELETE(Master)
          END
        END
      END
    OF EVENT:OpenWindow
      IF NOT WindowInitialized
        DO InitializeWindow
      END
      SELECT(?MAS:customer)
    OF EVENT:GainFocus
      WindowInitialized = True
      DO InitializeWindow
    ELSE
      IF EVENT() = Event:Completed
        CASE LocalRequest
        OF InsertRecord
          PUT(Master)
          CASE ERRORCODE()
          OF NoError
            LocalResponse = RequestCompleted
            POST(Event:CloseWindow)
          OF DupKeyErr
            IF DUPLICATE(MAS:Key_estimate_no)
              IF StandardWarning(Warn:DuplicateKey,'MAS:Key_estimate_no')
                SELECT(?MAS:customer)
                CYCLE
              END
            END
          ELSE
            IF StandardWarning(Warn:InsertError)
              SELECT(?MAS:customer)
              CYCLE
            END
          END
        OF ChangeRecord
          LOOP
            LocalResponse = RequestCancelled
            SETCURSOR(Cursor:Wait)
            IF RIUpdate:Master(SAV::MAS:Record)
              SETCURSOR()
              CASE StandardWarning(Warn:UpdateError)
              OF Button:Yes
                CYCLE
              OF Button:No
                POST(Event:CloseWindow)
                BREAK
              OF Button:Cancel
                SELECT(?MAS:customer)
                BREAK
              END
            ELSE
              SETCURSOR()
              LocalResponse = RequestCompleted
              POST(Event:CloseWindow)
            END
            BREAK
          END
        END
      END
    END
    CASE FIELD()
    OF ?OK
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF OriginalRequest = ChangeRecord OR OriginalRequest = InsertRecord
          SELECT()
        ELSE
          POST(EVENT:Completed)
        END
      END
    OF ?Cancel
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    OF ?Button8
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        Worksheet 
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Button7
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        Proposal 
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Insert
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW4::ButtonInsert
      END
    OF ?Change
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW4::ButtonChange
      END
    OF ?Delete
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW4::ButtonDelete
      END
    OF ?List
      CASE EVENT()
      OF EVENT:NewSelection
        DO BRW4::NewSelection
      OF EVENT:ScrollUp
        DO BRW4::ScrollUp
      OF EVENT:ScrollDown
        DO BRW4::ScrollDown
      OF EVENT:PageUp
        DO BRW4::PageUp
      OF EVENT:PageDown
        DO BRW4::PageDown
      OF EVENT:ScrollTop
        DO BRW4::ScrollTop
      OF EVENT:ScrollBottom
        DO BRW4::ScrollBottom
      OF EVENT:AlertKey
        DO BRW4::AlertKey
      OF EVENT:ScrollDrag
        IF ?List{Prop:VScrollPos} = 1
          POST(Event:ScrollTop,?List)
        ELSIF ?List{Prop:VScrollPos} = 100
          POST(Event:ScrollBottom,?List)
        ELSE
          CYCLE
        END
      END
    END
  END
  DO ProcedureReturn
!---------------------------------------------------------------------------
ProcedureReturn ROUTINE
  Master::Used -= 1
  IF Master::Used = 0 THEN CLOSE(Master).
  detail::Used -= 1
  IF detail::Used = 0 THEN CLOSE(detail).
  IF WindowOpened
    CLOSE(FormWindow)
  END
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!---------------------------------------------------------------------------
InitializeWindow ROUTINE
  DO BRW4::OpenWindow
  DO RefreshWindow
!---------------------------------------------------------------------------
RefreshWindow ROUTINE
  IF ForceRefresh
    GET(Queue:Browse,CHOICE(?List))
    REGET(det:Key_estimate_no,BRW4::Position)
  ELSE
    DO BRW4::FillBuffer
  END
  DO BRW4::ValidateRecord
  IF BRW4::RecordStatus <> Record:OK
    DO BRW4::InitializeBrowse
  ELSE
    IF ForceRefresh
      DO BRW4::LocateRecord
    ELSE
      DO BRW4::FillBuffer
    END
  END
  ?List{Prop:VScrollPos} = BRW4::CurrentScroll
  DISPLAY()
  ForceRefresh = False
!---------------------------------------------------------------------------
SyncWindow ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,CHOICE(?List))
    REGET(det:Key_estimate_no,BRW4::Position)
  END
!---------------------------------------------------------------------------
PrimeFields ROUTINE
  MAS:Record = SAV::MAS:Record
  MAS:date_issued = today()
  SAV::MAS:Record = MAS:Record
  Auto::Attempts = 0
  LOOP
    SET(MAS:Key_estimate_no)
    PREVIOUS(Master)
    IF ERRORCODE()
      Auto::SaveMAS:estimate_no = 1
    ELSE
      Auto::SaveMAS:estimate_no = MAS:estimate_no + 1
    END
    MAS:Record = SAV::MAS:Record
    MAS:estimate_no = Auto::SaveMAS:estimate_no
    SAV::MAS:Record = MAS:Record
    ADD(Master)
    IF ERRORCODE()
      Auto::Attempts += 1
      IF Auto::Attempts = 3
        IF StandardWarning(Warn:AutoIncError) = Button:Retry
          Auto::Attempts = 0
        ELSE
          LocalResponse = RequestCancelled
          POST(Event:CloseWindow)
          EXIT
        END
      END
      CYCLE
    END
    BREAK
  END
BRW4::OpenWindow ROUTINE
  IF LocalRequest = SelectRecord
    SET(det:Key_estimate_no,det:Key_estimate_no)
    DO BRW4::LocateRecord
  ELSE
    DO BRW4::InitializeBrowse
    SELECT(?List,1)
  END
  DO BRW4::FillBuffer
!----------------------------------------------------------------------
BRW4::InitializeBrowse ROUTINE
  SETCURSOR(Cursor:Wait)
  DO BRW4::ResetLow
  BRW4::MAS:Cost:Sum:Value = 0
  BRW4::MAS:Sell:Sum:Value = 0
  BRW4::MAS:Profit:Sum:Value = 0
  LOOP
    NEXT(detail)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BREAK
      CYCLE
    END
    DO BRW4::FillQueue
    BRW4::MAS:Cost:Sum:Value += det:total_cost
    BRW4::MAS:Sell:Sum:Value += det:total_sell
    BRW4::MAS:Profit:Sum:Value += det:profit
  END
  MAS:Cost = BRW4::MAS:Cost:Sum:Value
  MAS:Sell = BRW4::MAS:Sell:Sum:Value
  MAS:Profit = BRW4::MAS:Profit:Sum:Value
  SETCURSOR()
  BRW4::InitializePage = True
  DO BRW4::RefreshPage
  GET(Queue:Browse,1)
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::FillBuffer ROUTINE
  GET(Queue:Browse,CHOICE(?List))
  det:Product = BRW4::det:Product
  det:quantity = BRW4::det:quantity
  det:cost = BRW4::det:cost
  det:total_cost = BRW4::det:total_cost
  det:sell = BRW4::det:sell
  det:total_sell = BRW4::det:total_sell
  det:profit = BRW4::det:profit
  det:note = BRW4::det:note
  det:estimate_no = BRW4::det:estimate_no
!----------------------------------------------------------------------
BRW4::ResetLow ROUTINE
  det:estimate_no = MAS:estimate_no
  SET(det:Key_estimate_no,det:Key_estimate_no)
!----------------------------------------------------------------------
BRW4::ResetHigh ROUTINE
  det:estimate_no = MAS:estimate_no
  SET(det:Key_estimate_no,det:Key_estimate_no)
!----------------------------------------------------------------------
BRW4::ResetClear ROUTINE
  det:estimate_no = MAS:estimate_no
  SET(det:Key_estimate_no,det:Key_estimate_no)
!----------------------------------------------------------------------
BRW4::FillQueue ROUTINE
  BRW4::det:Product = det:Product
  BRW4::det:quantity = det:quantity
  BRW4::det:cost = det:cost
  BRW4::det:total_cost = det:total_cost
  BRW4::det:sell = det:sell
  BRW4::det:total_sell = det:total_sell
  BRW4::det:profit = det:profit
  BRW4::det:note = det:note
  BRW4::det:estimate_no = det:estimate_no
  BRW4::Position = POSITION(det:Key_estimate_no)
!----------------------------------------------------------------------
BRW4::NewSelection ROUTINE
  IF RECORDS(Queue:Browse)
    DO BRW4::FillBuffer
    DO RefreshWindow
  END
!----------------------------------------------------------------------
BRW4::ScrollUp ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)>1
      SELECT(?List, CHOICE(?List)-1)
    ELSE
      GET(Queue:Browse,1)                         ! Get the first queue item
      RESET(det:Key_estimate_no,BRW4::Position)   ! Reset for sequential processing
      PREVIOUS(detail)                            ! Retrieve record, reverse access
      BRW4::ItemsToFill = 1                       ! Load a single item
      DO BRW4::FillBackward                       ! Fill with previous read(s)
      IF BRW4::ItemsToFill                        ! If Load failed
        BRW4::CurrentScroll = 0                   ! Move Thumb to top
      ELSE
        BRW4::CurrentScroll = 50                  ! Move Thumb to center
      END
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ScrollDown ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)<RECORDS(Queue:Browse)
      SELECT(?List, CHOICE(?List)+1)
    ELSE
      GET(Queue:Browse,RECORDS(Queue:Browse))     ! Get the last queue item
      RESET(det:Key_estimate_no,BRW4::Position)   ! Reset for sequential processing
      NEXT(detail)                                ! Retrieve record, forward access
      BRW4::ItemsToFill = 1                       ! load a single item
      DO BRW4::FillForward                        ! Fill with next read(s)
      IF BRW4::ItemsToFill                        ! If Load failed
        BRW4::CurrentScroll = 100                 ! Move Thumb to top
      ELSE
        BRW4::CurrentScroll = 50                  ! Move Thumb to center
      END
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::PageUp ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,1)                           ! Get the first queue item
    RESET(det:Key_estimate_no,BRW4::Position)     ! Reset for sequential processing
    PREVIOUS(detail)                              ! Retrieve record, reverse access
    BRW4::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW4::FillBackward                         ! Fill with previous read(s)
    IF BRW4::ItemsToFill
      BRW4::NextChoice = CHOICE(?List)-BRW4::ItemsToFill
      IF BRW4::NextChoice < 1
        BRW4::NextChoice = 1
      END
      SELECT(?List, BRW4::NextChoice)
      BRW4::CurrentScroll = 0                     ! Move Thumb to top
    ELSE
      BRW4::CurrentScroll = 50                    ! Move Thumb to center
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::PageDown ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,RECORDS(Queue:Browse))       ! Get the last queue item
    RESET(det:Key_estimate_no,BRW4::Position)     ! Reset for sequential processing
    NEXT(detail)                                  ! Retrieve record, forward access
    BRW4::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW4::FillForward                          ! Fill with next read(s)
    IF BRW4::ItemsToFill
      BRW4::NextChoice = CHOICE(?List)+BRW4::ItemsToFill
      IF BRW4::NextChoice > RECORDS(Queue:Browse)
        BRW4::NextChoice = RECORDS(Queue:Browse)
      END
      SELECT(?List, BRW4::NextChoice)
      BRW4::CurrentScroll = 100                   ! Move Thumb to top
    ELSE
      BRW4::CurrentScroll = 50                    ! Move Thumb to center
    END
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ScrollTop ROUTINE
  IF RECORDS(Queue:Browse)
    BRW4::InitializePage = True
    DO BRW4::RefreshPage
    SELECT(?List,1)                               ! Select first list item
    BRW4::CurrentScroll = 0
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ScrollBottom ROUTINE
  IF RECORDS(Queue:Browse)
    SETCURSOR(Cursor:Wait)
    FREE(Queue:Browse)                            ! Free the browse queue
    DO BRW4::ResetHigh                            ! Reset for first page access
    BRW4::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW4::FillBackward                         ! Fill with previous read(s)
    SELECT(?List, RECORDS(Queue:Browse))          ! Select last list item
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      BRW4::CurrentScroll = 100
    ELSE
      BRW4::CurrentScroll = 0
    END
    SETCURSOR()
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::AlertKey ROUTINE
  IF RECORDS(Queue:Browse)
    CASE KEYCODE()                                ! What keycode was hit
    OF MouseLeft2
      POST(Event:Accepted,?Change)
      DO BRW4::FillBuffer
    OF InsertKey
      POST(Event:Accepted,?Insert)
    OF DeleteKey
      POST(Event:Accepted,?Delete)
    OF CtrlEnter
      POST(Event:Accepted,?Change)
    ELSE                                          ! ELSE (What keycode was hit)
      IF CHR(KEYCHAR())
        DO BRW4::ResetClear
        det:estimate_no = CHR(KEYCHAR())
        DO BRW4::LocateRecord                     ! Find the record
      END
    END                                           ! END (What keycode was hit)
  END
  DO BRW4::NewSelection
!----------------------------------------------------------------------
BRW4::ValidateRecord ROUTINE
  BRW4::RecordStatus = Record:OutOfRange
  IF det:estimate_no <> MAS:estimate_no THEN EXIT.
  BRW4::RecordStatus = Record:OK
  EXIT
!----------------------------------------------------------------------
BRW4::FillForward ROUTINE
  LOOP WHILE BRW4::ItemsToFill
    NEXT(detail)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BEGIN
        DO BRW4::ResetHigh                        ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,1)
      DELETE(Queue:Browse)
    END
    BRW4::ItemsToFill -= 1
    DO BRW4::FillQueue
    ADD(Queue:Browse)
  END
  EXIT
!----------------------------------------------------------------------
BRW4::FillBackward ROUTINE
  LOOP WHILE BRW4::ItemsToFill
    PREVIOUS(detail)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BEGIN
        DO BRW4::ResetLow                         ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,RECORDS(Queue:Browse))
      DELETE(Queue:Browse)
    END
    BRW4::ItemsToFill -= 1
    DO BRW4::FillQueue
    ADD(Queue:Browse,1)
  END
  EXIT
!----------------------------------------------------------------------
BRW4::LocateRecord ROUTINE
  SETCURSOR(Cursor:Wait)
  FREE(Queue:Browse)
  SET(det:Key_estimate_no,det:Key_estimate_no)
  BRW4::LocatedPosition = ''
  LOOP
    NEXT(detail)
    IF ERRORCODE() THEN BREAK.
    DO BRW4::ValidateRecord
    EXECUTE(BRW4::RecordStatus)
      BREAK
      CYCLE
    END
    BRW4::LocatedPosition = POSITION(det:Key_estimate_no)
    RESET(det:Key_estimate_no,BRW4::LocatedPosition)
    BREAK
  END
  BRW4::ItemsToFill = ?List{Prop:Items}
  BRW4::CurrentScroll = 50
  DO BRW4::FillForward
  IF BRW4::ItemsToFill
    BRW4::CurrentScroll = 100
    IF ~RECORDS(Queue:Browse)
      DO BRW4::ResetHigh                          ! Reset for first page access
    ELSE
      GET(Queue:Browse,1)
      RESET(det:Key_estimate_no,BRW4::Position)
      PREVIOUS(detail)
    END
    DO BRW4::FillBackward
    IF BRW4::ItemsToFill
      BRW4::CurrentScroll = 0
    END
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(det:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
    ?Delete{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    IF BRW4::LocatedPosition
      BRW4::QueuePointer = 1
      LOOP
        GET(Queue:Browse,BRW4::QueuePointer)
        IF ERRORCODE() THEN BREAK.
        IF BRW4::Position = BRW4::LocatedPosition THEN BREAK.
        BRW4::QueuePointer += 1
      END
    ELSE
      BRW4::QueuePointer = RECORDS(Queue:Browse)
    END
    SELECT(?List,BRW4::QueuePointer)
    DO BRW4::FillBuffer
    ?Change{Prop:Disable} = 0
    ?Delete{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------------
BRW4::RefreshPage ROUTINE
  SETCURSOR(Cursor:Wait)
  IF BRW4::InitializePage
    DO BRW4::ResetLow
  ELSE
    FREE(Queue:Browse)
    GET(Queue:Browse,1)
    RESET(det:Key_estimate_no,BRW4::Position)
  END
  FREE(Queue:Browse)
  BRW4::ItemsToFill = ?List{Prop:Items}
  BRW4::CurrentScroll = 50
  DO BRW4::FillForward
  IF NOT BRW4::InitializePage
    IF BRW4::ItemsToFill
      GET(Queue:Browse,1)
      RESET(det:Key_estimate_no,BRW4::Position)
      PREVIOUS(detail)
      BRW4::CurrentScroll = 100
      DO BRW4::FillBackward
    END
  END
  IF BRW4::ItemsToFill
    BRW4::CurrentScroll = 0
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(det:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
    ?Delete{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    DO BRW4::FillBuffer
    ?Change{Prop:Disable} = 0
    ?Delete{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------
BRW4::ButtonInsert ROUTINE
  GET(detail,0)
  CLEAR(det:Record,0)
  det:estimate_no = MAS:estimate_no
  SET(det:Key_estimate_no,det:Key_estimate_no)
  LocalRequest = InsertRecord
  DO BRW4::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW4::ValidateRecord
    IF BRW4::RecordStatus = Record:OK
    DO BRW4::FillQueue
      BRW4::MAS:Cost:Sum:Value += det:total_cost
      BRW4::MAS:Sell:Sum:Value += det:total_sell
      BRW4::MAS:Profit:Sum:Value += det:profit
      DO BRW4::LocateRecord
    END
  END
    MAS:Cost = BRW4::MAS:Cost:Sum:Value
    MAS:Sell = BRW4::MAS:Sell:Sum:Value
    MAS:Profit = BRW4::MAS:Profit:Sum:Value
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW4::ButtonChange ROUTINE
  LocalRequest = ChangeRecord
  BRW4::MAS:Cost:Sum:Temp = det:total_cost
  BRW4::MAS:Sell:Sum:Temp = det:total_sell
  BRW4::MAS:Profit:Sum:Temp = det:profit
  DO BRW4::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW4::FillQueue
    BRW4::MAS:Cost:Sum:Value -= BRW4::MAS:Cost:Sum:Temp
    BRW4::MAS:Sell:Sum:Value -= BRW4::MAS:Sell:Sum:Temp
    BRW4::MAS:Profit:Sum:Value -= BRW4::MAS:Profit:Sum:Temp
    DO BRW4::ValidateRecord
    IF BRW4::RecordStatus = Record:OK
      BRW4::MAS:Cost:Sum:Value += det:total_cost
      BRW4::MAS:Sell:Sum:Value += det:total_sell
      BRW4::MAS:Profit:Sum:Value += det:profit
      DO BRW4::LocateRecord
    ELSE
      SELECT(?List,CHOICE(?List))
    END
  END
    MAS:Cost = BRW4::MAS:Cost:Sum:Value
    MAS:Sell = BRW4::MAS:Sell:Sum:Value
    MAS:Profit = BRW4::MAS:Profit:Sum:Value
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW4::ButtonDelete ROUTINE
  LocalRequest = DeleteRecord
  BRW4::MAS:Cost:Sum:Temp = det:total_cost
  BRW4::MAS:Sell:Sum:Temp = det:total_sell
  BRW4::MAS:Profit:Sum:Temp = det:profit
  DO BRW4::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW4::FillQueue
    BRW4::MAS:Cost:Sum:Value -= BRW4::MAS:Cost:Sum:Temp
    BRW4::MAS:Sell:Sum:Value -= BRW4::MAS:Sell:Sum:Temp
    BRW4::MAS:Profit:Sum:Value -= BRW4::MAS:Profit:Sum:Temp
    MAS:Cost = BRW4::MAS:Cost:Sum:Value
    MAS:Sell = BRW4::MAS:Sell:Sum:Value
    MAS:Profit = BRW4::MAS:Profit:Sum:Value
    DELETE(Queue:Browse)
    DO BRW4::RefreshPage
  END
  SELECT(?List,CHOICE(?List))
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW4::CallUpdate ROUTINE
  GlobalRequest = LocalRequest
  Update_Detail
  LocalResponse = GlobalResponse
