                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Proposal PROCEDURE
RejectRecord         LONG,AUTO
LocalRequest         LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG,AUTO
RecordsToProcess     LONG,AUTO
RecordsProcessed     LONG,AUTO
RecordsPerCycle      LONG,AUTO
RecordsThisCycle     LONG,AUTO
PercentProgress      DECIMAL(4,1)
RecordStatus         BYTE,AUTO
SAV::det:estimate_no LIKE(det:estimate_no),AUTO   ! Save Range Limit Field
Report               REPORT,AT(1010,1010,5969,8490),PRE(RPT),THOUS
Estimate               BREAK(det:estimate_no)
                         HEADER,AT(,,,3958)
                           STRING(@s30),AT(2813,0,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(COM:Companyname),RIGHT
                           STRING(@s30),AT(2813,208,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(COM:Address1),RIGHT
                           STRING(@s30),AT(2813,417,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(COM:Address2),RIGHT
                           STRING(@n5),AT(3646,2396,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(MAS:estimate_no)
                           STRING(@s20),AT(3646,2188,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(MAS:Project)
                           STRING('We are quite pleased to offer for your review the following estimate.'),AT(104,3021,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String21)
                           STRING('Qty'),AT(104,3542,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String26)
                           STRING('Product / Service'),AT(521,3542,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String22)
                           STRING('Price Each'),AT(2188,3542,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String23)
                           STRING('Total'),AT(5104,3542,521,208),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String24)
                           LINE,AT(104,3854,5521,0),USE(?Line1),COLOR(0FF0000H)
                           STRING(@s20),AT(104,938,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(MAS:contact)
                           STRING('Phone -'),AT(3854,833,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String30)
                           STRING(@s15),AT(3125,625,,),FONT(,12,0FF0000H,FONT:bold+FONT:italic),USE(COM:City)
                           STRING(@K#####-####K),AT(4792,625,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(COM:Zip)
                           STRING('Estimate #: '),AT(2604,2396,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String20)
                           STRING(@s30),AT(104,1146,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(MAS:customer)
                           STRING(@s30),AT(104,1354,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(MAS:address)
                           STRING('Fax - '),AT(4063,1042,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String31)
                           STRING(@s2),AT(4479,625,,),FONT(,12,0FF0000H,FONT:bold+FONT:italic),USE(COM:State)
                           STRING('Project:'),AT(2917,2188,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String27)
                           STRING(@s15),AT(104,1563,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(MAS:city)
                           STRING(@s2),AT(1563,1563,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(MAS:state)
                           STRING(@K#####-####K),AT(1875,1563,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(MAS:zip)
                           STRING(@K(###) ###-####K),AT(4479,833,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(COM:Phone)
                           STRING(@K(###) ###-####K),AT(4479,1042,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(COM:Fax)
                         END
detail                   DETAIL,AT(,,,313),FONT('Arial',10,,)
                           STRING(@s20),AT(521,0,,),FONT('Arial',10,,FONT:bold),USE(det:Product)
                           STRING(@n5),AT(104,0,,),FONT('Arial',10,,FONT:bold),USE(det:quantity)
                           STRING(@n$10.2),AT(2188,0,,),FONT('Arial',10,,FONT:bold),USE(det:sell)
                           STRING(@n$10.2),AT(4896,0,,),FONT('Arial',10,,FONT:bold),USE(det:total_sell)
                           LINE,AT(3021,104,1771,0),USE(?Line2),COLOR(0FF0000H)
                         END
                         FOOTER,AT(,,,521)
                           STRING(@K(###) ###-####K),AT(4792,208,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(COM:Phone)
                           STRING('If there are any questions, please feel free to call our office:'),AT(104,208,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String28)
                         END
                       END
                       FOOTER,AT(1021,9573,5969,396)
                         STRING(@s20),AT(1250,104,,),FONT('Arial',10,0FF0000H,FONT:bold+FONT:italic),USE(COM:Contact)
                         STRING(@s20),AT(3021,104,,),FONT('Arial',10,0FF0000H,FONT:bold+FONT:italic),USE(COM:Title)
                         STRING('-'),AT(2813,104,,),FONT('Arial',0,,FONT:bold+FONT:italic),USE(?String34)
                       END
                       FORM,AT(1010,1000,5969,9000)
                       END
                     END
ProgressWindow       WINDOW('Progress...'),AT(,,142,59),CENTER,TIMER(1),GRAY,DOUBLE
                       STRING(''),AT(0,3,141,10),USE(?Progress:UserString),CENTER
                       BOX,AT(15,15,111,12),COLOR(00H),FILL(0FFFFFFH)
                       BOX,AT(21,18,100,6),COLOR(00H),FILL(0C0C0C0H)
                       BOX,AT(21,18,100,6),USE(?Progress:Thermometer),FILL(0FFH)
                       STRING(''),AT(0,30,141,10),USE(?Progress:PctText),CENTER
                       BUTTON('Cancel'),AT(45,42,50,15),USE(?Progress:Cancel)
                     END
  CODE
  LocalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
   OMIT('->')
  !----------------------------------------
  | CallProcedureAsLookup
  | Lookup Procedure    Browse_company
  | Before Lookup:      
  | After Complete:     
  | After Cancel:       
  !--------------------------------------->
  GlobalRequest = SelectRecord                      ! Set Action for Lookup
  Browse_company                                    ! Call the Lookup Procedure
  LocalResponse = GlobalResponse                    ! Save Action for evaluation
  GlobalResponse = RequestCancelled                 ! Clear Action
  IF Company::Used = 0
    CheckOpen(Company,1)
  END
  Company::Used += 1
  IF Master::Used = 0
    CheckOpen(Master,1)
  END
  Master::Used += 1
  IF detail::Used = 0
    CheckOpen(detail,1)
  END
  detail::Used += 1
  RecordsToProcess = 00050
  RecordsPerCycle = 25
  RecordsProcessed = 0
  PercentProgress = 0
  OPEN(ProgressWindow)
  ?Progress:Thermometer{Prop:Width} = 0
  ?Progress:PctText{Prop:Text} = '0.0% Completed'
    ProgressWindow{Prop:Text} = 'Generating Report'
  ?Progress:UserString{Prop:Text}=''
  ACCEPT
    CASE EVENT()
    OF Event:OpenWindow
      SAV::det:estimate_no = det:estimate_no
      det:estimate_no = SAV::det:estimate_no
      SET(det:Key_estimate_no,det:Key_estimate_no)
      LOOP
        DO GetNextdetail
        DO ValidateRecord
        EXECUTE RecordStatus
          BEGIN
            LocalResponse = RequestCancelled
            BREAK
          END
          CYCLE
        END
        BREAK
      END
      IF LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
        CYCLE
      END
      OPEN(Report)
      Report{Prop:Preview} = PrintPreviewImage
    OF Event:Timer
      LOOP RecordsPerCycle TIMES
        MAS:estimate_no = det:estimate_no                 ! Assign linking field value
        GET(Master,MAS:Key_estimate_no)                   ! Lookup record
        IF ERRORCODE()
          CLEAR(MAS:Record)                               ! Clear record if unsuccessful
        END
        PRINT(RPT:detail)
        LOOP
          DO GetNextRecord
          DO ValidateRecord
          EXECUTE RecordStatus
            BEGIN
              LocalResponse = RequestCancelled
              BREAK
            END
            CYCLE
          END
          BREAK
        END
        IF LocalResponse = RequestCancelled
          LocalResponse = RequestCompleted
          BREAK
        END
        LocalResponse = RequestCancelled
      END
      IF LocalResponse = RequestCompleted
        POST(Event:CloseWindow)
      END
    END
    CASE FIELD()
    OF ?Progress:Cancel
      CASE Event()
      OF Event:Accepted
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    END
  END
  IF LocalResponse = RequestCompleted
    ENDPAGE(Report)
    ReportPreview
    IF GlobalResponse = RequestCompleted
      Report{PROP:FlushPreview} = True
    END
  END
  CLOSE(Report)
  FREE(PrintPreviewQueue)
  DO ProcedureReturn
ProcedureReturn ROUTINE
  Company::Used -= 1
  IF Company::Used = 0 THEN CLOSE(Company).
  Master::Used -= 1
  IF Master::Used = 0 THEN CLOSE(Master).
  detail::Used -= 1
  IF detail::Used = 0 THEN CLOSE(detail).
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!-----------------------------------------------------------------------------
ValidateRecord       ROUTINE
  RecordStatus = Record:OutOfRange
  IF LocalResponse = RequestCancelled THEN EXIT.
  IF ERRORCODE() THEN EXIT.
  IF det:estimate_no <> SAV::det:estimate_no THEN EXIT.
  RecordStatus = Record:OK
  EXIT
GetNextdetail ROUTINE
  LocalResponse = RequestCancelled
  LOOP
    NEXT(detail)
    IF ERRORCODE() THEN EXIT.
    RecordsProcessed += 1
    RecordsThisCycle += 1
    IF PercentProgress < 100
      PercentProgress = (RecordsProcessed / RecordsToProcess)*100
      IF PercentProgress > 100
        PercentProgress = 100
      END
      ?Progress:Thermometer{Prop:Width} = ROUND(PercentProgress,0)
      ?Progress:PctText{Prop:Text} = FORMAT(PercentProgress,@N5.1) & '% Completed'
      DISPLAY()
    END
    BREAK
  END
  LocalResponse = RequestCompleted
  EXIT

GetNextRecord ROUTINE
  DO GetNextdetail
  IF LocalResponse = RequestCompleted THEN EXIT.
