                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Update_Product PROCEDURE

LocalRequest         LONG,AUTO
OriginalRequest      LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
WindowInitialized    LONG
ForceRefresh         LONG,AUTO
ActionMessage        CSTRING(40)
RecordChanged        BYTE,AUTO
SAV::PRO:Record      STRING(SIZE(PRO:Record))
FormWindow           WINDOW('Update Product'),AT(18,5,220,137),CENTER,SYSTEM,GRAY,MDI
                       PROMPT('&Product:'),AT(22,6,,),USE(?PRO:Product:Prompt)
                       ENTRY(@s15),AT(57,6,,),USE(PRO:Product)
                       PROMPT('&Cost:'),AT(32,21,,),USE(?PRO:Cost:Prompt)
                       ENTRY(@n10.2),AT(57,21,,),USE(PRO:Cost)
                       PROMPT('&Distributor:'),AT(12,36,,),USE(?PRO:Distributor:Prompt)
                       ENTRY(@s25),AT(57,36,,),USE(PRO:Distributor)
                       PROMPT('&Contact:'),AT(22,51,,),USE(?PRO:Contact:Prompt)
                       ENTRY(@s25),AT(57,51,,),USE(PRO:Contact)
                       PROMPT('&Phone:'),AT(26,66,,),USE(?PRO:Phone:Prompt)
                       ENTRY(@s15),AT(57,66,,),USE(PRO:Phone)
                       PROMPT('&Terms:'),AT(26,81,,),USE(?PRO:Terms:Prompt)
                       ENTRY(@s25),AT(57,81,,),USE(PRO:Terms)
                       PROMPT('&Notes:'),AT(27,96,,),USE(?PRO:Notes:Prompt)
                       ENTRY(@s40),AT(57,96,,),USE(PRO:Notes)
                       BUTTON('OK'),AT(8,119,40,12),USE(?OK),DEFAULT,REQ
                       BUTTON('Cancel'),AT(53,119,40,12),USE(?Cancel)
                     END
  CODE
  LocalRequest = GlobalRequest
  OriginalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  ForceRefresh = False
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Product::Used = 0
    CheckOpen(Product,1)
  END
  Product::Used += 1
  SAV::PRO:Record = PRO:Record
  IF LocalRequest = InsertRecord
    DO PrimeFields
  END
    IF LocalRequest = DeleteRecord
      IF StandardWarning(Warn:StandardDelete) = Button:OK
        LOOP
          LocalResponse = RequestCancelled
          SETCURSOR(Cursor:Wait)
          IF RIDelete:Product()
            SETCURSOR()
            CASE StandardWarning(Warn:DeleteError)
            OF Button:Yes
              CYCLE
            OF Button:No OROF Button:Cancel
              BREAK
            END
          ELSE
            SETCURSOR()
            LocalResponse = RequestCompleted
          END
          BREAK
        END
      END
      DO ProcedureReturn
    END
  OPEN(FormWindow)
  WindowOpened=True
  CASE LocalRequest
  OF InsertRecord
    ActionMessage = 'Record will be Added'
  OF ChangeRecord
    ActionMessage = 'Record will be Changed'
  OF DeleteRecord
  END
  FormWindow{Prop:StatusText,1} = ActionMessage
  ACCEPT
    CASE EVENT()
    OF EVENT:CloseWindow
      IF LocalResponse <> RequestCompleted
        RecordChanged = False
        IF LocalRequest = InsertRecord OR LocalRequest = ChangeRecord
          IF SAV::PRO:Record <> PRO:Record
            RecordChanged = True
          END
        END
        IF RecordChanged
          CASE StandardWarning(Warn:ConfirmCancel)
          OF Button:Yes
            POST(Event:Accepted,?OK)
            CYCLE
          OF Button:No
          OF BUTTON:Cancel
            SELECT(?PRO:Product:Prompt)
            CYCLE
          END
        END
      END
    OF EVENT:CloseDown
      IF LocalResponse <> RequestCompleted
        RecordChanged = False
        IF LocalRequest = InsertRecord OR LocalRequest = ChangeRecord
          IF SAV::PRO:Record <> PRO:Record
            RecordChanged = True
          END
        END
        IF RecordChanged
          CASE StandardWarning(Warn:ConfirmCancel)
          OF Button:Yes
            POST(Event:Accepted,?OK)
            CYCLE
          OF Button:No
          OF BUTTON:Cancel
            SELECT(?PRO:Product:Prompt)
            CYCLE
          END
        END
      END
    OF EVENT:OpenWindow
      IF NOT WindowInitialized
        DO InitializeWindow
      END
      SELECT(?PRO:Product:Prompt)
    OF EVENT:GainFocus
      WindowInitialized = True
      DO InitializeWindow
    ELSE
      IF EVENT() = Event:Completed
        CASE LocalRequest
        OF InsertRecord
          ADD(Product)
          CASE ERRORCODE()
          OF NoError
            LocalResponse = RequestCompleted
            POST(Event:CloseWindow)
          OF DupKeyErr
            IF DUPLICATE(PRO:Key_Product)
              IF StandardWarning(Warn:DuplicateKey,'PRO:Key_Product')
                SELECT(?PRO:Product:Prompt)
                CYCLE
              END
            END
          ELSE
            IF StandardWarning(Warn:InsertError)
              SELECT(?PRO:Product:Prompt)
              CYCLE
            END
          END
        OF ChangeRecord
          LOOP
            LocalResponse = RequestCancelled
            SETCURSOR(Cursor:Wait)
            IF RIUpdate:Product(SAV::PRO:Record)
              SETCURSOR()
              CASE StandardWarning(Warn:UpdateError)
              OF Button:Yes
                CYCLE
              OF Button:No
                POST(Event:CloseWindow)
                BREAK
              OF Button:Cancel
                SELECT(?PRO:Product:Prompt)
                BREAK
              END
            ELSE
              SETCURSOR()
              LocalResponse = RequestCompleted
              POST(Event:CloseWindow)
            END
            BREAK
          END
        END
      END
    END
    CASE FIELD()
    OF ?OK
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF OriginalRequest = ChangeRecord OR OriginalRequest = InsertRecord
          SELECT()
        ELSE
          POST(EVENT:Completed)
        END
      END
    OF ?Cancel
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    END
  END
  DO ProcedureReturn
!---------------------------------------------------------------------------
ProcedureReturn ROUTINE
  Product::Used -= 1
  IF Product::Used = 0 THEN CLOSE(Product).
  IF WindowOpened
    CLOSE(FormWindow)
  END
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!---------------------------------------------------------------------------
InitializeWindow ROUTINE
  DO RefreshWindow
!---------------------------------------------------------------------------
RefreshWindow ROUTINE
  DISPLAY()
  ForceRefresh = False
!---------------------------------------------------------------------------
SyncWindow ROUTINE
!---------------------------------------------------------------------------
PrimeFields ROUTINE
  PRO:Record = SAV::PRO:Record
  SAV::PRO:Record = PRO:Record
