                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Browse_Product PROCEDURE

LocalRequest         LONG,AUTO
OriginalRequest      LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
WindowInitialized    LONG
ForceRefresh         LONG,AUTO
RecordFiltered       LONG
Queue:Browse         QUEUE                        ! Browsing Queue
BRW1::PRO:Product      LIKE(PRO:Product)          ! Queue Display field
BRW1::PRO:Cost         LIKE(PRO:Cost)             ! Queue Display field
BRW1::PRO:Distributor  LIKE(PRO:Distributor)      ! Queue Display field
BRW1::PRO:Contact      LIKE(PRO:Contact)          ! Queue Display field
BRW1::PRO:Phone        LIKE(PRO:Phone)            ! Queue Display field
BRW1::PRO:Terms        LIKE(PRO:Terms)            ! Queue Display field
BRW1::PRO:Notes        LIKE(PRO:Notes)            ! Queue Display field
BRW1::Position         STRING(255)                ! Queue POSITION information
BRW1::Mark             BYTE                       ! Queue POSITION information
                     END                          ! END (Browsing Queue)
BRW1::RecordStatus   BYTE                         ! Flag for Range/Filter test
BRW1::InitializePage BYTE                         ! Flag for Range/Filter test
BRW1::ItemsToFill    LONG                         ! Controls records retrieved
BRW1::MaxItemsInList LONG                         ! Retrieved after window opened
BRW1::LocatedPosition STRING(255)                 ! POSITION of located record
BRW1::QueuePointer   LONG                         ! Queue position of located record
BRW1::NextChoice     LONG                         ! Queue position of located record
BRW1::CurrentScroll  BYTE                         ! Queue position of scroll thumb
BRW1::CurrentScrollRecord LONG                    ! Queue position of scroll thumb
BrowseWindow         WINDOW('Browse Products'),AT(0,0,276,136),SYSTEM,GRAY,MDI
                       LIST,AT(5,5,263,100),MSG('Browsing Records'),USE(?List),IMM,HVSCROLL,FORMAT('63L~Product~@s15@44L~Cost~@n10.2@105L~Distributor~@s25@107L~Contact~@s25@65L~Pho' &|
         'ne~@s15@105L~Terms~@s25@160L~Notes~@s40@'),FROM(Queue:Browse)
                       BUTTON('&Insert'),AT(5,110,40,12),KEY(InsertKey),USE(?Insert)
                       BUTTON('&Change'),AT(50,110,40,12),KEY(CtrlEnter),USE(?Change),DEFAULT
                       BUTTON('&Delete'),AT(95,110,40,12),KEY(DeleteKey),USE(?Delete)
                       BUTTON('&Select'),AT(145,110,40,12),KEY(EnterKey),USE(?Select)
                       BUTTON('Close'),AT(228,110,40,12),USE(?Close)
                     END
  CODE
  LocalRequest = GlobalRequest
  OriginalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  ForceRefresh = False
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Product::Used = 0
    CheckOpen(Product,1)
  END
  Product::Used += 1
  OPEN(BrowseWindow)
  WindowOpened=True
  SET(PRO:Key_Product)
  ?List{Prop:Alrt,251} = MouseLeft2
  IF LocalRequest = SelectRecord
    ?Select{Prop:Hide} = False
    ENABLE(?Select)
    ?Select{Prop:Default} = True
  ELSE
    ?Select{Prop:Hide} = True
    DISABLE(?Select)
  END
  ?List{Prop:Alrt,255} = InsertKey
  ?List{Prop:Alrt,254} = DeleteKey
  ?List{Prop:Alrt,253} = CtrlEnter
  ACCEPT
    CASE EVENT()
    OF EVENT:OpenWindow
      IF NOT WindowInitialized
        DO InitializeWindow
      END
      SELECT(?List)
    OF EVENT:GainFocus
      WindowInitialized = True
      DO InitializeWindow
    END
    CASE FIELD()
    OF ?List
      CASE EVENT()
      OF EVENT:NewSelection
        DO BRW1::NewSelection
      OF EVENT:ScrollUp
        DO BRW1::ScrollUp
      OF EVENT:ScrollDown
        DO BRW1::ScrollDown
      OF EVENT:PageUp
        DO BRW1::PageUp
      OF EVENT:PageDown
        DO BRW1::PageDown
      OF EVENT:ScrollTop
        DO BRW1::ScrollTop
      OF EVENT:ScrollBottom
        DO BRW1::ScrollBottom
      OF EVENT:AlertKey
        DO BRW1::AlertKey
      OF EVENT:ScrollDrag
        IF ?List{Prop:VScrollPos} = 1
          POST(Event:ScrollTop,?List)
        ELSIF ?List{Prop:VScrollPos} = 100
          POST(Event:ScrollBottom,?List)
        ELSE
          CYCLE
        END
      END
    OF ?Insert
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW1::ButtonInsert
      END
    OF ?Change
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW1::ButtonChange
      END
    OF ?Delete
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        DO BRW1::ButtonDelete
      END
    OF ?Select
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCompleted
        POST(Event:CloseWindow)
      END
    OF ?Close
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    END
  END
  DO ProcedureReturn
!---------------------------------------------------------------------------
ProcedureReturn ROUTINE
  Product::Used -= 1
  IF Product::Used = 0 THEN CLOSE(Product).
  IF WindowOpened
    CLOSE(BrowseWindow)
  END
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!---------------------------------------------------------------------------
InitializeWindow ROUTINE
  DO BRW1::OpenWindow
  DO RefreshWindow
!---------------------------------------------------------------------------
RefreshWindow ROUTINE
  IF ForceRefresh
    GET(Queue:Browse,CHOICE(?List))
    REGET(PRO:Key_Product,BRW1::Position)
  ELSE
    DO BRW1::FillBuffer
  END
  DO BRW1::ValidateRecord
  IF BRW1::RecordStatus <> Record:OK
    DO BRW1::InitializeBrowse
  ELSE
    IF ForceRefresh
      DO BRW1::LocateRecord
    ELSE
      DO BRW1::FillBuffer
    END
  END
  ?List{Prop:VScrollPos} = BRW1::CurrentScroll
  DISPLAY()
  ForceRefresh = False
!---------------------------------------------------------------------------
SyncWindow ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,CHOICE(?List))
    REGET(PRO:Key_Product,BRW1::Position)
  END
!---------------------------------------------------------------------------
BRW1::OpenWindow ROUTINE
  IF LocalRequest = SelectRecord
    SET(PRO:Key_Product,PRO:Key_Product)
    DO BRW1::LocateRecord
  ELSE
    DO BRW1::InitializeBrowse
    SELECT(?List,1)
  END
  DO BRW1::FillBuffer
!----------------------------------------------------------------------
BRW1::InitializeBrowse ROUTINE
  BRW1::InitializePage = True
  DO BRW1::RefreshPage
  GET(Queue:Browse,1)
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::FillBuffer ROUTINE
  GET(Queue:Browse,CHOICE(?List))
  PRO:Product = BRW1::PRO:Product
  PRO:Cost = BRW1::PRO:Cost
  PRO:Distributor = BRW1::PRO:Distributor
  PRO:Contact = BRW1::PRO:Contact
  PRO:Phone = BRW1::PRO:Phone
  PRO:Terms = BRW1::PRO:Terms
  PRO:Notes = BRW1::PRO:Notes
!----------------------------------------------------------------------
BRW1::ResetLow ROUTINE
  SET(PRO:Key_Product)
!----------------------------------------------------------------------
BRW1::ResetHigh ROUTINE
  SET(PRO:Key_Product)
!----------------------------------------------------------------------
BRW1::ResetClear ROUTINE
  SET(PRO:Key_Product)
!----------------------------------------------------------------------
BRW1::FillQueue ROUTINE
  BRW1::PRO:Product = PRO:Product
  BRW1::PRO:Cost = PRO:Cost
  BRW1::PRO:Distributor = PRO:Distributor
  BRW1::PRO:Contact = PRO:Contact
  BRW1::PRO:Phone = PRO:Phone
  BRW1::PRO:Terms = PRO:Terms
  BRW1::PRO:Notes = PRO:Notes
  BRW1::Position = POSITION(PRO:Key_Product)
!----------------------------------------------------------------------
BRW1::NewSelection ROUTINE
  IF RECORDS(Queue:Browse)
    DO BRW1::FillBuffer
    DO RefreshWindow
  END
!----------------------------------------------------------------------
BRW1::ScrollUp ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)>1
      SELECT(?List, CHOICE(?List)-1)
    ELSE
      GET(Queue:Browse,1)                         ! Get the first queue item
      RESET(PRO:Key_Product,BRW1::Position)       ! Reset for sequential processing
      PREVIOUS(Product)                           ! Retrieve record, reverse access
      BRW1::ItemsToFill = 1                       ! Load a single item
      DO BRW1::FillBackward                       ! Fill with previous read(s)
      IF BRW1::ItemsToFill                        ! If Load failed
        BRW1::CurrentScroll = 0                   ! Move Thumb to top
      ELSE
        BRW1::CurrentScroll = 50                  ! Move Thumb to center
      END
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ScrollDown ROUTINE
  IF RECORDS(Queue:Browse)
    IF CHOICE(?List)<RECORDS(Queue:Browse)
      SELECT(?List, CHOICE(?List)+1)
    ELSE
      GET(Queue:Browse,RECORDS(Queue:Browse))     ! Get the last queue item
      RESET(PRO:Key_Product,BRW1::Position)       ! Reset for sequential processing
      NEXT(Product)                               ! Retrieve record, forward access
      BRW1::ItemsToFill = 1                       ! load a single item
      DO BRW1::FillForward                        ! Fill with next read(s)
      IF BRW1::ItemsToFill                        ! If Load failed
        BRW1::CurrentScroll = 100                 ! Move Thumb to top
      ELSE
        BRW1::CurrentScroll = 50                  ! Move Thumb to center
      END
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::PageUp ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,1)                           ! Get the first queue item
    RESET(PRO:Key_Product,BRW1::Position)         ! Reset for sequential processing
    PREVIOUS(Product)                             ! Retrieve record, reverse access
    BRW1::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW1::FillBackward                         ! Fill with previous read(s)
    IF BRW1::ItemsToFill
      BRW1::NextChoice = CHOICE(?List)-BRW1::ItemsToFill
      IF BRW1::NextChoice < 1
        BRW1::NextChoice = 1
      END
      SELECT(?List, BRW1::NextChoice)
      BRW1::CurrentScroll = 0                     ! Move Thumb to top
    ELSE
      BRW1::CurrentScroll = 50                    ! Move Thumb to center
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::PageDown ROUTINE
  IF RECORDS(Queue:Browse)
    GET(Queue:Browse,RECORDS(Queue:Browse))       ! Get the last queue item
    RESET(PRO:Key_Product,BRW1::Position)         ! Reset for sequential processing
    NEXT(Product)                                 ! Retrieve record, forward access
    BRW1::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW1::FillForward                          ! Fill with next read(s)
    IF BRW1::ItemsToFill
      BRW1::NextChoice = CHOICE(?List)+BRW1::ItemsToFill
      IF BRW1::NextChoice > RECORDS(Queue:Browse)
        BRW1::NextChoice = RECORDS(Queue:Browse)
      END
      SELECT(?List, BRW1::NextChoice)
      BRW1::CurrentScroll = 100                   ! Move Thumb to top
    ELSE
      BRW1::CurrentScroll = 50                    ! Move Thumb to center
    END
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ScrollTop ROUTINE
  IF RECORDS(Queue:Browse)
    BRW1::InitializePage = True
    DO BRW1::RefreshPage
    SELECT(?List,1)                               ! Select first list item
    BRW1::CurrentScroll = 0
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ScrollBottom ROUTINE
  IF RECORDS(Queue:Browse)
    SETCURSOR(Cursor:Wait)
    FREE(Queue:Browse)                            ! Free the browse queue
    DO BRW1::ResetHigh                            ! Reset for first page access
    BRW1::ItemsToFill = ?List{Prop:Items}         ! Load a full page
    DO BRW1::FillBackward                         ! Fill with previous read(s)
    SELECT(?List, RECORDS(Queue:Browse))          ! Select last list item
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      BRW1::CurrentScroll = 100
    ELSE
      BRW1::CurrentScroll = 0
    END
    SETCURSOR()
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::AlertKey ROUTINE
  IF RECORDS(Queue:Browse)
    CASE KEYCODE()                                ! What keycode was hit
    OF MouseLeft2
      IF LocalRequest = SelectRecord
        POST(Event:Accepted,?Select)
        EXIT
      END
      POST(Event:Accepted,?Change)
      DO BRW1::FillBuffer
    OF InsertKey
      POST(Event:Accepted,?Insert)
    OF DeleteKey
      POST(Event:Accepted,?Delete)
    OF CtrlEnter
      POST(Event:Accepted,?Change)
    ELSE                                          ! ELSE (What keycode was hit)
      IF CHR(KEYCHAR())
        DO BRW1::ResetClear
        PRO:Product = CHR(KEYCHAR())
        DO BRW1::LocateRecord                     ! Find the record
      END
    END                                           ! END (What keycode was hit)
  END
  DO BRW1::NewSelection
!----------------------------------------------------------------------
BRW1::ValidateRecord ROUTINE
  BRW1::RecordStatus = Record:OutOfRange
  BRW1::RecordStatus = Record:OK
  EXIT
!----------------------------------------------------------------------
BRW1::FillForward ROUTINE
  LOOP WHILE BRW1::ItemsToFill
    NEXT(Product)
    IF ERRORCODE() THEN BREAK.
    DO BRW1::ValidateRecord
    EXECUTE(BRW1::RecordStatus)
      BEGIN
        DO BRW1::ResetHigh                        ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,1)
      DELETE(Queue:Browse)
    END
    BRW1::ItemsToFill -= 1
    DO BRW1::FillQueue
    ADD(Queue:Browse)
  END
  EXIT
!----------------------------------------------------------------------
BRW1::FillBackward ROUTINE
  LOOP WHILE BRW1::ItemsToFill
    PREVIOUS(Product)
    IF ERRORCODE() THEN BREAK.
    DO BRW1::ValidateRecord
    EXECUTE(BRW1::RecordStatus)
      BEGIN
        DO BRW1::ResetLow                         ! Reset for first page access
        BREAK
      END
      CYCLE
    END
    IF RECORDS(Queue:Browse) = ?List{Prop:Items}
      GET(Queue:Browse,RECORDS(Queue:Browse))
      DELETE(Queue:Browse)
    END
    BRW1::ItemsToFill -= 1
    DO BRW1::FillQueue
    ADD(Queue:Browse,1)
  END
  EXIT
!----------------------------------------------------------------------
BRW1::LocateRecord ROUTINE
  SETCURSOR(Cursor:Wait)
  FREE(Queue:Browse)
  SET(PRO:Key_Product,PRO:Key_Product)
  BRW1::LocatedPosition = ''
  LOOP
    NEXT(Product)
    IF ERRORCODE() THEN BREAK.
    DO BRW1::ValidateRecord
    EXECUTE(BRW1::RecordStatus)
      BREAK
      CYCLE
    END
    BRW1::LocatedPosition = POSITION(PRO:Key_Product)
    RESET(PRO:Key_Product,BRW1::LocatedPosition)
    BREAK
  END
  BRW1::ItemsToFill = ?List{Prop:Items}
  BRW1::CurrentScroll = 50
  DO BRW1::FillForward
  IF BRW1::ItemsToFill
    BRW1::CurrentScroll = 100
    IF ~RECORDS(Queue:Browse)
      DO BRW1::ResetHigh                          ! Reset for first page access
    ELSE
      GET(Queue:Browse,1)
      RESET(PRO:Key_Product,BRW1::Position)
      PREVIOUS(Product)
    END
    DO BRW1::FillBackward
    IF BRW1::ItemsToFill
      BRW1::CurrentScroll = 0
    END
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(PRO:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
    ?Delete{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    IF BRW1::LocatedPosition
      BRW1::QueuePointer = 1
      LOOP
        GET(Queue:Browse,BRW1::QueuePointer)
        IF ERRORCODE() THEN BREAK.
        IF BRW1::Position = BRW1::LocatedPosition THEN BREAK.
        BRW1::QueuePointer += 1
      END
    ELSE
      BRW1::QueuePointer = RECORDS(Queue:Browse)
    END
    SELECT(?List,BRW1::QueuePointer)
    DO BRW1::FillBuffer
    ?Change{Prop:Disable} = 0
    ?Delete{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------------
BRW1::RefreshPage ROUTINE
  SETCURSOR(Cursor:Wait)
  IF BRW1::InitializePage
    DO BRW1::ResetLow
  ELSE
    FREE(Queue:Browse)
    GET(Queue:Browse,1)
    RESET(PRO:Key_Product,BRW1::Position)
  END
  FREE(Queue:Browse)
  BRW1::ItemsToFill = ?List{Prop:Items}
  BRW1::CurrentScroll = 50
  DO BRW1::FillForward
  IF NOT BRW1::InitializePage
    IF BRW1::ItemsToFill
      GET(Queue:Browse,1)
      RESET(PRO:Key_Product,BRW1::Position)
      PREVIOUS(Product)
      BRW1::CurrentScroll = 100
      DO BRW1::FillBackward
    END
  END
  IF BRW1::ItemsToFill
    BRW1::CurrentScroll = 0
  END
  IF ~RECORDS(Queue:Browse)
    CLEAR(PRO:Record)
    ?List{Prop:Disable} = 1
    ?Change{Prop:Disable} = 1
    ?Delete{Prop:Disable} = 1
  ELSE
    ?List{Prop:Disable} = 0
    DO BRW1::FillBuffer
    ?Change{Prop:Disable} = 0
    ?Delete{Prop:Disable} = 0
  END
  SETCURSOR()
  EXIT
!----------------------------------------------------------------
BRW1::ButtonInsert ROUTINE
  GET(Product,0)
  CLEAR(PRO:Record,0)
  SET(PRO:Key_Product)
  LocalRequest = InsertRecord
  DO BRW1::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW1::ValidateRecord
    IF BRW1::RecordStatus = Record:OK
      DO BRW1::LocateRecord
    END
  END
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW1::ButtonChange ROUTINE
  LocalRequest = ChangeRecord
  DO BRW1::CallUpdate
  IF LocalResponse = RequestCompleted
    DO BRW1::ValidateRecord
    IF BRW1::RecordStatus = Record:OK
      DO BRW1::LocateRecord
    ELSE
      SELECT(?List,CHOICE(?List))
    END
  END
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW1::ButtonDelete ROUTINE
  LocalRequest = DeleteRecord
  DO BRW1::CallUpdate
  IF LocalResponse = RequestCompleted
    DELETE(Queue:Browse)
    DO BRW1::RefreshPage
  END
  SELECT(?List,CHOICE(?List))
  LocalRequest = OriginalRequest
  ForceRefresh = True
  DO RefreshWindow
!----------------------------------------------------------------
BRW1::CallUpdate ROUTINE
  GlobalRequest = LocalRequest
  Update_Product
  LocalResponse = GlobalResponse

