        MEMBER('cdiary')

! This is only one procedure out of many that creates a diary program.
! This procedure demonstrates the use of THREE different kinds of code in CW

!  1. A COMBO BOX that reads right out of a file - displays only 16 records
!     but the vscroll bar also works showing the appropriate location
!     in the file where you are reading. You can even use the mouse to move
!     the scroll bar and the program will read the appropriate place in the
!     file.
!     NOTE: This procedure actually has TWO combo boxes for two seperate
!     functions that work similarly. When curscr=1 the "Contents" combo is
!     displayed and functions. When curscr=4 the "Index" combo is used.

!  2. TABS. There are four tabs. I used PaintBrush to draw the four tab
!     Images - One with each tab as the uppermost. The appropriate PCX's
!     are included. You can use the screen formatter to view it. (I also
!     did a bunch of drawing and using yellow.pcx to clean the screen up.)

!  3. TIPS/BALLOONS - like exist in Word for Windows - A little balloon
!     shows up when the mouse cursor floats over a button on the tool bar.
!     TIMER is required to constantly monitor MOUSEX and MOUSEY. A small
!     gap is left below the tool buttons and the red line where the tips
!     appear. Otherwise other controls get in the way and the tips don't
!     look too nice. (There is only one button on the tool bar in this
!     procedure, but it works just fine for a whole slew of them!)

!     Ira J. Lund
!     Cumberland Family Software
!     385 Idaho Springs Road
!     Clarksville, TN 37043

! P.S. If you're interested in purchasing a final copy of Cumberland Diary
!      for windows when it is complete, let me know. $20 plus $4 shipping,
!      or $6 shipping outside North America.

tcontent   PROCEDURE
toc        string(20)
num        string(6)

tque       QUEUE,PRE(tq)
date       string(10)
time       string(7)
head       string(100)
lnum       string(6)
fill       string(1)
position   string(255)
           .
tque2       QUEUE,PRE(tq2)
head       string(100)
date       string(10)
time       string(7)
lnum       string(6)
fill       string(1)
nnum       string(6)
position   string(255)
           .
x          byte
mx  short
my  short
sentry1 string(40)
sentry2 string(40)
rec  ushort
count byte
locate byte
lv    short
scr  WINDOW('X'),AT(,,320,230),ICON('BOOK02.ICO'),STATUS(250,160),GRAY,MAX,MAXIMIZE,RESIZE,MDI,TIMER(1)
       MENUBAR
         MENU('&File')
           ITEM('&Close Diary'),USE(?CloseD),MSG('Close the open Diary')
           ITEM,SEPARATOR
           ITEM('Page Set&up...'),USE(?PSetup),MSG('Set printed page layout')
           ITEM('&Print...'),USE(?Print),MSG('Print the current Diary')
           ITEM,SEPARATOR
           ITEM('CDiary (DOS Ver) &Import...'),USE(?CDImport),MSG('Import a diary from an earlier version of Cumberland Diary')
         END
         MENU('&Edit')
           ITEM('&Author Information...'),USE(?AInfo),MSG('Edit the Diary Title and Author Information for the current diary')
           ITEM('&Password...'),USE(?Pass),MSG('Edit the password for the current diary')
         END
         MENU('&Options')
           ITEM('Auto Entry &Create'),USE(AutoE),CHECK,MSG('Automatically create a New Entry upon opening of this diary')
           ITEM('Auto Diary &Open'),USE(AutoD),CHECK,MSG('Automatically open this Diary upon program startup')
         END
       END
       REGION,AT(0,0,320,20),USE(?Region1)
       IMAGE('TAB1.BMP'),AT(5,0,310,19),USE(?Image1)
       IMAGE('TAB4.BMP'),AT(5,0,310,19),USE(?Image4)
       IMAGE('YELLOW1.BMP'),AT(0,0,5,220)    ! Along left side of diary
       IMAGE('YELLOW.BMP'),AT(315,0,10,220)  ! Along right side of diary
       BOX,AT(5,16,1,250),COLOR(0FFFFFFH),FILL(0FFFFFFH)
       LINE,AT(5,15,0,250),COLOR(00H)  
       BOX,AT(314,16,1,250),COLOR(0808080H),FILL(0808080H)
       LINE,AT(315,15,0,250),COLOR(00H)
       STRING('Con ents'),AT(39,5,,),FONT('FixedSys',0,,),TRN
       STRING('t'),AT(51,5,,),FONT('FixedSys',0,,FONT:underline),TRN
       STRING(' alendar'),AT(97,5,,),FONT('FixedSys',0,,),TRN
       STRING('C'),AT(97,5,,),FONT('FixedSys',0,,FONT:underline),TRN
       STRING(' iary'),AT(160,5,,),FONT('FixedSys',0,,),TRN
       STRING('D'),AT(160,5,,),FONT('FixedSys',0,,FONT:underline),TRN
       STRING(' ndex'),AT(219,5,,),FONT('FixedSys',0,,),TRN
       STRING('I'),AT(219,5,,),FONT('FixedSys',0,,FONT:underline),TRN
       BUTTON,AT(68,18,12,12),MSG('Print the current Diary'),USE(?PrintBut),ICON(ICON:Print)
         BOX,AT(74,31,20,8),USE(?Tip1),COLOR(00H),FILL(0FF80H),HIDE
         STRING('Print'),AT(78,31,,),FONT('Arial',8,,FONT:regular),USE(?tipw1),TRN,HIDE
       LINE,AT(6,40,308,0),COLOR(0FFH)
       COMBO(@s40),AT(18,44,290,144),MSG('Select Diary Entry to edit'),USE(sentry1),VSCROLL,FORMAT('35L35L160L30R2L'),IMM, |
           FROM(tque)
       COMBO(@s40),AT(18,44,290,144),MSG('Select Diary Entry to edit'),USE(sentry2),VSCROLL,FORMAT('160L35L35L30R2L'),IMM, |
           FROM(tque2)
       BUTTON('Edit Ent&ry'),AT(25,193,60,13),MSG('Select Diary Entry to edit'),USE(?Select),DEFAULT
       BUTTON('&Add Entry'),AT(90,193,60,13),MSG('Add a new diary entry and edit it'),USE(?Add)
       BUTTON('&Modify Heading'),AT(155,193,60,13),MSG('Edit an existing diary entry'),USE(?Modify)
       BUTTON('De&lete Entry'),AT(220,193,60,13),MSG('Delete an existing diary entry'),USE(?Delete)
     END

        CODE
        OPEN(scr)
        POST(EVENT:HideMenuItems,,1)
        scr{PROP:StatusText,2}=CLIP(txtfile)
        if curscr=1 then toc='TABLE OF CONTENTS';HIDE(?image4);UNHIDE(?image1)
                    else toc='INDEX'            ;HIDE(?image1);UNHIDE(?image4).
        do showtitle
        ALERT(EscKey) ! Don't allow ESC out of this window

        ! I want tabs that can be accessed by keyboard in addition to mouse
        ALERT(ALTC);ALERT(AltT);ALERT(AltI);ALERT(AltD)
        if AutoE=2 then AutoE=1;if AddEntry(0,TODAY()) then curscr=3;return..
        OPEN(diary)
        DISPLAY
        ACCEPT
!          message(event())   !just used for debugging
          mx=MOUSEX();my=MOUSEY()
          if my=>18 and my<=30 then  ! This drives the little TIPS/Balloon
            if mx=>68  and mx<= 80 then UNHIDE(?tip1);UNHIDE(?tipw1) else HIDE(?tip1);HIDE(?tipw1).
          else
            HIDE(?tip1);HIDE(?tipw1)
          .
          CASE KEYCODE()
            OF AltT;if curscr=4 then curscr=1;SETKEYCODE(0);break.
            OF AltC;curscr=2;SETKEYCODE(0);break
            OF AltD;curscr=3;SETKEYCODE(0);break
            OF AltI;if curscr=1 then curscr=4;SETKEYCODE(0);break.
          .
          CASE EVENT()
            OF EVENT:CloseDown   ;curscr=5;break
            OF EVENT:CloseWindow ;curscr=5;break
            OF EVENT:OpenWindow
              if curscr=1 then SET(txt:datekey);do loadtqr;PRESSKEY(CtrlPgDn);SELECT(?sentry1,1)
                          else SET(txt:namekey);do loadtq2;PRESSKEY(CtrlPgUp);SELECT(?sentry2,1).
            OF EVENT:Locate  ! this gets triggered whenever you type letters in combo
              if curscr=1 then
                UPDATE(?sentry1)
                txt:time=0
                m#=SUB(sentry1,4,2)
                d#=SUB(sentry1,7,2)
                y#=SUB(sentry1,1,2)+1900
                if m#=0 then m#=1.
                if d#=0 then d#=1.
                txt:date=DATE(m#,d#,y#)
                SET(txt:datekey,txt:datekey);do loadtq
                if RECORDS(tque)=0 then ! show last record
                  PREVIOUS(diary);do AddRec1;ADD(tque).
                do VSPos1
              else
                UPDATE(?sentry2)
                txt:heading=CLIP(sentry2)&CHR(0);txt:date=0;txt:time=0
                SET(txt:namekey,txt:namekey);do loadtq2
                if RECORDS(tque2)=0 then ! show last record
                  PREVIOUS(diary);do AddRec2;ADD(tque2).
                do VSPos2
              .
            OF Event:ScrollDrag  ! drag the vscroll around and this gets triggered
              if curscr=1 then
                Rec=INT(?sentry1{PROP:VScrollPos}/100*RECORDS(txt:datekey))
                GET(txt:datekey,Rec);tq:position=POSITION(txt:datekey)
                RESET(txt:datekey,tq:position);do loadtq;SELECT(?sentry1,1);do VSPos1
              else
                Rec=INT(?sentry2{PROP:VScrollPos}/100*RECORDS(txt:namekey))
                GET(txt:namekey,Rec);tq2:position=POSITION(txt:namekey)
                RESET(txt:namekey,tq2:position);do loadtq2;SELECT(?sentry2,1);do VSPos2
              .
            OF Event:ScrollDown ! down key or push the down arrow on scroll
              if curscr=1 then
                count=RECORDS(tque)
                locate=CHOICE(?sentry1)
                if locate<count then
                  locate+=1;SELECT(?sentry1,locate)
                elsif count=16 then
                 GET(tque,16)
                 if tq:lnum<RECORDS(txt:datekey) then
                  RESET(txt:datekey,tq:position)
                  NOMEMO(diary);NEXT(diary);NEXT(diary)
                  GET(tque,1);DELETE(tque);do AddRec1;ADD(tque)
                ..
                do VSPos1
              else
                count=RECORDS(tque2)
                locate=CHOICE(?sentry2)
                if locate<count then
                  locate+=1;SELECT(?sentry2,locate)
                elsif count=16 then
                 GET(tque2,16)
                 if tq2:nnum<RECORDS(txt:namekey) then
                  RESET(txt:namekey,tq2:position)
                  NOMEMO(diary);NEXT(diary);NEXT(diary)
                  GET(tque2,1);DELETE(tque2);do AddRec2;ADD(tque2)
                ..
                do VSPos2
              .
            OF Event:ScrollUp ! up key or push up arrow on scroll
              if curscr=1 then
                count=RECORDS(tque)
                locate=CHOICE(?sentry1)
                if locate>1 then
                  locate-=1;SELECT(?sentry1,locate)
                else
                  GET(tque,1)
                  if tq:lnum>1 then
                    RESET(txt:datekey,tq:position)
                    NOMEMO(diary);PREVIOUS(diary);PREVIOUS(diary)
                    GET(tque,16);DELETE(tque);do AddRec1;ADD(tque,1)
                . .
                do VSPos1
              else
                count=RECORDS(tque2)
                locate=CHOICE(?sentry2)
                if locate>1 then
                  locate-=1;SELECT(?sentry2,locate)
                else
                  GET(tque2,1)
                  if tq2:nnum>1 then
                    RESET(txt:namekey,tq2:position)
                    NOMEMO(diary);PREVIOUS(diary);PREVIOUS(diary)
                    GET(tque2,16);DELETE(tque2);do AddRec2;ADD(tque2,1)
                . .
                do VSPos2
              .
            OF Event:PageDown
              if curscr=1 then
                if RECORDS(tque)=16 then
                 GET(tque,16);RESET(txt:datekey,tq:position);NEXT(diary)
                 if tq:lnum<RECORDS(txt:datekey) then do loadtq.
                .
                do VSPos1
              else
                if RECORDS(tque2)=16 then
                 GET(tque2,16);RESET(txt:namekey,tq2:position);NEXT(diary)
                 if tq2:nnum<RECORDS(txt:namekey) then do loadtq2.
                .
                do VSPos2
              .
            OF Event:PageUp
              if curscr=1 then
                GET(tque,1)
                if tq:lnum>16 then
                 RESET(txt:datekey,tq:position);NEXT(diary);do loadtqr
                elsif tq:lnum>1 then
                 SET(txt:datekey);do loadtq
                .
                do VSPos1
              else
                GET(tque2,1)
                if tq2:nnum>16 then
                 RESET(txt:namekey,tq2:position);NEXT(diary);do loadtqr2
                elsif tq2:lnum>1 then
                 SET(txt:namekey);do loadtq2
                .
                do VSPos2
              .
            OF EVENT:ScrollTop ! Ctrl-PgUp to go to top of file
              if curscr=1 then
                 SET(txt:datekey);do loadtq 
                 SELECT(?sentry1,1);do VSPos1
              else
                 SET(txt:namekey);do loadtq2
                 SELECT(?sentry2,1);do VSPos2
              .
            OF EVENT:ScrollBottom ! Ctrl-PgDn to go to bottom of file
              if curscr=1 then
                 SET(txt:datekey);do loadtqr 
                 SELECT(?sentry1,1);do VSPos1
              else
                 SET(txt:namekey);do loadtqr2
                 SELECT(?sentry2,1);do VSPos2
              .
          .
          CASE ACCEPTED()
          OF ?Region1  ! This catches a mouse click on the TABS
            mx=MOUSEX();my=MOUSEY()
            CASE KEYCODE()
            OF MouseLeft
              if my=>2 and my<=15 then
                if mx=>26  and mx<=80  and  curscr=4 then curscr=1;SETKEYCODE(0);break.
                if mx=>86  and mx<=140 then curscr=2;SETKEYCODE(0);break.
                if mx=>146 and mx<=198 then curscr=3;SETKEYCODE(0);break.
                if mx=>204 and mx<=258 and  curscr=1 then curscr=4;SETKEYCODE(0);break.
            . .
          OF ?CloseD    ;curscr=5;break
          OF ?PSetup    ;PageSet;OPEN(diary)
          OF ?Print OROF ?PrintBut  ;PrintPro;OPEN(diary)
            if curscr=1 then SELECT(?sentry1) else SELECT(?sentry2).
          OF ?AInfo     ;AuthorInfo;do showtitle;OPEN(diary)
          OF ?Pass      ;PasswordP('Change Password');OPEN(diary)
          OF ?CDImport  ;DImport;OPEN(diary)
            if curscr=1 then SET(txt:datekey);do loadtq;PRESSKEY(CtrlPgDn);SELECT(?sentry1,1)
                        else SET(txt:namekey);do loadtq2;PRESSKEY(CtrlPgUp);SELECT(?sentry2,1).
          OF ?AutoE     ;AutoEntry(AutoE)
          OF ?AutoD     ;AutoDiary(AutoD)

          OF ?Select
            do getter
            centry=num;curscr=3;break
          OF ?Add   ;if AddEntry(0,TODAY()) then curscr=3;break.
            if curscr=1 then SELECT(?sentry1) else SELECT(?sentry2).
          OF ?Modify
            do getter
            x=AddEntry(num,0)
            if curscr=1 then SET(txt:datekey);do loadtq;SELECT(?sentry1,1)
                        else SET(txt:namekey);do loadtq2;SELECT(?sentry2,1).
          OF ?Delete
            do getter
            DelEntry(num)
            if curscr=1 then SET(txt:datekey);do loadtq;SELECT(?sentry1,1)
                        else SET(txt:namekey);do loadtq2;SELECT(?sentry2,1).
          OF ?sentry1;do VSPos1
          OF ?sentry2;do VSPos2
          .
        .
        CLOSE(diary)
        CLOSE(scr)
VSPos1  ROUTINE
        GET(tque,choice(?sentry1))
        ?sentry1{PROP:VScrollPos}=(tq:lnum-1)/(RECORDS(txt:datekey)-1)*100
VSPos2  ROUTINE
        GET(tque2,choice(?sentry2))
        ?sentry2{PROP:VScrollPos}=(tq2:nnum-1)/(RECORDS(txt:namekey)-1)*100
getter  ROUTINE
        if curscr=1 then
          GET(tque,choice(?sentry1));num=tq:lnum
        else
          GET(tque2,CHOICE(?sentry2));num=tq2:lnum
        .
showtitle ROUTINE
        OPEN(author);GET(author,1)
        scr{PROP:Text}=CLIP(ath:title)&' - '&ath:name
        CLOSE(author)
loadtq ROUTINE
       UNHIDE(?sentry1);HIDE(?sentry2)
       FREE(tque)
       LOOP r#=1 to 16
         if EOF(diary) then break.
         NOMEMO(diary);NEXT(diary)
         do AddRec1;ADD(tque)
       .
loadtqr ROUTINE
       FREE(tque)
       LOOP r#=1 to 16
         IF BOF(diary) then break.
         NOMEMO(diary)
         PREVIOUS(diary);do AddRec1;ADD(tque,1)
       .
       DISPLAY
AddRec1 ROUTINE
         tq:date=FORMAT(txt:date,@d9);tq:time=FORMAT(txt:time,@t3);tq:head=CLIP(txt:heading)&ALL('.')
         tq:position=POSITION(txt:datekey)
         tq:lnum=FORMAT(POINTER(txt:datekey),@n_6)
loadtq2 ROUTINE
       UNHIDE(?sentry2);HIDE(?sentry1)
       FREE(tque2)
       LOOP r#=1 to 16
         if EOF(diary) then break.
         NOMEMO(diary);NEXT(diary)
         do AddRec2;ADD(tque2)
       .
loadtqr2 ROUTINE
       FREE(tque2)
       LOOP r#=1 to 16
         IF BOF(diary) then break.
         NOMEMO(diary)
         PREVIOUS(diary);do AddRec2;ADD(tque2,1)
       .
AddRec2 ROUTINE
         tq2:date=FORMAT(txt:date,@d9);tq2:time=FORMAT(txt:time,@t3);tq2:head=CLIP(txt:heading)&ALL('.')
         tq2:position=POSITION(txt:namekey)
         tq2:lnum=FORMAT(POINTER(txt:datekey),@n_6)
         tq2:nnum=FORMAT(POINTER(txt:namekey),@n_6)

AddEntry FUNCTION(fromm,usedate)
flag     byte
scr    WINDOW('Entry'),AT(70,70,226,70),FONT('',10,0,FONT:bold),double,gray
         STRING('Date:'),AT(5,7,38,10),RIGHT
         ENTRY(@d2),AT(45,6,,10),USE(txt:date)
         STRING('Time:'),AT(5,19,38,10),RIGHT
         ENTRY(@t3),AT(45,18,,10),USE(txt:time)
         STRING('Heading:'),AT(5,31,38,10),RIGHT
         ENTRY(@s40),AT(45,30,140,10),USE(txt:heading)
         BUTTON('&OK'),AT(58,46,50,14),USE(?ok),default
         BUTTON('&Cancel'),AT(118,46,50,14),USE(?Cancel)
       END

     CODE
     OPEN(scr)
     OPEN(diary)
     txt:date=usedate;txt:time=CLOCK();txt:heading='';txt:dtext=''
     txt:heading=''
     if fromm>0 then GET(txt:datekey,fromm)  ! Edit this record
        scr{PROP:text}='Edit Entry'
     else
        scr{PROP:text}='Add a New Entry'
     .
     DISPLAY
     ACCEPT
       CASE ACCEPTED()
       OF ?Cancel; flag=0;break
       OF ?OK
         if fromm=0 then ADD(diary);centry=POINTER(txt:datekey) else PUT(diary).
         flag=1
         break
     . .
     CLOSE(diary)
     CLOSE(scr)
     SETKEYCODE(0)
     RETURN(flag)

DelEntry PROCEDURE(fromm)
scr    WINDOW('Delete this Entry?'),AT(70,70,226,70),double,gray
         STRING('Date:'),AT(5,7,38,10)
         STRING(@d2),AT(45,6,40,10),USE(txt:date)
         STRING('Time:'),AT(5,19,38,10)
         STRING(@t3),AT(45,18,40,10),USE(txt:time)
         STRING('Heading:'),AT(5,31,38,10)
         STRING(@s40),AT(45,30,140,10),USE(txt:heading)
         BUTTON('&OK'),AT(58,46,50,14),USE(?ok)
         BUTTON('&Cancel'),AT(118,46,50,14),USE(?Cancel),default
       END

     CODE
     OPEN(scr)
     OPEN(diary)
     GET(txt:datekey,fromm)  ! Show this record
     DISPLAY
     SELECT(?Ok)
     ACCEPT
       CASE ACCEPTED()
       OF ?Cancel; break
       OF ?OK
         DELETE(diary)
         break
     . .
     SETKEYCODE(0)
     CLOSE(diary)
     CLOSE(scr)
