!
! ACCOUNTS RECEIVABLE SYSTEM FILES
!
ARS	     FILE,PRE(ARS),NAME('ARS.DAT'),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
DRECORD	       RECORD
FILE1		 STRING(50)			 !FILE SPEC GL FILE
FILE2		 STRING(50)			 !FILE SPEC TERMS OF PAYMENT FILE
FILE3		 STRING(50)			 !FILE SPEC SHIP VIA FILE
FILE4		 STRING(50)			 !FILE SPEC HISTORY FILE
FILE5		 STRING(50)			 !FILE SPEC P/L TRANSFER FILE
FILE6		 STRING(50)			 !FILE SPEC CONTROL FILE
FILE7		 STRING(50)			 !FILE SPEC CUSTOMER FILE
FILE8		 STRING(50)			 !FILE SPEC TRANSACTION FILE
FILE9		 STRING(50)			 !FILE SPEC ARCHIVE FILE
FILE10		 STRING(50)			 !FILE SPEC DAILY PAYMENTS FILE
FILE11		 STRING(50)			 !FILE SPEC JOURNAL ENTRY FILE
FILE12		 STRING(50)			 !FILE SPEC INVOICE FILE
DEAD_DATE	 LONG				 !DEMONSTRATION DEATH DATE
NAME		 STRING(30)			 !SYSTEM LICENSED TO . . .
	     . .

ARSGLCTL     FILE,NAME(GLNAME),PRE(GL),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(GL:GL_CODE),NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Account Number
GL_NAME		 STRING(30)			 !General Ledger Account Name
DB_TODAY	 DECIMAL(11,2)			 !Debits Today
CR_TODAY	 DECIMAL(11,2)			 !Credits Today
DB_MONTH	 DECIMAL(11,2)			 !Debits Month
CR_MONTH	 DECIMAL(11,2)			 !Credits Month
	     . .

ARSTPCTL     FILE,NAME(TPNAME),PRE(TP),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(TP:TP_CODE),NOCASE
NAME_KEY       KEY(TP:TP_CODE,TP:TP_NAME),NOCASE
RECORD	       RECORD
TP_CODE		 BYTE				 !Terms of Payment Code
TP_NAME		 STRING(15)			 !Terms of Payment Description
DUE_DAYS	 SHORT				 !Due Days of Payment
DISC_DAYS	 SHORT				 !Number of Discount Days
DISC_PCT	 DECIMAL(5,2)			 !Discount Percentage
	     . .

ARSSVCTL     FILE,NAME(SVNAME),PRE(SV),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(SV:SV_CODE),NOCASE
NAME_KEY       KEY(SV:SV_CODE,SV:SV_NAME),NOCASE
RECORD	       RECORD
SV_CODE		 BYTE				 !Ship Via Code
SV_NAME		 STRING(15)			 !Ship Via Description
	     . .

ARSCTL	     FILE,NAME(CTLNAME),PRE(CTL),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
FIN_CHARGE	 DECIMAL(5,2)			 !Finance Charge Percentage
NBR_PASTDUE	 BYTE				 !Number of Days Past Due for FC
MIN_FC		 DECIMAL(4,2)			 !Minimum Finance Charge
DEFAULT_FC	 STRING(12)			 !Default GL Account for FC
ARS_GL		 STRING(12)			 !Accounts Receivable GL Account
DEFAULT_SALE	 STRING(12)			 !Default Sales GL Account
DEFAULT_MSC	 STRING(12)			 !Default Misc Sales GL Account
DEFAULT_FRT	 STRING(12)			 !Default Freight GL Account
CASH_ACT	 STRING(12)			 !Cash GL Account
CASH_DISC	 STRING(12)			 !Cash Discount GL Account
DEFAULT_ALLW	 STRING(12)			 !Default Sales Allow. GL Acct
BAD_DEBT	 STRING(12)			 !BAD DEBT EXPENSE ACCOUNT
NEXT_INV	 LONG				 !NEXT INVOICE NUMBER
PRINT_NAME	 STRING(1)			 !PRINT NAME ON STMT?
USING_GL	 STRING(1)			 !POST TO G/L?
	     . .

ARSCUST	     FILE,NAME(CUSNAME),PRE(CUS),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(CUS:CODE),NOCASE
ID_KEY	       KEY(CUS:ID,CUS:CO_NAME) DUP,OPT
NAME_KEY       KEY(CUS:BILL_NAME,CUS:BILL_CITY) DUP
SNAME_KEY      KEY(CUS:CO_NAME,CUS:CITY) DUP
ZIP_KEY	       KEY(CUS:ZIP_CODE) DUP
AMT_KEY	       KEY(CUS:BAL_DUE) DUP,OPT
CH_KEY	       KEY(CUS:TY_CHGS),DUP,OPT
TYPE_KEY       KEY(CUS:ACCT_TYPE,CUS:CODE),DUP,NOCASE
RECORD	       RECORD
CODE		LONG				 !CUSTOMER CODE
ID		STRING(5)			 !OPTIONAL ACCESS KEY
CO_NAME		STRING(30)			 !COMPANY NAME - SHIP TO
ADDRESS_1	STRING(25)			 !TWO ADDRESS LINES
ADDRESS_2	STRING(25)
CITY		STRING(15)			 !CITY
STATE		STRING(2)			 !STATE
ZIP_CODE	LONG				 !ZIP CODE
BILL_NAME	STRING(30)			 !BILL-TO NAME AND ADDRESS
BILL_ADDR1	STRING(25)			 !
BILL_ADDR2	STRING(25)			 !
BILL_CITY	STRING(15)			 !
BILL_STATE	STRING(2)			 !
BILL_ZIP	LONG				 !
PHONE		STRING(12)			 !TELEPHONE NUMBER
CONTACT_NAME	STRING(25)
CREDIT_LIMIT	STRING(20)
FINANCE_CHG	STRING(1)			 !FC - YES OR NO (Y,N)
MAIN_SUB	STRING(1)			 !MAIN OR SUBSIDIARY ACCOUNT
MAIN_ACT	SHORT				 !IF SUB - MAIN ACCOUNT CODE
ACCT_STATUS	STRING(1)			 !ACCOUNT STATUS ACTIVE,INACTIVE,PROSPECT
ACCT_TYPE	STRING(1)			 !ACCOUNT TYPE - REGULAR,LAB,GOVERMENT,MILITARY,ETC
SHIP_METHOD	BYTE				 !UPS SHIPPING ZONE
PRICE_COL	STRING(1)			 !PRICE COL 1-6
USUAL_TERMS	BYTE				 !PERCENTAGE PAYMENT DISCOUNT ALLOWED
ADD_DATE	LONG				 !DATE ADDED TO SYSTEM
SALE_DATE	LONG				 !DATE OF LAST SALE
PAY_DATE	LONG				 !DATE OF LAST PAYMENT
BAL_DUE		DECIMAL(11,2)			 !ACCOUNT BALANCE DUE
TY_CHGS		DECIMAL(11,2)
TY_PMTS		DECIMAL(11,2)
TY_FC		DECIMAL(11,2)
LY_CHGS		DECIMAL(11,2)
LY_PMTS		DECIMAL(11,2)
LY_FC		DECIMAL(11,2)
	     . .

ARSCUSHST    FILE,PRE(HST),NAME(HSTNAME),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(HST:CODE)
RECORD	       RECORD
CODE		LONG
TY_CHGS		DECIMAL(11,2),DIM(12)
TY_PMTS		DECIMAL(11,2),DIM(12)
TY_FC		DECIMAL(11,2),DIM(12)
LY_CHGS		DECIMAL(11,2),DIM(12)
LY_PMTS		DECIMAL(11,2),DIM(12)
LY_FC		DECIMAL(11,2),DIM(12)
	     . .

ARSPCKDET    FILE,PRE(PDT),NAME(PACKNAME),RECLAIM,PROTECT,CREATE
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(PDT:CODE,PDT:PL_NBR) DUP
RECORD	       RECORD
CODE		 LONG				 !BILL TO CUST. CODE
SHIP_CODE	 LONG				 !SHIP TO CUST. CODE
DATE		 LONG				 !DATE OF ORDER
PO_NBR		 STRING(10)			 !CUSTOMER PO NBR
SHIP_VIA	 BYTE				 !HOW SHIPPED
PL_NBR		 LONG				 !PACKING LIST NBR
INV_NBR		 STRING(10)			 !INVENTORY CODE NUMBER
DESC		 STRING(60)			 !ITEM DESCRIPTION
QUANTITY	 DECIMAL(10,1)			 !QUANTITY SHIPPED
SELL_PRICE	 DECIMAL(11,2)			 !ITEM SELLING PRICE
	     . .

ARSTRN	    FILE,PRE(TRN),NAME(TRNNAME),RECLAIM,PROTECT,CREATE
	    OWNER('MjamesA'),ENCRYPT
TRAN_KEY      KEY(TRN:TRAN_CODE,TRN:TRAN_DATE,TRN:TRAN_NBR) DUP
SHIP_KEY      KEY(TRN:TRAN_SHIP,TRN:TRAN_DATE,TRN:TRAN_NBR) DUP
RECORD	      RECORD
TRAN_CODE	LONG				 !CUSTOMER NUMBER
TRAN_SHIP	LONG
TRAN_DATE	LONG				 !INVOICE DATE
TRAN_NBR	LONG				 !INVOICE NUMBER
TRAN_DETAIL	STRING(15)			 !ADDITIONAL DETAIL (USER DEF.)
TRAN_AMT	DECIMAL(11,2)			 !INVOICE AMOUNT
TRAN_TOTAL	DECIMAL(11,2)			 !ORIGINAL AMOUNT OF INVOICE
TRAN_MARK	BYTE
TRAN_FLAG	STRING(4)			 !FLAG - 'PAID' 'OPEN' 'PAST'
INV_TERMS	BYTE
	    . .					 !  ETC. (INTERNAL USAGE ONLY)

ARSTRNARC   FILE,PRE(ARC),NAME(ARCNAME),RECLAIM,PROTECT,CREATE
	    OWNER('MjamesA'),ENCRYPT
TRAN_KEY      KEY(ARC:TRAN_CODE,ARC:TRAN_DATE,ARC:TRAN_NBR) DUP
SHIP_KEY      KEY(ARC:TRAN_SHIP,ARC:TRAN_DATE,ARC:TRAN_NBR) DUP
RECORD	      RECORD
TRAN_CODE	LONG				 !CUSTOMER NUMBER
TRAN_SHIP	LONG				 !CUSTOMER NUMBER
TRAN_DATE	LONG				 !INVOICE DATE
TRAN_NBR	LONG				 !INVOICE NUMBER
TRAN_DETAIL	STRING(15)			 !ADDITIONAL DETAIL (USER DEF.)
TRAN_AMT	DECIMAL(11,2)			 !INVOICE AMOUNT
DATE_PAID	LONG
	    . .

ARSDEPST    FILE,PRE(DEP),NAME(DEPNAME),RECLAIM,PROTECT,CREATE
	    OWNER('MjamesA'),ENCRYPT
TRAN_KEY      KEY(DEP:TRAN_CODE,DEP:TRAN_DATE) DUP
RECORD	      RECORD
TRAN_CODE	LONG				 !CUSTOMER NUMBER
TRAN_DATE	LONG				 !PAYMENT DATE
TRAN_DETAIL	STRING(15)			 !CHECK NUMBER
TRAN_AMT	DECIMAL(11,2)			 !CHECK AMOUNT
	    . .

ARSJE	    FILE,PRE(JER),NAME(JENAME),RECLAIM,PROTECT,CREATE
	    OWNER('MjamesA'),ENCRYPT
TRAN_KEY      KEY(JER:TRAN_CODE,JER:TRAN_DATE) DUP
RECORD	      RECORD
TRAN_CODE	LONG				 !CUSTOMER NUMBER
TRAN_DATE	LONG				 !JE DATE
TRAN_DETAIL	STRING(15)			 !JE DESCRIPTION
TRAN_AMT	DECIMAL(11,2)			 !JE AMOUNT
	    . .

ARSINV	    FILE,PRE(INV),NAME(INVNAME),RECLAIM,PROTECT,CREATE
	    OWNER('MjamesA'),ENCRYPT
TRAN_KEY      KEY(INV:TRAN_CODE,INV:TRAN_DATE) DUP
RECORD	      RECORD
TRAN_CODE	LONG				 !CUSTOMER NUMBER
TRAN_NBR	LONG				 !INVOICE NUMBER
TRAN_DATE	LONG				 !INVOICE DATE
TRAN_DETAIL	STRING(15)			 !INVOICE DETAIL
TRAN_AMT	DECIMAL(11,2)			 !INVOICE AMOUNT
	    . .

CONFIG	     FILE,NAME('CONFIG.DAT'),PRE(CFG),PROTECT
	     OWNER('MjamesA'),ENCRYPT
RECORD	     RECORD
TYPE	       BYTE
	     . .

GLNAME	     STRING(50)
TPNAME	     STRING(50)
SVNAME	     STRING(50)
HSTNAME	     STRING(50)
PACKNAME     STRING(50)
CTLNAME	     STRING(50)
CUSNAME	     STRING(50)
TRNNAME	     STRING(50)
ARCNAME	     STRING(50)
DEPNAME	     STRING(50)
JENAME	     STRING(50)
INVNAME	     STRING(50)

!
! GENERAL LEDGER SYSTEM FILES
!
GLSPERIOD    FILE,PRE(PER),NAME(GLSPERIODS),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
START		 LONG,DIM(13)			 !Period X Start
STOP		 LONG,DIM(13)			 !Period X Stop
CURRENT		 BYTE				 !Current Period
	     . .

GLSACCTS     FILE,PRE(ACC),NAME(GLSACCOUNTS),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(ACC:GL_CODE),NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !Account Code
DESCRIPTION	 STRING(30)			 !Account Description
TB_SUBTOTAL	 BYTE				 !Trial Balance Subtotal Level
FIN_STMT	 STRING(1)			 !Financial Statement Type
SAF_TYPE	 STRING(1)			 !Source/Application of Funds
NORMAL_BAL	 STRING(1)			 !NORMAL BALANCE - DEBIT OR CREDIT
COMPRESS	 STRING(1)			 !Compression Code
	     . .

GLSGENTRN    FILE,PRE(GEN),NAME(GLSGENTRAN),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
DOC_KEY	       KEY(GEN:DOCUMENT)
RECORD	       RECORD
DOCUMENT	 LONG				 !DOCUMENT NBR
GL_CODE		 STRING(12)			 !General Ledger Code
TRAN_DATE	 LONG				 !Transaction Date
TRAN_TIME	 LONG				 !Transaction Time (system time)
TRAN_DEBIT	 DECIMAL(11,2)			 !Transaction Amount (Debit)
TRAN_CREDIT	 DECIMAL(11,2)			 !Transaction Amount (Credit)
GEN_SOURCE	 STRING(10)			 !Transaction Source
GEN_REF		 STRING(25)			 !Reference
REVERSE		 STRING(1)			 !Reverse Next Period?
PERIOD		 BYTE				 !Posting Period
	     . .

GLSSYSINFO   FILE,PRE(GNF),NAME(GSYSINFO),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
DOC_NBR		 LONG				 !INTERNAL DOCUMENT NBR
	     . .

GLS	     FILE,PRE(GLS),NAME('GLS.DAT'),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
DRECORD	       RECORD
FILE1		 STRING(50)			 !FILE SPEC BUDGET FILE
FILE2		 STRING(50)			 !FILE SPEC HISTORY FILE
FILE3		 STRING(50)			 !FILE SPEC ACCOUNTS FILE
FILE4		 STRING(50)			 !FILE SPEC STD TRANSACTION FILE
FILE5		 STRING(50)			 !FILE SPEC GEN TRANSACTION FILE
FILE6		 STRING(50)			 !FILE SPEC ARCHIVE FILE
FILE7		 STRING(50)			 !FILE SPEC SYSINFO FILE
FILE8		 STRING(50)			 !FILE SPEC PERIODS FILE
FILE9		 STRING(50)			 !FILE SPEC BALANCES FILE
FILE10		 STRING(50)			 !FILE SPEC PRINTER FILE
FILE11		 STRING(50)			 !FILE SPEC
FILE12		 STRING(50)			 !FILE SPEC
DEAD_DATE	 LONG				 !DEMONSTRATION DEATH DATE
NAME		 STRING(30)			 !SYSTEM LICENSED TO . . .
	     . .

GLSACCOUNTS  STRING(50)
GLSGENTRAN   STRING(50)
GLSPERIODS   STRING(50)
GSYSINFO     STRING(50)

!
! SYSTEM-WIDE FILES
!
GAS	     FILE,PRE(GAS),NAME('GAS.DAT'),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
DRECORD	       RECORD
FILE1		 STRING(50)			 !FILE SPEC INFO FILE
FILE2		 STRING(50)			 !FILE SPEC PRINTER FILE
DEAD_DATE	 LONG				 !DEMONSTRATION DEATH DATE
NAME		 STRING(30)			 !SYSTEM LICENSED TO . . .
	     . .

INFO	     FILE,NAME(INFNAME),PRE(INF),RECLAIM,PROTECT
	     OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
CO_RPT		 STRING(60)			 !Company Report Name
CO_DISP		 STRING(30)			 !Company Display Name
CO_ADDR1	 STRING(30)			 !Company Address Line 1
CO_ADDR2	 STRING(30)			 !Company Address Line 2
CO_CITY		 STRING(25)			 !Company City
CO_STATE	 STRING(2)			 !Company State
CO_ZIP		 LONG				 !Company Zip Code
CO_PHONE	 STRING(12)			 !Company Phone Number
PRINTER_1	 STRING(40)			 !Printer Name
PRINT1_TYPE	 STRING(1)			 !Printer Type
PRINT_LOC1	 STRING(4)			 !Printer Location
PRINTER_2	 STRING(40)			 !Printer 2 Type
PRINT2_TYPE	 STRING(1)			 !Printer Type
PRINT_LOC2	 STRING(4)			 !Printer Location
	     . .

PRTFILE	  FILE,NAME(PRTNAME),RECLAIM,PROTECT
	  OWNER('MjamesA'),ENCRYPT
PRTKEY	    KEY(PRINTER,DESCRIP)		 !PRINTER KEY
RECORD	    RECORD
KEYGRP	      GROUP				 !KEY GROUP
PRINTER		STRING(8)			 !  PRINTER CODE
DESCRIP		STRING(25)			 !  FULL DESCRIPTION OF PRINTER
	      .					 !END KEY GROUP
CODEGRP	      GROUP				 !CODE GROUP
DPPRNT		STRING(5)			 !  DATA PROCESSING MODE ON
LQPRNT		STRING(5)			 !  LETTER QUALITY MODE ON
DWON		STRING(5)			 !  DOUBLE WIDE ON
DWOFF		STRING(5)			 !  DOUBLE WIDE OFF
DHON		STRING(5)			 !  DOUBLE HIGH ON
DHOFF		STRING(5)			 !  DOUBLE HIGH OFF
ULON		STRING(5)			 !  UNDERLINE ON
ULOFF		STRING(5)			 !  UNDERLINE OFF
BOLDON		STRING(5)			 !  BOLDFACE ON
BOLDOFF		STRING(5)			 !  BOLDFACE OFF
OVERON		STRING(5)			 !  OVERSTRIKE ON
OVEROFF		STRING(5)			 !  OVERSTRIKE OFF
SUPERON		STRING(5)			 !  SUPERSCRIPT ON
SUBON		STRING(5)			 !  SUBSCRIPT ON
SSOFF		STRING(5)			 !  SUPER/SUBSCRIPT OFF
ITLICON		STRING(5)			 !  ITALICS ON
ITLICOFF	STRING(5)			 !  ITALICS OFF
CPI10		STRING(5)			 !  10 CHARACTERS PER INCH(PICA)
CPI12		STRING(5)			 !  12 CHARACTERS PER INCH(ELITE)
CPI17		STRING(5)			 !  CONDENSED MODE
CPI17CANCEL	STRING(5)			 !  CANCEL CONDENSED MODE
BACKSPC		STRING(5)			 !  BACKSPACE CHARACTER
LINEFD		STRING(5)			 !  LINEFEED
FORMFD		STRING(5)			 !  FORMFEED
CR		STRING(5)			 !  CARRIAGE RETURN
MODELFCR	STRING(5)			 !  EACH LF = LF+CR
MODELF		STRING(5)			 !  LF ONLY, NO CR
MODECR		STRING(5)			 !  CR ONLY, NO LF
MODECRLF	STRING(5)			 !  EACH CR = CR+LF
UNIDIREC	STRING(5)			 !  UNIDERECTIONAL PRINT ONLY
BIDIREC		STRING(5)			 !  BIDIRECTIONAL PRINTING
RESET		STRING(5)			 !  PRINTER RESET
DUMMY1		STRING(5)			 !
DUMMY2		STRING(5)			 !
DUMMY3		STRING(5)			 ! RESERVED FOR FUTURE
DUMMY4		STRING(5)			 !	    USE
DUMMY5		STRING(5)			 !
DUMMY6		STRING(5)			 !
REVPRT		STRING(5)			 ! REVERSE PRINT
CANREVPRT	STRING(5)			 ! CANCEL REVERSE PRINT
	  . . .					 !END FILE, RECORD, GROUP

INFNAME	     STRING(50)
PRTNAME	     STRING(50)
