	name	wrap
;
; wrap.asm - routine to rotate a window right or left
;
; void wrap (shiftwin *win, int num);
; where shiftwin is a structure:
; typedef struct {
;     int x1, y1, x2, y2;
;     char attr;
; } shiftwin;
;
;
; coordinates are 1-relative
; and num is a positive number to shift right,
; or a negative number to shift left.
;
; NOTES:  calling this routine with any of the parameters outside legal values
;	  for your type of display will cause unpredictable results.
;	  The routine assumes an 80-column screen.  Actually, the assumption
;	  made is that the address of cell x,y+1 is the address of cell 
;	  x,y + 160.
;
	dosseg

ifdef	__COMPACT__
	.model	compact
endif
ifdef	__HUGE__
	.model	huge
endif
ifdef	__LARGE__
	.model	large
endif
ifdef	__MEDIUM__
	.model	medium
endif
ifdef	__SMALL__
	.model	small
endif

extrn	_scrseg:word
extrn	_getscr:proc
extrn	_shift:proc
extrn	_getofs:proc

	.code

_wrap	proc
	call	_getscr			;get screen information
	push	si
	push	di
	push	bp
	mov	bp,sp
	sub	sp,180			;make space for local variables
	push	es			;save cause we're gonna use it
	mov	ax,ds
	mov	es,ax
	mov	si,word ptr [bp+8]	;si points to shift window
					;[si+0] = x1
					;[si+2] = y1
					;[si+4] = x2
					;[si+6] = y2
					;[si+8] = attr
					;[bp+10] = num
	cmp	word ptr [bp+10],0
	jnz	wrap1
	jmp	all_done		;if 0, don't do it
wrap1:	jge	wrap_right
wrap_left:
	push	word ptr [si+0]		;left
	push	word ptr [si+4]		;right
	mov	ax,word ptr [bp+10]
	neg	ax
	mov	bx,-1
	jmp	short do_wrap
wrap_right:
	push	word ptr [si+4]		;right
	push	word ptr [si+0]		;left
	mov	ax,word ptr [bp+10]
	mov	bx,1
;
; SI is address to copy from
; DI is address to copy to
; AX is #colums to wrap
;
do_wrap:
	mov	word ptr [bp-174],ax	;save count
	mov	word ptr [bp+10],bx	;save direction
	mov	ax,word ptr [si+2]	;top row
	pop	bx
	call	_getofs
	mov	word ptr [bp-176],di	;save dest address
	mov	ax,word ptr [si+2]
	pop	bx
	call	_getofs
	xchg	si,di
	mov	word ptr [bp-178],si	;save source address
	mov	bx,word ptr [bp+8]	;address of win spec
	mov	ax,word ptr [bx+6]	;AX = y2
	sub	ax,word ptr [bx+2]
	inc	ax			;AX is number of rows
	mov	word ptr [bp-180],ax	;save #rows
	xchg	ax,cx
;
; The basic algorithm is:
; For each column to be wrapd
;     copy the column to the save area
;     call _shift to shift the screen
;     copy from save area to vacated column
;
wrap_loop:
	lea	ax,word ptr [bp-170]
	mov	di,ax			;dest is save area
	push	ds
	mov	ax,word ptr _scrseg
	mov	ds,ax
	cld
rl1:	movsw				;move char+attr
	add	si,158
	loop	rl1			;and loop till done
	pop	ds
;
; call _shift to do the work
;
	mov	ax,word ptr [bp+10]
	push	ax			;num on stack
	mov	ax,word ptr [bp+8]
	push	ax			;address of win spec
	call	_shift			;do the shift
	pop	cx
	pop	cx			;cleanup stack
	cld				;I guess shift screws things up
	lea	ax,word ptr [bp-170]
	mov	si,ax			;source is save area
	mov	di,word ptr [bp-176]	;dest is screen
	mov	cx,word ptr [bp-180]	;#columns
	push	es
	mov	ax,word ptr _scrseg
	mov	es,ax
rl2:	movsw				;move char+attr
	add	di,158
	loop	rl2
	pop	es
	dec	word ptr [bp-174]	;decrease column count
	jz	all_done
	mov	si,word ptr [bp-178]
	mov	cx,word ptr [bp-180]
	jmp	short wrap_loop
all_done:
	pop	es
	mov	sp,bp
	pop	bp
	pop	di
	pop	si
	ret
_wrap	endp
	public	_wrap
	end
