	name	shift
;
; shift.asm - routine to shift a window left or right a specified number
;             of columns.
;
; void shift(shiftwin *win, int num);
; where window is a structure defined as:
;   typedef struct {
;       int x1, y1, x2, y2;
;       char attr;
;   } shiftwin;
;
; coordinates are 1-relative
; and num is a positive number to shift right,
; or a negative number to shift left.
;
; NOTES:  calling this routine with any of the parameters outside legal values
;	  for your type of display will cause unpredictable results.
;	  The routine assumes an 80-column screen.  Actually, the assumption
;	  made is that the address of cell x,y+1 is the address of cell 
;	  x,y + 160.
;
	dosseg

ifdef	__COMPACT__
	.model	compact
endif
ifdef	__HUGE__
	.model	huge
endif
ifdef	__LARGE__
	.model	large
endif
ifdef	__MEDIUM__
	.model	medium
endif
ifdef	__SMALL__
	.model	small
endif

extrn	_scrseg:word
extrn	_getscr:proc

	.code

_shift	proc
	push	si
	push	di
	push	bp
	mov	bp,sp
	push	ds
	push	es			;save segment regs
	cmp	word ptr [bp+10],0
	jnz	shift1
	jmp	shift_done
shift1:	call	_getscr

	mov	di,word ptr [bp+8]	;di holds address of window spec
					;[di+0] = x1
					;[di+2] = y1
					;[di+4] = x2
					;[di+6] = y2
					;[di+8] = attr
	mov	cx,word ptr [bp+10]	;count in CX
	cmp	ch,80h
	jnc	shift_left		;negative count is right
shift_right:				;positive count is left
	mov	bx,word ptr [di+4]
	call	compute_ofs		;destination in di, source in si
	std
	jmp	short shifter
shift_left:
	mov	bx,word ptr [di]
	call	compute_ofs		;destination in di, source in si
	cld
shifter:
	mov	bx,word ptr ss:[bp+8]
	mov	ax,word ptr [bx+4]
	sub	ax,word ptr [bx]	;ax is window width
	inc	ax
	mov	dx,word ptr [bx+6]
	sub	dx,word ptr [bx+2]
	inc	dx			;dl is # rows to shift
	mov	dh,byte ptr [bx+8]	;dh is attr
	mov	bx,cx			;save shift count
	mov	cx,ax
	mov	ax,word ptr _scrseg
	mov	ds,ax
	mov	es,ax			;DS and ES are video segment
	mov	ah,dh			;space
	mov	al,20h			;with attribute
	xor	dh,dh
;
; AX is char/attribute for vacated columns
; BX is shift count (signed)
; CX is column count
; DX is # lines to shift
; DS and ES point to video segment.
;
shift_loop:
	push	si
	push	di
	push	cx			;save window width
	rep	movsw			;do the move
	mov	cx,bx			;restore column count
	cmp	ch,80h
	jc	sh2
	neg	cx
sh2:	add	di,bx
	add	di,bx
	rep	stosw			;clear vacated columns
	pop	cx
	pop	di
	pop	si
	add	di,160			;compute source and dest for
	add	si,160			;new row
	dec	dx			;dec row count, if not zero
	jnz	shift_loop		;then do it again
shift_done:
	pop	es			;restore segment regs
	pop	ds
	mov	sp,bp			;and everything else
	pop	bp
	pop	di
	pop	si
	ret	

compute_ofs:
	mov	ax,word ptr [di+2]
	dec	ax			;change for 1-relative
	mov	dx,160
	mul	dx			;160*row
	dec	bx			;for 1-relative
	add	ax,bx
	add	ax,bx			;+2*col
	mov	di,ax			;returns dest in di
	mov	si,ax
	sub	si,cx			;source in si
	sub	si,cx
	ret

_shift	endp
	public	_shift
	end
