UNIT MiscDOS;

  (********************************)
INTERFACE
  (********************************)

USES
  DOS;

FUNCTION i2s(i : Integer) : STRING;
{ returns ascii string for integer. }

FUNCTION FilePart(FName : PathStr; Ch : Char) : PathStr;
{ Splits FName and returns a part of it depending on Ch: }
{ Ch = 'D' = directory part. }
{      'N' = file name part. }
{      'E' = file extension. }

PROCEDURE Err(S : STRING);
{ writes string "S" and aborts program. }

PROCEDURE CheckIO;
{ aborts program if IOresult <> 0 }

PROCEDURE FindAFile(VAR Fn : STRING);
  { searches current dir, then home dir, then path. }
  { Returns Fn = '' if not found, or full path if found. }

PROCEDURE SetFileTime(Fn : PathStr; L : LongInt);
  { set filename "fn" time stamp to L (packed file time) }

  (********************************)
IMPLEMENTATION
  (********************************)

  FUNCTION i2s(i : Integer) : STRING;
  VAR
    S     : STRING[12];
  BEGIN
    Str(i, S);
    i2s := S;
  END;

  FUNCTION FilePart(FName : PathStr; Ch : Char) : PathStr;
  VAR
    Dir   : DirStr;
    Name  : NameStr;
    Ext   : ExtStr;
  BEGIN
    FSplit(FName, Dir, Name, Ext);
    CASE Ch OF
      'D' : FilePart := Dir;
      'N' : FilePart := Name;
      'E' : FilePart := Ext;
    ELSE WriteLn('BAD PARAMETER');
    END;
  END;


  PROCEDURE FindAFile(VAR Fn : STRING);
    { searches current dir, then home dir, then path. Returns Fn = '' if not found}
  VAR
    x     : Word;
    SrchPath : PathStr;
  BEGIN
    x := DosVersion;
    IF Lo(x) >= 3
    THEN SrchPath := FSearch(Fn, FilePart(ParamStr(0), 'D'))
    ELSE SrchPath := '';

    IF Length(SrchPath) = 0
    THEN SrchPath := FSearch(Fn, GetEnv('PATH'));
    Fn := SrchPath;
  END;

  PROCEDURE Err(S : STRING);
  BEGIN
    WriteLn(S);
    Halt(1);
  END;

  PROCEDURE CheckIO;
  VAR
    i     : Integer;
  BEGIN
    i := IoResult;
    IF i <> 0 THEN Err('IOerror: ' + i2s(i));
  END;

  PROCEDURE SetFileTime(Fn : PathStr; L : LongInt);
    { set filename "fn" time to L (packed file time) }
  VAR
    f     : FILE;
  BEGIN
    Assign(f, Fn);
    Reset(f); CheckIO;
    SetFtime(f, L); CheckIO;
    Close(f); CheckIO;
  END;

END.
