;
;  INT2E.ASM
;
;
; this routine calls the UNDOCUMENTED DOS interupt 2eh so that
; you can execute a command from within your program as it would
; behave if you typed it by hand. This means that you can actually
; set DOS environment variables using this call, and have the 
; change be permanent.
;
; To set an environment variable, you would setup a string so that
; the first byte contains the string length, and the actual string
; starts at byte 1. You must terminate the string with an 0dh.
; Then, you call int2e(char near *string). This routine only works
; in small model, but you could play around with it so that large
; model code would work.
;
; this code taken from an example in the magazine "C USERS GROUP"
; which I highly recommend for any serious C programmer.
;

.model small                    ; small model code only
.data                           
save_ss dw ?                    ; place to store stack info
save_sp dw ?

.code                           ; start of code area

public _int_2e                  ; global to all modules
_int_2e proc                    ; procedure definition
        push    bp              ; setup to access argument
        mov     bp,sp
        push    si              ; save registers we will trash
        push    di
        push    ds
        push    es
        mov     ax,dgroup       ; setup data segment
        mov     ds,ax
        mov     save_sp,sp      ; save stack pointer
        mov     save_ss,ss      ; and stack segment
        mov     si,[bp+4]       ; move dgroup offset (string to execute)
        int     2eh             ; make the undocumented DOS call
        mov     ax,dgroup       ; restore data segment
        mov     ds,ax
        cli                     ; disable ints
        mov     sp,save_sp      ; restore stack pointer
        mov     ss,save_ss      ; and stack segment
        sti                     ; enable ints
        pop     es              ; restore registers we destroyed
        pop     ds
        pop     di
        pop     si
        pop     bp
        ret                     ; all done

_int_2e endp

end

