


; TSR-EXE.ASM

; In Memory (as_is) -> 197,184 bytes (193k) --> 3 full segments + code seg.

; Interrupt handler tsr. Assemble and link as .exe.  

; The easiest way to do it....... In my opinion
; Running TSR_TEST.exe will make a call to int-60 which will invoke this TSR.
;  after running  it's course, control will be  returned to TSR-TEST.EXE. The 
;  program does nothing  more,  than first,  fill a memory location allocated 
;  for  use  by  the  "stack"  to  show that the area is actually valid, then 
;  little text-writing to the screen, followed by dumping the contents of one 
;  segment (filled with "A"), a pause to ask if you  want  to  continue,  and  
;  then dumping of a second segment filled  with  "B".  There  are  a  couple 
;  of calls to BIOS int 16h which gets keyboard  input, to show that  outside  
;  interrupts (keyboard int-09) are functioning correctly.The segement dumps, 
;  take  about  half  a  minute  each  on  a  386dx  25  mghz machine,  so be 
;  patient - don't concider it to be a computer mal-function.
; ________________________________________________________________________
; ------------------------------------------------------------------------

; NOTE!! No error  checking  is  done in this  program as_it_is. Doing a com-
;  plete error checking routine would make  this source code more than just a 
;  little  " H U G E ". For simple programs  I find all the fuss a little un-
;  worthy. Their  are  circumstances  however  when  you  ABSOLUTELY  M U S T 
;  "play by the rules",  and  take a lot of care  how, when, and where you go
;  loading a multi-segmented TSR into memory.
; Note also that this  TSR  assumes  that it is  the one and only handler for
;  interrupt 60h. Int-60h is a DOS stamped  "user interrupt" so it is usually
;  free for_the_using. However, if another TSR makes a call to this interrupt
;  while this TSR  is running, it will become re-entrant, and crash. To avoid 
;  that, you can add a few more lines of code to check for re-entry.

; The  intention  of  this  program demonstration, is to try and relay to you
;  various  steps  that  are taken to initialize a .exe tsr. Also I hope that 
;  you  will  be  able  to visualize, just what is going on within the memory
;  locations  where  this  program allocates for it's "playground." There are
;  really very few,  if  any  instances,  when you would actually write a tsr
;  of this proportion.  It  is good to know, however that whatever memory you
;  allocate is  "yours"  to pretty much do with as you please as long as your
;  program is active.
;---------------------------------------------------------------------------
; Let me know if you have any questions....... Tim Van Dusen CIS #73171,261
;---------------------------------------------------------------------------


; PROGRAM CODE SEGMENT  
code segment
assume cs:code, ds:code, ss:tsrstack

;****************************************************************************
; P U T    Y O U R    C O D E    B E L O W  .....in place of mine if you wish
;****************************************************************************
old_int         dd      0       ; old pointer saved here (not required here)
open    db      10 dup (10,13)
        db      "Currently in new int-60 handler"
        db      10,13,10,13
        db      "The following will dump the contents of first the first",10,13
        db      "segment (letter 'A'), pause, and then dump the contents",10,13
        db      "of the second segment (letter 'B'). It will then return",10,13
        db      "control to the calling program",10,13,10,13
        db      "Pressing 'Q' after any screen-write will terminate TSR."
        db      10 dup (10,13),"$"

flag    db      0

handler proc near                        
cli                     ; disable interrupts
push    ax              ; save register to be changed
mov     al, 20h         ; end-of-interrupt command
out     20h, al         ; issue command to controller
pop     ax              ; return register
sti

; Save all flags and register changed in routine
; Push flags       
        pushf
; Push registers         
push    ax
push    dx
push    di
push    es
push    ds

; Check stack segment by filling it, then dumping it.
mov     cx, 25000       ; Total size of this segment is 65,535 bytes. We must 
                        ;  leave a  small  amount  of space at the end of the 
                        ;  stack  segment  for  the  "normal" stack action of 
                        ;  this program.  So we'll leave  the  ending  15,000  
                        ;  bytes or so  untouched. We'll play around a little  
                        ;  within the first 50,000 bytes. You may notice that  
                        ;  we  are only loading 25,000 into cx. However since  
                        ;  cx is a "word" register, the following action will 
                        ;  actually put 50,000 bytes into the memory location 
                        ;  allocated to the stack.
fill_er_up:             ; Procedure to write to memory
push    ax              ; This  is the register we'll be pushing to the stack
dec     cx              ; One byte written so reduce cx by 1
cmp     cx, 0           ; Have we looped 25,000 times yet
jne     fill_er_up      ; If not, continue to loop

mov     cx, 25000       ; Prep cx for dump procedure
dump_it:                ; Procedure to dump memory 
pop     ax              ; Pop values from the stack via register AX
dec     cx              ; Reduce value in CX by 1
cmp     cx, 0           ; Are we at 0 yet?
jne     dump_it         ; If not continue the dump

; Stack works................. :)

; Below are several groups of DOS screen-writes which show that each of the
;  loaded segments can be accessed and read from.
; Following each screen-write is a simple BIOS get_key routine.
mov     ax, cs          ; Data is in code segment
mov     ds, ax          ;  be pointed to by "ds"
mov     es, ax          ;  and by "es"
mov     ah, 09h         ; DOS screen-write subfunction
mov     dx, offset cs:open ; where the data to write is located         
                                 
int     21h             ; DOS screen-write function

; Check to see if a key has been pressed. If so, exit.
call    cs:get_key      ; Procedure  to  check  for  user  interraction
cmp     cs:[flag], 0    ; Check to see if a key was pressed by checking
                        ;  the  offset  labeled "flag" created for that
                        ;  purpose
je      cs:carry_on     ; No key was pressed so carry on
jmp     cs:exit         ; Key was pressed by user, so exit

carry_on:               ; Got to next stage of program

assume ds:seg data      ; Re-define  register  DS  to  point to segment 
                        ;  labeled "data"
mov     ax,data         ; Use register AX
mov     ds,ax           ; To load register DS
mov     es,ax           ;  and register ES
mov     ah, 09h         ; DOS screen-write subfunction
mov     dx, offset open2   ; Where the new data is located
int     21h             ; DOS screen-write function

call    cs:get_key      ; Procedure to check for user input
cmp     cs:[flag], 0    ; Check  to  see if user has hit a key. If user has
                        ;  hit a key since our last check, this value would
                        ;  be "1"
je      cs:carry_on2    ; User still wants to remain in program
jmp     cs:exit         ; If not, we would have exited here
carry_on2:              ; Carry on to next step

assume  ds:seg data     ; Now we are going to set-up to fill the first
                        ;  defined "Data" type segment, titled apropiately
                        ;  "Data"
mov     ax,data         ; Pass the pointer AX
mov     ds,ax           ;  and on into register DS
mov     es,ax           ;  and register ES
mov     ah, 09h         ; DOS screen-write subfunction
mov     dx, offset letter_A ; Where the data_to_write is located
int     21h             ; DOS screen-write function

assume ds:seg data2     ; Point register DS to "data2" segment
mov     ax,data2        ; Move pointer to "data2" into AX
mov     ds,ax           ;  and on into DS register
mov     es,ax           ;  and into the ES register
mov     ah, 09h         ; DOS screen-write subfunction
mov     dx, offset open3  ; Where the data_to_write is located
int     21h             ; DOS screen-write function

call    cs:get_key      ; Check for user input via keystroke
cmp     cs:[flag], 0    ; If this value has been changed to "1" then a 
                        ;  key was pressed by user
je      cs:carry_on3    ; If value was "0" continue with program
jmp     cs:exit         ; If value was "1", then exit
carry_on3:              ; Else carry on.....

assume ds:seg data2     ; Set DS register to point to segment "data2"
                        ;  where we want to fill full of the letter "B"
mov     ax,data2        ; Use register AX to pass pointer to "data2"
mov     ds,ax           ;  on into register DS
mov     es,ax           ;  and register ES
mov     ah, 09h         ; DOS subfunction to write to the screen
mov     dx, offset letter_B ; the contents of the offset pointed to by DX
int     21h             ; DOS screen-write function

mov     ah,00           ; Loading high bytes of register AX with "00"
int     16h             ;  BIOS interrupt 16h results in the processor
                        ;  going into a loop routine, monitoring the key-
                        ;  board for user input (to put it "simply")

exit:                   ; We're done so let's exit

; Return all  registers changed in routine       
pop     ds              ; Return all registers to their original values
pop     es
pop     di
pop     dx
pop     ax

; jmp     cs:[old_int_?]  ;   process old interrupt if neccessary

; Return flags before exiting ISR       
popf
iret                    ; Interrupts are returned from using "iret"
endp    handler    

get_key proc near
push    ax              ; Save register that will be changed in procedure
mov     cs:[flag],0     ; Zero out our memory location set aside for the
                        ;  value returned by this routine
mov     ah, 00h         ; BIOS subfunction to get keyboard input
int     16h             ; BIOS function to get keyboard input
cmp     ah, 10h         ; Check to see if "Q" was pressed
jne     cs:done         ; If "Q" was not pressed, then exit
mov     cs:[flag],1     ; If this line wasn't "jumped_over" then the "Q"
                        ;  key was pressed, so we will pass this fact on
                        ;  to the line of code calling this procedure by 
                        ;  way of our "flag"
done:                   ; Key was pressed, so we'll exit
pop     ax              ; Pop original value back into register AX
ret                     ; Return from interrupt

endp    get_key

;***************************************************************************
;  F I N I S H    Y O U R    C O D E    H E R E
;***************************************************************************

zstuff  db      0       ; We'll  mark  the  end  of our memory-resident code
                        ;  here by using this label

;************************************************************************
; Start of non-resident installation portion this portion must always be 
;  last to keep it out of resident memory. And begin with the "start:"
;  variable

install proc far        ; Give the procedure an appropriate name

start:                  ; Start of code. This is the first line that will
                        ;  "run" when program is executed
push    cs              ; Push address of "code segment" to the stack
pop     ds              ;  and pop the address into "data segment" register

; get current interrupt vector and save in variable
        
mov     al, 60h         ; This is the interrupt that we are going to "hook"
                        ;  so that whenever this interrupt is called, our
                        ;  loaded tsr will run.
mov     ah, 35h         ; DOS subfunction to "get interrupt vector"
int     21h             ; DOS function to get pointer to current int. handler
mov     word ptr old_int, bx    ; Save values of old interrupt vector
mov     word ptr old_int+2, es  ; In the memory location, we've set aside for
                                ;  this purpose
; install new interrupt routine

mov     dx, offset handler
mov     al, 60h                                                         
mov     ah, 25h
int     21h              ; Install our interrupt 


; now determine the size to remain resident (paragraphs) 
;   and become a TSR

mov     dx, offset zstuff  ; End of resident code
mov     cl, 4           ; Get number of "paragraphs"
shr     dx, cl          ;  by right shifting
add     dx, 1           ; After shr, dx may equal 0, 
                        ;  so add one
add     dx, 11h         ; Add PSP size + 1 paragraph
mov     bx, offset ss:stacstart
mov     ax, offset ss:stacend   ; Get size of stack
sub     ax, bx          ; Do a little math to tally up total paragraphs
shr     ax, cl
add     ax, 1
add     dx, ax
        
assume ds:seg data
mov     bx, offset ds:datstart  ; Get size of data segment
mov     ax, offset ds:datend
sub     ax, bx
shr     ax, cl
add     ax, 1
add     dx, ax

assume ds:seg data2
mov     bx, offset ds:datstart2 ; get size of second data segment
mov     ax, offset ds:datend2
sub     ax, bx
shr     ax, cl
add     ax, 1
add     dx, ax                  ; DX now contains value of total
                                ;  segments.
add     dx, 04h                 ; Add extra paragraph for each segment for
                                ;  segment header. 
mov     ax, 3100h               ; Exit to DOS as tsr 
int     21h
endp install 

code    ends

; EXTRA SEGMENTS   

segment tsrstack  stack 'stack'
stacstart       db      0
                db      0fff0h dup (0)
stacend         db      0
ends tsrstack


segment data   'data'
datstart        db      0       
open2           db      10,13,"Ready to print contents of first segment?"
                db      10,13,"$"
letter_A        db      0ff00h dup ("A"),10,13,"$"
datend          db      0
ends data

segment  data2  'data2'
datstart2       db      0       
open3           db      10,13,"Ready to print contents of second segment?"
                db      10,13,"$"
letter_B        db      0fe00h dup("B"),10,13
                db      "Next keystroke will return you from interrupt","$"
datend2         db      0
ends data2
end     start

end



