	.286
	.MODEL  LARGE
	.STACK
	.DATA

pspseg  DW      0
prev    DB      0

	.CODE

	assume  ds:DGROUP
old1c   dd      0

tsr     PROC    FAR
	push    ds
	push    es
	pusha                           ; save registers and segments of
	mov     ax,DGROUP               ; previous program
	mov     ds,ax
	mov     ax,40H
	mov     es,ax                   ; set extended segment to get key
	mov     al,es:[17H]             ; status
	and     al,1CH                  ; if it's 10H, scroll lock pressed
	cmp     al,prev                 ; compare to it's previous state
	je      endit                   ; if it's not changed, exit
	mov     prev,al                 ; set new previous state
	cmp     al,1CH                  ; if changed, is it a 1?
	jne     endit                   ; no, exit
	mov     ah,00H                  ; SETVIDEOMODE subfunction
	mov     al,03H                  ; Mode#3 80x25x16 TEXT
	int     10H                     ; set mode
endit:  popa                            ; restore registers and segments
	pop     es
	pop     ds
	jmp     old1c                   ; jump back to previous program
tsr     endp
;
; First run of program starts HERE!
; Shift TSR procedure to TSR memory
;
start:  mov     ax,DGROUP               ; set DGROUP for storage of resident
	mov     ds,ax
	mov     ax,es
	mov     pspseg,ax               ; set vector to point to TSR proc
	mov     ax,351CH
	int     21H                     ; set vector
	mov     WORD PTR old1c,bx       ; get segments of previous program
	mov     WORD PTR old1c+2,es
	push    ds                      ; store current DS
	lea     dx,tsr                  ; move address of start of TSR
	mov     ax,cs                   ; routine to DX
	mov     ds,ax
	mov     ax,251CH
	int     21H                     ; timer tick routine
	pop     ds
	mov     dx,ss
	sub     dx,pspseg               ; get amount of memory of only TSR
	mov     ax,3100H                ; routine so only it will be stored
	int     21h                     ; shift to TSR
	end     start

	.EXIT
	END
