page	60,132

title	STEPRATE  A program to change the step rate of Floppy drives
;
; Before I receive any flames on the goodness of the following code, I
; would like to say that I find the 8088 destruction set disgusting.  I
; would have written this program in C (or some language which shelters
; me from the architecture but I have an inherent abhorance of 32K programs
; which do something as simple as this.
; If you do not like the way I wrote it, then feel free to rewrite it.
; In case you have not guessed, DEMENTed REGISTERS and I do not get along
; together.
;
;v1.1 Toad Hall Major Rewrite, 7 Feb 89
; - Original author unknown (snarfed from SEMPER BBS, Fayetteville NC)
; - Retabified to "normal" col-9 tabs
; - Changed some MASM-reserved labels (like loop)
; - Rewrote to .COM file format
; - MAJOR rewrites of command line processing,
;   Ascii to Binary conversion of step rate characters,
;   displaying selected rate
; - Now, if you enter with no cmdline parms, it will display the current
;   floppy disk step rate (with no change).
; - I'm trying VERY hard not to comment on the author's code
;   (given his disclaimer above).
;
;David Kirschbaum
;Toad Hall

CR	equ	0Dh		;carriage return character
LF	equ	0Ah		;line feed character

Page0	segment at 0		;v1.1
	org	78H		;Floppy disk steprate pointer
stepptr	dw	?

Page0	ENDS

;********************************************
CSEG	segment public para 'CODE'	;v1.1
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG	;v1.1

	org	80h
count	db	?			;PSP command line length

	org	100H			;normal .COM start	v1.1

StepRate	proc	near		;v1.1
	jmp	Start			;skip over data		v1.1

sm	db	'Floppy drive steprate: ',CR,LF
	db	'current: '
oldrate	dw	'%%'			;space for old rate
	db	', new: '
newrate	dw	'%%'			;space for new rate
	db	CR,LF,'$'

rateTable label	word			;v1.1
	db	' 3'
	db	' 6'
	db	' 9'
	db	'12'

stepTable label	byte			;v1.1
	db	0e0h			;3 ms step rate
	db	0d0h			;6 ms step rate
	db	0c0h			;9 ms step rate
	db	0b0h			;12 ms step rate


minval  db	'3, 6, 9 or 12 are the only recognized step rates.'
	db	CR,LF,'$'

StepRate	endp			;v1.1


Start	proc	near			;v1.1

; see if a step rate entered from the keyboard

;v1.1 Gonna use SI and CX to scan the PSP command line for a step rate.

	mov	si,offset count		;point to PSP command line
	lodsb				;snarf cmdline length byte
	xor	ah,ah			;clear msb
	mov	cx,ax			;CX is the counter
	jcxz	NoInput			;no input

	xor	dx,dx			;set 'accumulator' to 0
Loop1:
	lodsb				;next cmdline char
	cmp	al,' '
	jz	Aloop			;step past spaces

	cmp	al,'0'
	jb	NoInput			;bad, not a digit
	cmp	al,'9'
	ja	NoInput			;bad, not a digit

	sub	al,'0'			;deasciify
	shl	dl,1			;*2
	mov	dh,dl			;save that *2 value in DH
	shl	dl,1			;*4
	shl	dl,1			;*8
	add	dl,dh			;plus the *2 = *10
	add	dl,al			;plus the new value

Aloop:
	loop	Loop1			;do it for all chars

;Binary step rate 3,6,9, or 12 should be in DL
;Divide by 3 to get a table offset
;Any remainder, of course, means it was NOT a legal value.

	xor	dh,dh			;clear DX's msb
	mov	ax,3			;divisor
	xchg	dx,ax			;AL=step rate, DL=3
	div	dl			;dividend in AL, remainder in AH
	or	ah,ah			;any remainder?
	jnz	Not_Valid		;yep, invalid, help and terminate

;AL now has 1..4
	dec	ax			;adjust for table offset
	cmp	ax,dx			;<= 3 max value?
	jbe	Valid			;yep, so it's [0..3], legal

;v1.1 Come here if illegal steprate entry
Not_Valid:
	mov	dx, offset minval	;'3,6,9,12 are only recognized rates'

;v1.1 Enter here with a terminating message
Msg_Term:
	mov	ah,9
	int	21h
	mov	ax,4C00H		;terminate, errorlevel 0
	int	21H

;A nonvalid step rate number has been entered.
;Clear DX (to show no legal step rate),
;Skip down to read the current BIOS disk step rate

NoInput:
	xor	dx,dx
	jmp	short No_Rate

; a valid number has been entered, change the step rate to it
;AX has [3..0], the "inverted" steprate table offset
Valid:
	add	ax,offset stepTable	;add in step table base
	mov	bx,ax			;BX = 0..3
	mov	dl,[bx]			;DL = table step rate

No_Rate:
	xor	ax,ax			;handy 0			v1.1
	mov	DS,ax			;DS=page 0
	ASSUME	DS:Page0		;v1.1

	mov	ax,stepptr		;get the step rate pointer	v1.1
					; at 0:78H			v1.1
	mov	bx,ax			;into the bx register
	mov	al,[bx]			;now get the present step rate

	mov	dh,al			;save for later display		v1.1
	or	dl,dl			;any new rate to set?		v1.1
	jnz	New_Rate		;yep				v1.1
	 mov	dl,dh			;push current step rate into DL	v1.1
	 jmp	short No_Change		;skip				v1.1

New_Rate:
	and	al,0fh			;remove the old step rate
	or	al,dl			;put in the new step rate
	mov	[bx],al			;and put it back where it goes

	xor	ah,ah			;Now call on the BIOS to	v1.1
	int	13h			;reload the set floppy disk controller

No_Change:
	mov	ax,CS
	mov	DS,ax			;reset DS			v1.1
	ASSUME	DS:CSEG

; A new step rate has been successfully loaded,
; or we're just returning the current rate.
; Let's tell 'em what they got.
; DH=old steprate, DL=new steprate (if changed, else old steprate)
;v1.1 all new code

	mov	al,dh			;old steprate
	and	al,0F0H			;mask out all but steprate
	call	Get_Rate		;get Ascii rate into AX
	mov	oldrate,ax		;stuff in message

	mov	al,dl			;new steprate
	call	Get_Rate		;get Ascii rate into AX
	mov	newrate,ax		;stuff in message

	mov	dx,offset sm		;'Rate set to ...'
	jmp	Msg_Term		;display msg, terminate

Start	endp

;v1.1 Enter with AL=disk rate parameter (0B0H .. 0E0H)
;Exit with AX containing Ascii rate digits ' 3'..'12'

Get_Rate	proc	near		;v1.1
	xor	ah,ah			;clear msb
	sub	al,0B0H			;- highest rate (12ms)
					;AL is now 0 (12ms), 1 (9ms),
					; 2 (6ms), or 3 (3ms)
	mov	cl,4			;shift bits 5..8 to 1..4
	shr	ax,cl			;shift, AL now [0..3]

	mov	bx,ax			;keep in BX
	mov	al,3			;max value
	sub	al,bl			;- rate
	shl	ax,1			;*2 for words
	add	ax,offset rateTable	;' 3'..'12'
	mov	bx,ax			;into BX

	mov	ax,[bx]			;get rate
	ret
Get_Rate	endp

CSEG	ENDS
	end	StepRate
