; -------------------------
; SAY.COM disassembly by CJD
; -------------------------

; ----- Define locations of interest in the vector table
Abs0    segment at 0

        org 0F1H*4+2                    ; Speech segment address
SpPtr   label word

        org 0F3H*4                      ; Code to call Speech (INT F2)
Speech  label far

Abs0    ends

; ----- Define a dummy Speech code segment for code verification
SpeechSeg  segment at 0                  ; Don't really know where, but...
           org 100H
SpeechCode label byte
SpeechSeg  ends


; ----- Finally our real code segment
code    segment
assume  cs:code,ds:code,es:code
        org 80H                         ; Length of input parms
ParmLen label byte
        org 81H                         ; Start of input parms
Parms   label byte

        org 100H                        ; Start of .COM code
main proc far

        push ds
        push es

        mov ax,Abs0                     ; Get Speech seg addr to DS
        mov es,ax
        assume es:Abs0
        mov ax,word ptr SpPtr
        mov ds,ax
        assume ds:SpeechSeg

        cmp SpeechCode,090H             ; Verify 1st three bytes of Speech code
        jne Dumb
        cmp SpeechCode+1,1EH
        jne Dumb
        cmp SpeechCode+2,0B8H
        jnz Dumb

        pop es
        pop ds
        assume ds:code,es:code

        mov ah,ParmLen                  ; Get length of parms
        mov PLen,ah                     ; Put where Speech can find it (?)
        mov ax,offset PLen              ; AX = ptr to parm len
        push ax                         ; Put on stack
        call Speech                     ; Call Speech program

        int 20H                         ; Back to DOS

PLen    db ?                            ; Length of parameters
        dw Parms                        ; Pointer to parameters

Dumb$   db 'SPEECH not installed',13,10,10,'$'

Dumb:
        pop es
        pop ds
        mov dx,offset Dumb$
        mov ah,9
        int 21H
        int 20H

main endp
code ends
end main
