


    ;***********************************************************************
    ;*                     SIMPLE DEVICE DRIVER                            *
    ;*                      BY JEFF CHANDLLER                              *
    ;***********************************************************************




    ;***********************************************************************
    ;*                   INSTRUCTING THE ASSEBLER                          *
    ;*                                                                     *
    ;***********************************************************************

    CSEG        SEGMENT PARA    PUBLIC 'CODE'
    SIMPLE      PROC    FAR
                ASSUME  CS:CSEG,ES:CSEG,DS:CSEG


    ;***********************************************************************
    ;*                        MAIN PROCEDURE CODE                          *
    ;*                                                                     *
    ;***********************************************************************
                                                        
    BEGIN:


    ;***********************************************************************
    ;*                    DEVICE HEADER REQUIRED BY DOS                    *
    ;*                                                                     *
    ;***********************************************************************
                                                          
    NEXT_DEV    DD      -1              ;NO OTHER DEVICE DRIVERS
    ATTRIBUTE   DW      8000H           ;CHARACTER DEVICE
    STRATEGY    DW      DEV_STRATEGY    ;ADDRESS OF 1ST DOS CALL
    INTERRUPT   DW      DEV_INT         ;ADDRESS OF 2ND DOS CALL
    DEV_NAME    DB      'SIMPLE$ '      ;NAME OF THE DRIVER



    ;***********************************************************************
    ;*                   WORK SPACE FOR OUR DEVICE DRIVER                  *
    ;*                                                                     *
    ;***********************************************************************
                                                                      
    RH_OFF      DW      ?               ;REQUEST HEADER OFFSET
    RH_SEG      DW      ?               ;REQUEST HEADER SEGMENT
    MSGL        DB      07H
                DB      'THE WAITE GROUP SIMPLE DEVICE DRIVER! '
                DB      0DH,0AH,07H,'$'



    ;***********************************************************************
    ;*                    THE STRATEGY PROCEDURE                           *
    ;*                                                                     *
    ;***********************************************************************
                                                 
    DEV_STRATEGY:                       ;FIRST CALL FROM DOS

        MOV     CS:RH_SEG,ES            ;SAVE REQUEST HEADER PTR SEGMENT
        MOV     CS:RH_OFF,BX            ;SAVE REQUEST HEADER PTR OFFSET
        RET


    ;***********************************************************************
    ;*                    INTERRUPT PROCEDURE                              *
    ;*                                                                     *
    ;***********************************************************************
                                                

    DEV_INT:                            ;SECOND CALL FROM DOS

        CLD                             ;SAVE MACHINE STATE ON ENTRY (CLEAR)
        PUSH    DS
        PUSH    ES
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    DI
        PUSH    SI

    ;PERFORM BRANCH BASED ON THE COMMAND PASSED IN THE REQUEST HEADER

        MOV     AL,ES:[BX]+2            ;GET COMMAND CODE
        CMP     AL,0                    ;CHECK FOR 0
        JNZ     EXIT3                   ;NO - EXIT GO TO ERROR EXIT
        ROL     AL,1                    ;GET OFFSET INTO TABLE
        LEA     DI,CMDTAB               ;GET ADDRESS OF COMMAND TABLE
        MOV     AH,0                    ;CLEAR HI ORDER BYTE
        ADD     DI,AX                   ;ADD OFFSET
        JMP     WORD PTR[DI]            ;JUMP INDIRECT

    ;COMMAND TABLE
    ;         THE COMMAND CODE FIELD OF THE STATIC REQUEST
    ;         FIELD CONTAINS THE FUNCTION TO BE PERFORMED


    CMDTAB      LABEL   BYTE            ;
                DW      INIT            ; INITIALIZATION


    ;***********************************************************************
    ;*                        LOCAL PROCEDURES                             *
    ;*                                                                     *
    ;***********************************************************************

    INITIAL     PROC    NEAR

        LEA     DX,MSGL                 ;INITIALIZATION
        MOV     AH,9                    ;MESSAGE (PRINT STRING FUNCTION)
        INT     21H                     ;CALL DOS
        RET                             ;RETURN

    INITIAL     ENDP
    

    ;***********************************************************************
    ;*                     DOS COMMAND PROCESSING                          *
    ;*                                                                     *
    ;***********************************************************************

    ;COMMAND = 0        INITIALIZATION

    INIT:       CALL    INITIAL         ;DISPLAY A MESSAGE
                JMP     EXIT2


    ;***********************************************************************
    ;*                       ERROR EXIT                                    *
    ;*                                                                     *
    ;***********************************************************************

    ;SET THE DONE FLAG, ERROR FLAG, AND UNKNOWN COMAND ERROR CODE

    EXIT3:      MOV     ES:WORD PTR 3[BX],8103H

                JMP     EXIT1           ;RESTORE ENVIRONMENT


    ;***********************************************************************
    ;*                      COMMON EXIT                                    *
    ;*                                                                     *
    ;***********************************************************************
                                        
    
    ;COMMON EXITS       FALL THRU CODE
    ;                   2 SETS STATUS TO DONE AN NOERROR
    ;                   1 RESTORES CALLERS ES:BX
    ;                   0 RESTORES MACHINE STATE AND EXIT


    EXIT2:              ;SET DONE FLAG AND NO ERROR

                MOV     ES:WORD PTR 3[BX],0100H

    EXIT1:      MOV     BX,CS:RH_OFF    ;RESTORE REQUEST HEADER OFFSET TO BX 
                MOV     ES,CS:RH_SEG    ;AND ES AS SAVED BY DEV_STRATEGY
    
    EXIT0:      POP     SI              ;RESTORE ALL REGISTERS
                POP     DI
                POP     DX
                POP     CX
                POP     BX
                POP     AX
                POP     ES
                POP     DS
                RET

    ;***********************************************************************
    ;*                         END OF PROGRAM                              *
    ;*                                                                     *
    ;***********************************************************************
                                                

    SIMPLE ENDP     

    CSEG        ENDS

        END     BEGIN


    ;THAT'S ALL FOLKS
