	.model	small,c
;
; The following code assumes small C model (DS=SS).
;
; Intended usage:
;
;	if ((detect_stacker() != 0)
;	&& (detect_stacker_drive(driveNumber) != 0)
;	  	printf("Drive %c is a Stacker drive",'A'+driveNumber);
;	else
;	  	printf("Drive %c is a not a Stacker drive",'A'+driveNumber);
;
	.DATA
ST_PTR	DD	0			;pointer to Stacker (0-->not there)

	.CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
; C declaration:  int detect_stacker(void); 
;
; Input: None
; Output:AX=0  --> Stacker not installed
;	 AX<>0 --> Stacker version*100  (e.g.  1.00 --> 0064H)
;	
;	Stacker is detected by making an INT 25H call with invalid
;	parameters.
;

	PUBLIC detect_stacker

detect_stacker proc
	push	bp
	push	si
	push	di

	sub	sp,1024			;use the stack as a temp buffer
					;(in case INT 25 returns something!)

	mov	ax,0cdcdh		;invalid drive #
	mov	bx,sp			;DS:BX --> buffer for INT 25H
	mov	cx,1
	xor	dx,dx			;read boot sector of invalid drive
	mov	word ptr [bx],dx	;clear the "return" value
	push	ds			;(set ES:BP to fix DOS 3 INT 25H bug
	pop	es			; dealing with invalid drives)
	mov	bp,bx
	int	25H
	pop	cx			;get rid of flags

	xor	ax,ax			;default is No stacker
	mov	bx,sp			;point at result
	cmp	word ptr [bx],0CDCDH	;Stacker INT 25 fills in some fields.
	jnz	gotres			;Make sure they all match
	cmp	word ptr 2[bx],1
	jnz	gotres
	les	di,4[bx]		;pointer into Stacker
	cmp	word ptr es:[di],0A55AH	;must find signature
	jnz	gotres
	mov	word ptr st_ptr  ,di	;save pointer to show it's found
	mov	word ptr st_ptr+2,es
	mov	ax,es:[di+2]		;stacker version * 100
gotres:
	add	sp,1024

	pop	di			;restore regs
	pop	si
	pop	bp
	ret
detect_stacker	endp

;
; C declaration:  int detect_stacker_drive(int driveno);
;
; Input: driveno: 0=A, 1=B, 2=C, etc.
;
; Output:AX=0 --> Is not a Stacker drive
;	 AX=1 --> Is a Stacker drive
;	
; Notes:
;	 In a multitasking environment (e.g. Windows), or with certain TSRs
;	 present, this test may fail if a background process accesses a 
;	 Stacker drive at just the right time, modifying the UNIT_OFFS global
;	 in the Stacker resident driver.  Most Stacker utilities call this
;	 routine until the same result is returned several times in a row,
;	 in order to circumvent this potential (but rare) problem.
;
;	 This function uses the removeable media ioctl call to detect 
;	 Stacker drives.  However, under DR DOS 5.0, the get logical
;	 device call (440EH) is used, since DR DOS does NOT pass these
;	 calls through to the Stacker device driver.
;

UNIT_OFFS equ	3EH			;offset with Stacker of 

	PUBLIC detect_stacker_drive

detect_stacker_drive proc driveno:word
	uses	di,si

	cmp	word ptr st_ptr+2,0	;already found Stacker?
	jnz	stacker_fnd2
	call	detect_stacker		;if not, try again
	xor	ax,ax			;return 0 if not found
	cmp	ax,word ptr st_ptr+2	;is it there?
	jnz	stacker_fnd2		;
notstk2:ret
	; Here if Stacker IS installed.
stacker_fnd2:
	mov	ah,30h			;see if DOS 3.31 (DR DOS or Compaq)
	int	21h			;handle Compaq 3.31 like DR DOS
	cmp	ax,1F03H
	mov	ax,4408H		;do an ioctl call (removeable media)
	jnz	chkDrive
	mov	ax,440EH		;(get logical device for DOS 3.31)
chkDrive:
	mov	bx,driveno
	inc	bx			;adjust for default

	les	di,st_ptr
	mov	byte ptr es:UNIT_OFFS[di],0FFH	;set unit # in resident driver
	int	21h			;make the ioctl call
	les	di,st_ptr		;see if unit # changed during call
	mov	bl,byte ptr es:UNIT_OFFS[di]

	xor	ax,ax
	cmp	bl,0FFH			;set carry unless BL= 0FFH
	adc	al,0			;propagate carry into AL
	ret
detect_stacker_drive endp

	end
