/*
** SCSI Tape Control (Low Level)
**
** usage: mt bsf|bsr|eod|fsf|fsr|offline|online|eof|weof|erase|rewind [count]
**
** Revision History:
**
** Version 1.0  09/09/90 Initial Release
**
** Version 1.1  09/29/90 Use keywords instead of minus style options.
**                       This makes us a little more like the
**                       bezerkley 'mt' command.
**
** Version 1.2  10/04/90 Update the i/o packet structure.
**
*/
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <dos.h>
#include "ioctl.h"

#define TRUE (1)
#define FALSE (0)
#define VERSION "mt Version 1.2 BWA"

extern int _doserrno;

struct cmd ioctl_data;
union REGS inregs, outregs;
struct SREGS segregs;
int fd;
char *device = "SCSITAPE";
char far *cp;

main(argc, argv)
int argc;
char *argv[];
{
	/*
	** say hello
	*/
	if (argc < 2 || argc > 3) usage();
	if ( !strcmp(argv[1], "bsf") )			/* space by filemark */
	{
		ioctl_data.command = 'S';
		if (argc == 3)
			ioctl_data.arg1 = -atoi(argv[2]);
		else
			ioctl_data.arg1 = -1;
		ioctl_data.arg2 = 1;
	}
	else if ( !strcmp(argv[1], "bsr") )		/* space by block */
	{
		ioctl_data.command = 'S';
		if (argc == 3)
			ioctl_data.arg1 = -atoi(argv[2]);
		else
			ioctl_data.arg1 = -1;
		ioctl_data.arg2 = 0;
	}
	else if ( !strcmp(argv[1], "eod") )		/* space to eod */
	{
		if (argc == 3) usage();
		ioctl_data.command = 'S';
		ioctl_data.arg1 = 1;
		ioctl_data.arg2 = 3;
	}
	else if ( !strcmp(argv[1], "fsf") )		/* space by filemark */
	{
		ioctl_data.command = 'S';
		if (argc == 3)
			ioctl_data.arg1 = atoi(argv[2]);
		else
			ioctl_data.arg1 = 1;
		ioctl_data.arg2 = 1;
	}
	else if ( !strcmp(argv[1], "fsr") )		/* space by block */
	{
		ioctl_data.command = 'S';
		if (argc == 3)
			ioctl_data.arg1 = atoi(argv[2]);
		else
			ioctl_data.arg1 = 1;
		ioctl_data.arg2 = 0;
	}
	else if ( !strcmp(argv[1], "online") )
	{
		if (argc == 3) usage();
		ioctl_data.command = 'N';
	}
	else if ( !strcmp(argv[1], "offline") )
	{
		if (argc == 3) usage();
		ioctl_data.command = 'L';
	}
	else if ( !strcmp(argv[1], "eof") || !strcmp(argv[1], "weof") )
	{
		ioctl_data.command = 'M';
		if (argc == 3)
			ioctl_data.arg1 = atoi(argv[2]);
		else
			ioctl_data.arg1 = 1;
	}
	else if ( !strcmp(argv[1], "erase") )
	{
		if (argc == 3) usage();
		ioctl_data.command = 'E';
	}
	else if ( !strcmp(argv[1], "rewind") )
	{
		if (argc == 3) usage();
		ioctl_data.command = 'R';
	}
	else
	{
		usage();
	}

	/*
	** put together the command
	*/
	fd = open(device, O_WRONLY);
	if ( fd < 0 )
	{
		perror(device);
		exit(1);
	}
	inregs.h.ah = 0x44;			/* ioctl */
	inregs.h.al = 0x03;			/* write */
	inregs.x.bx = fd;			/* unit */
	inregs.x.cx = sizeof(struct cmd);
	cp = (char *) &ioctl_data;
	inregs.x.dx = FP_OFF(cp);
	segregs.ds = FP_SEG(cp);

	/*
	** start the command
	*/
	intdosx(&inregs, &outregs, &segregs);

	/*
	** see what happened
	*/
	if ( outregs.x.cflag )
		printf("mt: %s: error %d.\n", device, _doserrno);
	close(fd);
	exit(0);
}

usage()
{
	puts(VERSION);
	puts("usage: mt bsf|bsr|eod|fsf|fsr|offline|online|eof|weof|erase|rewind [count]");
	exit(1);
}
