Title  -Utility Program to Dump the Screen to a Disk File
;(Scrndmp.asm)

Page ,132
COMMENT |
  This program this a memory-resident utility that uses INT 5 
  (PrtSc) to dump the screen contents to a disk file.  The 
  filename is chosen when the program is loaded into memory, and
  remains in effect until the system is re-booted.  Each additional
  use of Shift-PrtSc appends to the existing file.
|END COMMENT

    ;----- (this value will change if the program is modified)
  installed_filename   equ	02BAH	; offset of filename in 
					; program when it is installed
  cr	equ	0DH
  lf	equ	0AH

if1					; include macro library
  include Lib1.ASM
endif
.SALL

abso	segment	at 0			; Interrupt vector table
	org	4*5H			; vector for INT 5
  print_int	DD	?
abso	ends

code	segment
	org	100H
	assume	cs:code,ds:code,es:code
first:	jmp	start
  print_vector	DD	?		; Save the old vector address

start:	
        cls				; clear screen
	locate  3,0
	writestr	msg1		; display greeting
  get_file_name:
	mov	DX,offset kbd_buffer_size
	mov	AH,0AH
	int	21H
	xor	BX,BX
	mov	BL,keys_typed		; length of file name
	mov	filename[BX],0  	; place a zero terminator

  get_print_vector: 
	sub	AX,AX
	mov	ES,AX
	assume	ES:abso			; get original int 5H vector
	mov	AX,word ptr print_int   ; and save it in print_vector
	mov	BX,word ptr print_int+2
	mov	word ptr print_vector,AX
	mov	word ptr print_vector+2,BX
	cmp	BX,0F000H		; does it still point to BIOS?
	jnz	already_loaded		; no - this prog. probably loaded

	; (no interrupts while setting new vectors)
  change_print_vector:
	cli				; disable interrupts
	mov	word ptr print_int, offset print_handler  ; offset
	mov	word ptr print_int+2,CS			  ; code seg
	sti				; re-enable interrupts
  	cls
	lea	DX,prog_end		; point to end of program
	int	27H			; exit and stay resident

  already_loaded:			; change the output filename
	cli				; disable other interrupts
	mov	si,offset filename
	mov	di,installed_filename	; DI points to offset of filename
					; in the installed procedure.
	mov	ax,bx			
	mov	es,ax
	mov	cx,15			; now copy the filename into
  rep   movsb				; the installed procedure
	sti				; re-enable interrupts
	cls
	int	20H			; exit, but not resident.


;------- This routine handles INT 17H BIOS calls
;  Output is automatically routed to <filename>.

print_handler	proc	far
	assume	cs:code,ds:code,es:code
	cli				; disable outside interrupts
	push	AX
	push	BX
	push	CX
	push	DX
	push	DS			; save current DS

	push	CS			; set DS to CS
	pop	DS
	call	get_screen		; dump screen to buffer
	sti				; re-enable interrupts

  open_file_for_output:
	mov	DX,offset filename
	mov	AH,3DH			; function=open
	mov	AL,1			; mode: output
	int	21H			; file handle in AX
	jnc	move_file_pointer	; file exists if no carry

  create_file:
	mov	AH,3CH			; function=create
	mov	CX,0			; file attribute=normal
	int	21H			; file handle in AX
	jnc	move_file_pointer	; no error? move pointer
	writestr err1			; if carry, then error

  move_file_pointer:
	mov	BX,AX			; file handle
	mov	AH,42H			; function=move pointer
	mov	AL,2			; move to end of file
	xor	CX,CX			; plus offset CX:DX
	xor	DX,DX
	int	21H	

  write_record:
	mov	AH,40H			; function: write to device
	mov	CX,buffer_length	; char count
	mov	DX,offset hold_buffer
	int	21H
	jnc	close_file		; no error? Close file
	writestr err2			; yes? print message

  close_file:				; (BX contains file handle)
	mov	AH,3EH			; close file and flush buffer
	int	21H	

	pop	DS			; Restore all changed 
	pop	DX			;   registers.
	pop	CX
	pop	BX
	pop	AX
	iret				; Return from interrupt

   err1  DB 'Error in Opening the Screen Dump File.  '
         DB 'Please check the disk.',cr,lf,0
   err2  DB 'Error in Writing to the Screen Dump File.  '
         DB 'Please check the disk.',cr,lf,0
   kbd_buffer_size	DB	14
   keys_typed		DB	0
   filename 	DB 15 dup(' '),0	; Must have zero terminator
					; for the OPEN function.
print_handler	endp


;-------------------------------------------------------------
;  This procedure takes a direct-memory snapshot of the screen
;  and saves it to a buffer.  Every other character is saved,
;  so that it may be written to a text file.
;-------------------------------------------------------------

get_screen	proc	near
	push	DS
	push	AX
	push	CX
	push	SI
	push	DI

	mov	AX,0B000H	;screen buffer for monochrome
	mov	DS,AX
	mov	BX,25		;number of screen lines
	xor	SI,SI
	mov	DI,offset hold_buffer

  next_line:
	mov	CX,80		;characters per line
  get_char:
	mov	AL,[SI]		;get screen character
	mov	CS:[DI],AL	;and place in CS:hold_buffer
	add	SI,2		;skip to next screen character
	inc	DI		;point to next position in buffer
	loop	get_char	;until CX=0

  add_crlf:	; (add a CRLF to buffer at end of each line)
	mov	byte ptr CS:[DI],0DH
	mov	byte ptr CS:[DI+1],0AH
	add	DI,2
	dec	BX
	cmp	BX,0		;last line of screen?
	jnz	next_line	;no- do another

	pop	DI
	pop	SI
	pop	CX
	pop	AX
	pop	DS
	ret

hold_buffer	DB	2050 dup(0)     ;(25*80, + (25*2-cr/lf)
buffer_length   DW      $-hold_buffer
buffer_end	label	byte		; marker for end of buffer

get_screen	endp

prog_end	label	byte	;***** End of Resident Program ******


;------------------- Data Area....Not resident -----------------

Msg1 DB  9,'                  S C R N D M P . C O M',cr,lf,cr,lf
 DB  9,'By Kip Irvine                         (Version 1.0, 04/85)',cr,lf
 DB  79 dup(0c4H),3 dup(cr,lf)
 DB  9,'This is a memory-resident program that allows you to dump ',cr,lf
 DB  9,'the contents of the screen at any time to a chosen filename.',cr,lf
 DB  9,'For example, while using WordStar or Lotus 1-2-3, you can type',cr,lf
 DB  9,'<Shift - PrtSc> to append to the disk file that was chosen',cr,lf
 DB  9,'when the program was loaded.',cr,lf
 DB  cr,lf
 DB  9,'The same filename will be added to until this program is ',cr,lf
 DB  9,'loaded again.',cr,lf
 DB  9,'To clear this program from memory so that PrtSc can be used ',cr,lf
 DB  9,'for its normal function, you must re-boot the system.',3 dup(cr,lf)
 DB  79 dup(0c4H),cr,lf
 DB  9,'Name of output file to be created?...',0

code	ends
	end	first
