	PAGE	66,132		;Setup page as 66 lines, 132 columns
TITLE	SCRN - Subroutines for BASIC to control text windowing
;
;
SUBTTL	Code
CSEG	SEGMENT PARA PUBLIC 'CODE'
START	PROC	FAR	;Routine
	ASSUME	CS:CSEG,DS:CSEG,SS:NOTHING,ES:NOTHING
;
;
; The following define the bytes for each screen control entry at the
; end of the code of this bank.  The order of these entries correspond
; to that on the call to DEFW routine to define a window.
;
ULC	EQU	0	; Word entry containing next two bytes
LCOL	EQU	0	; Left column for window (0 - 79)
TROW	EQU	1	; Top row for window (0 - 24)
LRC	EQU	2	; Word entry containing next two bytes
RCOL	EQU	2	; Right column for window (0 - 79)
BROW	EQU	3	; Bottom row for window (0-24)
ATTR	EQU	4	; Window text attribute
LENWIN	EQU	5	; Window length in bytes
;
;
	RET	0		;Dummy return for zero callers
	DB	?		;Fill in case we expand entry zero
;
WINUM	DB	1		;Window number (default window 1)
LENT	DB	LENWIN		;Window size
;
	JMP	SHORT	SCU	;Scroll up
	JMP	SHORT	SCD	;Scroll down
	JMP	SHORT	CEOL	;Clear to end of line
	JMP	SHORT	CEOS	;Clear to end of window
	JMP	SHORT	ATRB	;Change window attribute
	JMP	SHORT	DEFW	;Define a window
;
;
SCU	LABEL	NEAR		;Scroll up window
	MOV	DH,6		;Function scroll up
	JMP	SHORT	SCROLL	;
;
SCD	LABEL	NEAR		;Scroll down window
	MOV	DH,7		;Function scroll down
SCROLL	LABEL	NEAR		;Entry for SCU
	PUSH	BP		;Common code
	MOV	BP,SP		;
	MOV	SI,[BP+6]	;Get argument address
	MOV	AX,[SI]		;Get value
	MOV	AH,DH		;Function
	CALL	BASE		;Get data area base
	MOV	CX,ULC[DI]	;Upper left corner
	MOV	DX,LRC[DI]	;Lower right corner
	MOV	BH,ATTR[DI]	;Attribute
	INT	10H		;Enter BIOS
RET2:	POP	BP		;
	RET	2		;Return
;
;
CEOL	LABEL	NEAR		;Clear to end of line in window
	PUSH	BP
	CALL	GETP		;Get position
	CALL	CLRLIN		;Clear to end
	POP	BP		;
	RET	0		;And go home
;
;
CEOS	LABEL	NEAR		;Clear to end of screen window
	PUSH	BP		;
	CALL	GETP		;Get position
	PUSH	DX		;Remember that
	CALL	CLRLIN		;Clear rest of this line
	POP	DX		;Recall what that was
	CMP	DH,BROW[DI]	;Close to bottom?
	JZ	CEOSX		;Yes, exactly
	MOV	CH,DH		;No, scroll rest of lines
	INC	CH		;
	MOV	CL,LCOL[DI]	;Left column
	MOV	DX,LRC[DI]	;Lower right corner
	MOV	BH,ATTR[DI]	;Attribute to fill
	MOV	AX,0700H	;Function 7 and 0 to clear
	INT	10H		;Call BIOS
CEOSX	LABEL	NEAR
	POP	BP		;
	RET	0		;And go home
;
;
ATRB	LABEL	NEAR		;Change attribute for current window
	PUSH	BP
	MOV	BP,SP
	CALL	BASE
	MOV	SI,[BP+6]
	MOV	AL,[SI]
	MOV	ATTR[DI],AL	;New attribute for window
	JMP	SHORT	RET2	;Return to caller offset 2
;
;
DEFW	LABEL	NEAR		;Define a window
	PUSH	BP
	MOV	BP,SP
	MOV	SI,[BP+16]	;1st agrgument is screen number
	MOV	AX,[SI]		;Get value
	CALL	SHORT	NEXT1	;
NEXT1:	POP	DI		;Get Pregister
	SUB	DI,OFFSET(NEXT1-START) ;Okay
	MOV	WINUM[DI],AL	;And store it
	CALL	BASE2		;Base window area
	PUSH	ES
	PUSH	DS
	POP	ES
	MOV	SI,[BP+12]	;Left column
	MOVSB
	DEC	BYTE PTR [DI-1]	;All coordinates need to be based (0,0)
	MOV	SI,[BP+14]	;Top row
	MOVSB
	DEC	BYTE PTR [DI-1]
	MOV	SI,[BP+8]	;Right column
	MOVSB
	DEC	BYTE PTR [DI-1]
	MOV	SI,[BP+10]	;Bottom row
	MOVSB
	DEC	BYTE PTR [DI-1]
	MOV	SI,[BP+6]	;Attribute
	MOVSB
	POP	ES
	POP	BP
	RET	12
;
;
GETP	PROC	NEAR
	MOV	BX,0		;
	MOV	AH,3		;Read current position
	INT	10H		;
	RET			;
GETP	ENDP
;
;
CLRLIN	PROC	NEAR
	CALL	BASE		;Get data area base
	MOV	CL,RCOL[DI]	;Right window limit
	MOV	CH,0		;Clear top end
	SUB	CL,DL		;Subtract columns done
	ADD	CL,1		;Add one till we figure out whats wrong
	MOV	AX,0920H	;Write blanks
	MOV	BL,ATTR[DI]	;Attribute
	INT	10H		;
	RET			;
CLRLIN	ENDP
;
;
BASE	PROC	NEAR
	CALL	SHORT	NEXT	;To capture P address
NEXT:	POP	DI		;Get that for index
	SUB	DI,OFFSET (NEXT-START)	;For code relative offset
BASE2	LABEL	NEAR		;Alternate entry
	PUSH	AX
	MOV	AL,WINUM[DI]	;Get window number
	DEC	AL		;Make zero relative
	MUL	LENT[DI]	;Multiply by lenth of window
	ADD	AX,OFFSET DATA	;Move to data area
	ADD	DI,AX		;Add into segment offset
	POP	AX
	RET
BASE	ENDP			;That is all
;
;
DATA	DB	0,0,79,23,7	; Window 1 default data
;
;
START	ENDP
CSEG	ENDS
	END

                                      