
%TITLE "VGA graphic module
;---------------------------------------------------------------------
;      S.Hyun Yim
;
;      This module contains simple VGA 320*200*256 graphic functions
;      useful for the manipulation (and animation) of arbitrary
;      bitmap images.
;------------------------------------------------------------------------
; CAUTION!
;      1. This module is written in Ideal-Small model, meaning you need
;         Borland Turbo Assembler to compile it.
;         (You can easily change this module to a memory model other than
;          small.)
;      2. All the functions in this module assumes that video mode is
;         already set to 13h using BIOS 10h service AND es points to the
;         video buffer (0A000h) Both conditions must be met prior to
;         calling any functions here.
;      3. The functions does not test if VGA card is present. It's the
;         job of the caller to make sure!
;------------------------------------------------------------------------
;
;---------------------------------------------------------------------

       IDEAL
       DOSSEG
       MODEL small

       DATASEG


space        DW   0


       CODESEG

       PUBLIC    putXor,putAND,putAnywhere

%NEWPAGE
PROC putXOR
;------------------------------------------------------------
; This function puts the bitmap image using XOR method.
; You can use this function to create simple XOR animation.
;------------------------------------------------------------
; input: ax=y coord. of top left   bx=x coord. of top left
;        ds:si=offset of bitblockimage
;---------------------------------------------------------
     call getAddr256

       mov     cx,[si]         ; X size of the bitmap
       mov     dx,[si+2]       ; Y size of the bitmap

      mov     bh,dl             ; bh now hold Y dim
      xor     bl,bl
      mov     dx,cx
      cld
XBB1:
      lodsb                       ; load [ds:si] to al
      xor     [es:di],al          ; xor [es:di] with al
      inc     di                  ; inc di by 1
      loop    XBB1                ; loop instruction

      add     di, 320
      sub     di, dx
      mov     cx, dx
      inc     bl
      cmp     bl,bh               ; did it reach end of line?
      jne     XBB1                ; if not go back


     ret
ENDP putXOR

PROC putAND
;------------------------------------------------------------------
; This function puts bitmap image to the video buffer(es).
; But before copying each pixel down, it tests if the color of the
; bit map pixel is Zero. If it is, it does not update the video
; buffer and skips to the next.
; You can use this function to display any arbitrary bitmap sprite
; against a complex background.
;
;    input : same as putXOR
;-------------------------------------------------------------------
     call getAddr256

      mov     cx,[si]           ; x size
      mov     dx,[si+2]         ; y size

      mov     bh,dl             ; bh now hold Y dim
      xor     bl,bl
      mov     dx,cx
      cld
ABB1:
      lodsb
      or      al,al              ; is pixel of bit block zero?
      jz      @@abb              ; if yes, skip putting the pixel down
      stosb                      ; if not, put the pixel
      jmp     @@abb2             ; go on
@@abb:inc     di
@@abb2:loop    ABB1              ; loop instruction

      add     di, 320
      sub     di, dx             ; set di to the next line
      mov     cx, dx
      inc     bl                 ; increase bl by 1
      cmp     bl,bh              ; did it reach last line?
      jne     ABB1               ; if not go back

      ret
ENDP putAND

%NEWPAGE
PROC putAnywhere
;------------------------------------------------------------------
; Same as putAND, except for it trims the image outside the screen
; (COOL!)
;------------------------------------------------------------------
     mov      cx,[si]
     mov      dx,[si+2]
     mov      [space],0
     cmp      bx,0          ; is X less than 0?
     jge      @@bigX?
     add      cx,bx
     neg      bx
     mov      [space],bx
     xor      bx,bx
     add      si,[space]
     jmp      @@y?
@@bigX?:                    ; does image go beyond the X limit?
     add      cx,bx
     cmp      cx,320
     jle      @@restoreReg
     sub      cx,320
     mov      [space],cx
     mov      cx,320
@@restoreReg:
     sub      cx,bx

@@y?:                      ; is y less than 0?
     cmp      ax,0
     jge      @@y?2
     add      dx,ax      ; add ax(negative value) to y dimension
     neg      ax         ; get absolute value
     mul      cl
     add      si,ax
     xor      ax,ax

@@y?2:                   ; is a portion of image beyond y limit?
     add      dx,ax
     cmp      dx,200
     jle      @@restoreReg2
     mov      dx,200
@@restoreReg2:
     sub      dx,ax            ; restore the value of dx

;-----put
     call getAddr256

      mov     bh,dl             ; bh now hold Y dim
      xor     bl,bl
      mov     dx,cx
      cld
PBB1:
      lodsb
      cmp     al,0   ; is pixel of bit block zero?
      je      @@abb             ; if not, put the pixel
      stosb
      jmp     @@abb2             ; go on
@@abb:inc     di
@@abb2:loop    PBB1              ; loop instruction

      add     di, 320
      sub     di, dx             ; set pointer to next line
      mov     cx, dx
      inc     bl                 ; increase bl by 1
      cmp     bl,bh              ; did it reach last line?
      jne     PBB1               ; if not go back

      ret
ENDP putanywhere

PROC getAddr256
;-------------------------------------------------------
; an internal routine calculating offset of the pixel
;------------------------------------------------------
     xchg     ah,al
     add      bx,ax
     shr      ax,1
     shr      ax,1
     add      bx,ax
     mov      di,bx           ; move address to di
     ret
ENDP getAddr256

      END                     ; End of module


     END