	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	FlashDelay	EQU	0EFFFh		;Empty loop count

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	strings.mac
	INCLUDE	video.mac
ENDIF

	EXTRN	hideMouseCursor:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Self:WORD

	.CODE

	PUBLIC	menuInstVars
COMMENT	%
==============================================================================
Gets the instance variables for Menu objects.

Passes:	bl - Color
	cx - Lower/Right row/column
	di - Menu index ptr
	dx - Upper/Left row/column
	si - Menu table ptr

=============================================================================%
menuInstVars	PROC	NEAR
	getInst		dh,Row1,Self		;Get upper row
	getInst		dl,Col1			;Get left column
	getInst		ch,Row2			;Get lower row
	getInst		cl,Col2			;Get right column
	getInst		bl,Color		;Get window color
	getInst		di,InxPtr		;Menu index pointer
	getInst		si,MenuPtr		;Menu pointer
	ret
menuInstVars	ENDP



IF Dbug
	PUBLIC	hiliteOff
ENDIF
COMMENT	%
==============================================================================
Turns off the currently hilited menu item.

=============================================================================%
hiliteOff	PROC	NEAR
	call		menuInstVars
	add		si,di			;Point to menu entry
	call		disMenuItem		;De-Hilite menu item
	ret
hiliteOff	ENDP



COMMENT	%
==============================================================================
Hilites a menu item.

Passed:	StackTop - New menu index

=============================================================================%
hiliteOn	PROC	NEAR
	call		hideMouseCursor		;Hide mouse cursor
	call		menuInstVars
	getStackArgs	di			;Get menu index
	reverseVideo	bl			;Get reverse video attr
	add		si,di			;Point to menu entry
	call		disMenuItem		;Hilite menu item
	setInst		InxPtr,di,Self		;Set new menu index 
	ret
hiliteOn	ENDP



COMMENT	%
==============================================================================
Displays a menu item.

Passed:	bl - Color
	cx - Lower/Right row/column
	dx - Upper/Left row/column
	si - Menu item handle

=============================================================================%
disMenuItem	PROC	NEAR
	pushData	<cx,di>
	mov		dx,Wptr[si]		;Get row/col
	mov		si,Wptr[si+2]		;Get string address
	push		dx
	disStrg		dh,dl,bl,si		;Display the string
	pop		dx

	getInst		ch,Row2,Self		;Get lower row
	getInst		cl,Col2			;Get right column
	sub		ch,dh			;Calc window height
	zero		ch,dsmi1		;Horizontal menu? - Exit
	push		dx
	disAttr		dh,dl,cl,bl		;Else - Display the attributes
	pop		dx
dsmi1:	popData		<di,cx>
	ret
disMenuItem	ENDP



IF Dbug
	PUBLIC	nextMenuItem
ENDIF
COMMENT	%
==============================================================================
Moves the hilite to the next menu item.

=============================================================================%
nextMenuItem	PROC	NEAR
	call		menuInstVars_		;Get menu data
	dec		ch			;Account for border

	add		di,4			;Increment index ptr
	add		si,di			;Point to next menu item
	identity	Wptr[si],nmi1		;Next item ok? - Use it

	notZero		ax,nmi0			;Vertical? - Jump
	mov		ax,di
nmi0:	sub		di,ax			;Else use top item
	jmp		nmi3

nmi1:	neq		Bptr[si-3],ch,nmi3	;Not at bottom? - Skip
	push		di
	send		Self,ScrollUp,1		;Else scroll
	pop		di

nmi3:	send		Self,Hilite,di		;Hilite menu item
	ret
nextMenuItem	ENDP



IF Dbug
	PUBLIC	prevMenuItem
ENDIF
COMMENT	%
==============================================================================
Moves the hilite to the previous menu item.

=============================================================================%
prevMenuItem	PROC	NEAR
	call		menuInstVars_		;Get menu data
	mov		ch,dh			;Save upper row
	inc		ch			;Account for border

	notZero		di,pmi1			;Not 1st item? - Use it
	notZero		ax,pmi0			;Vertical? - Jump

pmi4:	add		di,4			;Increment index ptr
	add		si,4			;Point to next menu item
	identity	Wptr[si],pmi4		;Not end of tbl? - Loop
	jmp		pmi5

pmi0:	add		di,ax			;Else use bottom item
pmi5:	sub		di,4			;Point to last entry
	jmp		pmi2

pmi1:	sub		di,4			;Decrement index ptr
	add		si,di
	neq		Bptr[si+5],ch,pmi2	;Not at top? - Skip
	push		di
	send		Self,ScrollDown,1	;Else scroll
	pop		di

pmi2:	send		Self,Hilite,di		;Hilite new menu item
	ret
prevMenuItem	ENDP



COMMENT	%
==============================================================================
Helper function that returns menu data for next/prevMenuItem procedures.

Passes:	ax - Number of menu items
	bl - Color
	cx - Lower/Right row/column
	di - Menu index ptr
	dx - Upper/Left row/column
	si - Menu table ptr

=============================================================================%
menuInstVars_	PROC	NEAR
	call		menuInstVars
	xor		ax,ax
	eq		ch,dh,mni1		;Horizontal? - Exit
	push		cx
	sub		ch,dh			;Get window height
	dec		ch			;Number of visible menu items
	mov		cl,ch			;Set up loop counter
	xor		ch,ch
	mov		al,4			;Calculate offset
	mul		cl			;Bottom-Top=ax
	pop		cx
mni1:	ret
menuInstVars_	ENDP



IF
	PUBLIC	selectItem
ENDIF
COMMENT	%
==============================================================================
Selects the currently hilited menu item by calling the specified procedure.

=============================================================================%
selectItem	PROC	NEAR
	getInst		bx,InxPtr,Self		;Current menu item
	getInst		si,MenuTbl		;Current menu tbl
	null		bx,slm2			;Exit if Nil

	sendLoop	si,bx,bx+2		;Send messages

slm2:	ret
selectItem	ENDP



COMMENT	%
==============================================================================
Updates next visible menu item with row and column data.

=============================================================================%
updateNextItem	PROC	NEAR
	call		updateItem_		;Get menu data
	mov		Wptr[si+4],dx		;Update next menu item
uni1:	dec		dh			;Decrement row
	mov		Wptr[si],dx		;Save new row
	sub		si,4			;Point to prev menu item
	mov		dx,Wptr[si]		;Get row/col
	loop		uni1
	ret
updateNextItem	ENDP



COMMENT	%
==============================================================================
Updates previous visible menu item with row and column data.

=============================================================================%
updatePrevItem	PROC	NEAR
	call		updateItem_		;Get menu data
	mov		Wptr[si-4],dx		;Update prev menu item
upi1:	inc		dh			;Increment row
	mov		Wptr[si],dx		;Save new row
	add		si,4			;Point to next menu item
	mov		dx,Wptr[si]		;Get row/col
	loop		upi1
	ret
updatePrevItem	ENDP



COMMENT	%
==============================================================================
A helper function that returns common instance data for updating location
information for scrollable menus.

=============================================================================%
updateItem_	PROC	NEAR
	call		menuInstVars

	sub		ch,dh			;Get window height
	dec		ch			;Number of visible menu items
	mov		cl,ch			;Set up loop counter
	xor		ch,ch

	add		si,di			;Point to menu entry
	mov		dx,Wptr[si]		;Get row/col
	ret
updateItem_	ENDP



COMMENT	%
==============================================================================
Hilites the 1st menu item.

=============================================================================%
menuOn	PROC	NEAR
	call		hideMouseCursor		;Hide mouse cursor
	call		menuInstVars
	xor		di,di			;Hilite zeroth menu item
	reverseVideo	bl			;Get reverse video attr
	call		disMenuItem		;Hilite menu item
	setInst		InxPtr,di,Self		;Set new menu index 
	ret
menuOn	ENDP



IF Dbug
	PUBLIC	flashHilite
ENDIF
COMMENT	%
==============================================================================
Flashes the hilite for the specified menu item.

Passed:	StackTop - New menu index pointer

=============================================================================%
flashHilite	PROC	NEAR
	call		hideMouseCursor		;Hide mouse cursor
	getStackArgs	di			;Get new menu index
	call		flashHilite_
	call		flashHilite_
	ret
flashHilite	ENDP



COMMENT	%
==============================================================================
Turns the hilite off pauses then turns it back on for the specified menu item.

Passed:	di - New menu index pointer

=============================================================================%
flashHilite_	PROC	NEAR
	push		di
	push		di
	call		hiliteOff		;Turn off hilite
	mov		cx,FlashDelay		;Loop counter
flh1:	loop		flh1			;Delay
	call		menuInstVars		;Get instance values
	pop		di
	reverseVideo	bl			;Get reverse video attr
	add		si,di			;Point to menu entry
	call		disMenuItem		;Hilite menu item
	setInst		InxPtr,di,Self		;Set menu index 
	mov		cx,FlashDelay		;Loop counter
flh2:	loop		flh2			;Delay
	pop		di
	ret
flashHilite_	ENDP



	.DATA

defMsg	Menu,\
	Read,\
	<menuOn,,>

defMsg	Menu,\
	Next,\
	<nextMenuItem,,>

defMsg	Menu,\
	Prev,\
	<prevMenuItem,,>

defMsg	Menu,\
	Select,\
	<,,selectItem>

defMsg	Menu,\
	ScrollUp,\
	<,,updateNextItem>

defMsg	Menu,\
	ScrollDown,\
	<,,updatePrevItem>

defMsg	Menu,\
	Hilite,\
	<hiliteOff,,hiliteOn>

defMsg	Menu,\
	DeHilite,\
	<hiliteOff,,>

defMsg	Menu,\
	Flash,\
	<flashHilite,,>

defMsg	Menu,\
	SelectNext,\
	<nextMenuItem,,selectItem>

defMsg	Menu,\
	SelectPrev,\
	<prevMenuItem,,selectItem>

defObj	Menu,\
	<>,\
	<>\
	<Read,Next,Prev,Select,ScrollUp,ScrollDown,Hilite,DeHilite,Flash,\
	SelectNext,SelectPrev>



	END
