 PAGE	81,128
 TITLE	XRSRCH	- Search externals for input name.
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	MEXTN:BYTE,MECNT:WORD
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRSRCH							      |
;==============================================================================
;									      |
; This procedure searches the EXTRN  names stack for a match against the      |
; input	name.  If it finds a match, it returns the pointer associated with    |
; the modulename in the	BX register.  If it does not, it returns with carry   |
; set.									      |
;									      |
; Entry	conventions:	DS:SI points to	a search name (length byte prefix).   |
;			DS:DI points to	current	poisition in external stack   |
;									      |
; Returns:		Match:	no carry, BX points to module name	      |
;			Not found: carry set.				      |
;									      |
;==============================================================================
;
	EXTRN
;
	PUBLIC	XRSRCH
;
XRSRCH	PROC	NEAR
	PUSH	DX
	PUSH	CX
	MOV	AX,DI			;Find poisition	in stack
	SUB	AX,OFFSET MEXTN
	MOV	CX,15
	XOR	DX,DX
	DIV	CX			;Compute count of entries searched
	MOV	CX,MECNT
	SUB	CX,AX			;CX contains number of names remaining
	JCXZ	FAIL
SLP:	CALL	COMP
	JE	HIT
	ADD	DI,15
	LOOP	SLP
FAIL:	STC
	POP	CX
	POP	DX
	RET
HIT:	MOV	BX,WORD	PTR [DI+13]
	POP	CX
	POP	DX
	CLC
	RET
XRSRCH	ENDP
;
COMP	PROC	NEAR
	PUSH	DI
	PUSH	SI
	PUSH	CX
	MOV	CX,13
	REPE	CMPSB
	POP	CX
	POP	SI
	POP	DI
	RET
COMP	ENDP
;
CODE	ENDS
;
	END
