 PAGE	81,128
 TITLE	XRPUBL	- Process PUBDEF record
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	MNCUR:WORD
;
	PUBLIC	MPUBN,MPEND,MPCNT,MPPTR
;
MPUBN	DB	16000 DUP (?)		;Space for 1000	names
MPEND	EQU	$
MPCNT	DW	0
MPPTR	DW	MPUBN
;
ABTMSG	DB	13,10,'Over 1000 public symbols - Terminating$'
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRPUBL							      |
;==============================================================================
;									      |
; This procedure processes the PUBDEF record, adding the public	names it      |
; finds	to the public stack, along with	a pointer to the current module	      |
; and a	type flag (indicating data or code).				      |
;									      |
; Entry	conventions:	DS:SI points to	record				      |
;			CX contains record length			      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN
;
	PUBLIC	XRPUBL
;
XRPUBL	PROC	NEAR
	DEC	CX		;Discard checksum length
LP:	CALL	STKNAM		;Stack public name
	LOOP	LP		;Discard type byte
	RET
XRPUBL	ENDP
;
STKNAM	PROC	NEAR
	PUSH	BX
	MOV	BX,CX
	MOV	DI,MPPTR	;Load address of next stack entry
	INC	SI		;Discard group index
	LODSB			;Load segment index
	SUB	BX,2
	JC	EXIT		;Out of	data
	MOV	CL,BYTE	PTR [SI]
	XOR	CH,CH
	MOV	DX,13
	JCXZ	EXIT
	INC	CX		;Add in	length byte
	SUB	DX,CX
	SUB	BX,CX
	REP	MOVSB		;Move in name
	OR	DX,DX
	JZ	NOPAD
	MOV	CX,DX
	PUSH	AX
	MOV	AL,' '
	REP	STOSB		;Blank pad
	POP	AX
NOPAD:	STOSB			;Save segment index
	MOV	AX,MNCUR	;Get current name pointer
	STOSW
	ADD	MPPTR,16	;Save ptr to next position
	CMP	DI,OFFSET MPEND
	JA	ABORT
	INC	MPCNT		;  and count names in stack
	SUB	BX,3		;Discard the offset and	type length
	JC	EXIT
	MOV	CX,BX
	POP	BX
	RET
EXIT:	MOV	CX,1
	POP	BX
	RET
ABORT:	MOV	DX,OFFSET ABTMSG
	MOV	AH,9
	INT	21H
	MOV	AX,4C02H
	INT	21H
STKNAM	ENDP
;
CODE	ENDS
;
	END
