 PAGE	81,128
 TITLE	XRPOBJ	- Process an OBJ file
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	DTAS:WORD,DTAN:BYTE,FHAN:WORD
;
	PUBLIC	FBUF,RCODE,RLEN,VALID,EMSG,IMSG,IMX
;
FBUF	DB	1024 DUP (?)		;Record	buffer
RCODE	DB	?			;Type record
RLEN	DW	?			;Record	length
;
VALID	DB	7AH,7CH,88H,8EH,94H,96H,98H,9AH,9CH,0A0H,0A2H
;
EMSG	DB	13,10,'Did not find MODEND record for module$'
IMSG	DB	13,10,'Found record type: '
IMX	DB	?,?
	DB	' - Invalid type$'
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRPOBJ							      |
;==============================================================================
;									      |
; This procedure loads and processes an	OBJ file (equivalent to	one object    |
; module).  The	actual processing is performed by subordinate modules, but    |
; this procedure scans the file, and invokes the appropriate subordinate      |
; dependent upon the type of object record found.			      |
;									      |
; Entry	conventions:	Expects	the current file to be opened (FHAN).	      |
;									      |
; Returns:		None.  Will display message if invalid record type    |
;			found.						      |
;									      |
;==============================================================================
;
	EXTRN	XRHEDR:NEAR,XREXTN:NEAR,XRPUBL:NEAR
;
	PUBLIC	XRPOBJ
;
XRPOBJ	PROC	NEAR
LP:	MOV	BX,FHAN			;Load file handle
	MOV	DX,OFFSET RCODE		;Point to header area
	MOV	CX,3
	MOV	AH,3FH
	INT	21H			;Read in record	header
	CMP	AX,CX
	JE	NORM
EXIT:	MOV	DX,OFFSET EMSG
	MOV	AH,9
	INT	21H
	RET				;Out of	data
NORM:	MOV	CX,RLEN			;Get length of data record
	MOV	DX,OFFSET FBUF
	MOV	AH,3FH
	INT	21H			;Read in object	record
	CMP	AX,CX
	JNE	EXIT			;Out of	data
	MOV	SI,OFFSET FBUF		;Point to record
	MOV	CX,RLEN			;  and load record length
	MOV	AL,RCODE		;Get record type code
	CMP	AL,80H
	JNE	T1
	CALL	XRHEDR			;Process THEADR	record
	JMP	LP
T1:	CMP	AL,8AH
	JNE	T2
	RET				;Found MODEND record, so exit
T2:	CMP	AL,8CH
	JNE	T3
	CALL	XREXTN			;Process EXTDEF	record
	JMP	LP
T3:	CMP	AL,90H
	JNE	T4
	CALL	XRPUBL			;Process PUBDEF	record
	JMP	LP
T4:	MOV	DI,OFFSET VALID
	MOV	CX,11
	REPNE	SCASB			;Check for valid code
	JE	LP			;Found one
	XOR	AH,AH
	MOV	CL,4
	SHL	AX,CL
	SHR	AL,CL
	XCHG	AH,AL
	CALL	CVRT
	MOV	IMX,AL
	MOV	AL,AH
	CALL	CVRT
	MOV	IMX+1,AL
	MOV	DX,OFFSET IMSG
	MOV	AH,9
	INT	21H
	JMP	LP
XRPOBJ	ENDP
;
	PUBLIC	CVRT
;
CVRT	PROC	NEAR
	CMP	AL,9
	JBE	COK
	ADD	AL,7
COK:	ADD	AL,'0'
	RET
CVRT	ENDP
;
CODE	ENDS
;
	END
