 PAGE	81,128
 TITLE	XRPLIB	- Process Library file
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	FHAN:WORD,FBUF:BYTE,RCODE:BYTE,RLEN:WORD
	EXTRN	VALID:BYTE,EMSG:BYTE,IMSG:BYTE,IMX:BYTE
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRPLIB							      |
;==============================================================================
;									      |
; This procedure loads and processes ALL of the	object files contained within |
; the library opened by	the caller.  Note that the records that	are processed |
; are actually processed by subordinate	modules, dependent upon	the type of   |
; logical record found.	 Note also that	the "scan" for the start of the	      |
; next object module is	a bit "hokey".					      |
;									      |
; Entry	conventions:	Expects	the library to have been opened	(FHAN).	      |
;									      |
; Returns:		None.  Displays	messages on bad	data.		      |
;									      |
;==============================================================================
;
	EXTRN	XRHEDR:NEAR,XREXTN:NEAR,XRPUBL:NEAR,CVRT:NEAR
;
	PUBLIC	XRPLIB
;
XRPLIB	PROC	NEAR
LP:	MOV	BX,FHAN			;Load file handle
	MOV	CX,1
	MOV	DX,OFFSET RCODE
	MOV	AH,3FH
	INT	21H			;Read next file	character
	CMP	AX,CX
	JNE	EXIT
	CMP	RCODE,0F1H
	JE	DONE
	CMP	RCODE,80H
	JNE	LP			;Scan for start	of module
	MOV	CX,2
	MOV	DX,OFFSET RLEN
	MOV	AH,3FH
	INT	21H			;Read in record	length
	CMP	AX,CX
	JE	JOIN			;Do normal process
EXIT:	MOV	DX,OFFSET EMSG
	MOV	AH,9			;No end	record message
	INT	21H
DONE:	RET
SCND:	MOV	BX,FHAN
	MOV	DX,OFFSET RCODE
	MOV	CX,3
	MOV	AH,3FH
	INT	21H
	CMP	AX,CX
	JNE	EXIT
JOIN:	MOV	CX,RLEN
	MOV	DX,OFFSET FBUF
	MOV	AH,3FH
	CMP	CX,1024
	JBE	OK
	MOV	CX,1024
	INT	21H			;Record	is too long
	MOV	CX,RLEN
	SUB	CX,1024
	MOV	AH,3FH
	INT	21H
	JMP	SCND			;Skip record
OK:	INT	21H			;Load record
	CMP	AX,CX
	JNE	EXIT
	MOV	SI,DX
	MOV	CX,RLEN
	MOV	AL,RCODE
	CMP	AL,80H
	JNE	T1
	CALL	XRHEDR
	JMP	SCND
T1:	CMP	AL,8AH
	JNE	T2
	JMP	LP			;End of	object module
T2:	CMP	AL,8CH
	JNE	T3
	CALL	XREXTN
	JMP	SCND
T3:	CMP	AL,90H
	JNE	T4
	CALL	XRPUBL
	JMP	SCND
T4:	CMP	AL,0F1H
	JNE	T5
	RET				;End of	library
T5:	MOV	DI,OFFSET VALID
	MOV	CX,11
	REPNE	SCASB			;Check for a valid code
	JE	SCND
	XOR	AH,AH
	MOV	CL,4
	SHL	AX,CL
	SHR	AL,CL
	XCHG	AH,AL
	CALL	CVRT
	MOV	IMX,AL
	MOV	AL,AH
	CALL	CVRT
	MOV	IMX+1,AL
	MOV	DX,OFFSET IMSG
	MOV	AH,9
	INT	21H			;Bad record type message
	JMP	SCND
XRPLIB	ENDP
;
CODE	ENDS
;
	END
