 PAGE	81,128
 TITLE	XRMAIN	- Main Entry Point
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
PRMT1	DB	13,10,'Use Library or Object files as input (L/O):  $'
PRMT2	DB	13,10,'Input file mask (*.OBJ):  $'
PRMT3	DB	13,10,'Output to printer or disk (P/D):  $'
PRMT4	DB	13,10,'Enter output file name:  $'
IBUF	DB	64
IBL	DB	?
IBD	DB	63 DUP (?)
DFNAM	DB	'*.OBJ',0
MODE	DB	?
;
	PUBLIC	DTA,DTAA,DTAT,DTAD,DTAS,DTAN,FHAN
;
DTA	DB	21 DUP (?)
DTAA	DB	?
DTAT	DW	?
DTAD	DW	?
DTAS	DW	?,?
DTAN	DB	13 DUP (?)
;
FHAN	DW	?			;Open file handle
;
DATA	ENDS
;
STACK	SEGMENT	PARA STACK 'STACK'
	DB	20 DUP ('STACK')
STACK	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRMAIN							      |
;==============================================================================
;									      |
; This is the main entry point for the cross reference facility, and as	such  |
; performs the initialization for the full facility.			      |
;									      |
; Entry	conventions:	None.						      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN	XRPOBJ:NEAR,XRPLIB:NEAR,XRSORT:NEAR,XRPRNT:NEAR,XRDISK:NEAR
;
	PUBLIC	XRMAIN
;
XRMAIN	PROC	FAR
	PUSH	DS
	XOR	AX,AX
	PUSH	AX
	MOV	AX,DATA
	MOV	DS,AX
	MOV	ES,AX
DOP1:	MOV	DX,OFFSET PRMT1
	MOV	AH,9
	INT	21H
	MOV	AH,1
	INT	21H
	OR	AL,' '
	CMP	AL,'l'
	JE	LIBE
	CMP	AL,'o'
	JNE	DOP1
LIBE:	MOV	MODE,AL
	MOV	DX,OFFSET DTA		;Set DTA to our	memory
	MOV	AH,1AH
	INT	21H
	MOV	DX,OFFSET PRMT2
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET IBUF
	MOV	AH,10
	INT	21H			;Get file mask
	MOV	CL,IBL			;Get length of input string
	XOR	CH,CH
	JCXZ	DEFALT			;Use default mask
	MOV	SI,OFFSET IBD
	MOV	DX,SI
	ADD	SI,CX
	MOV	BYTE PTR [SI],0		;Force name to end with	null
COMN:	XOR	CX,CX
	MOV	AH,4EH
	INT	21H			;Find first
	JNC	PRCES			;Not found
	JMP	EXIT
DEFALT:	MOV	DX,OFFSET DFNAM
	JMP	COMN
SECND:	MOV	AH,4FH
	INT	21H
	JC	DONE			;No more matching files
PRCES:	MOV	DX,OFFSET DTAN		;Point to file name
	MOV	AX,3D00H
	INT	21H			;Open file
	JC	SECND			;Couldn't open
	MOV	FHAN,AX			;Save file handle
	CMP	MODE,'l'		;See if	library	opened
	JNE	OBJECT			;Do object file
	CALL	XRPLIB			;Process library file
	JMP	SECND
OBJECT:	CALL	XRPOBJ			;Process object	deck
	JMP	SECND
DONE:	CALL	XRSORT			;Sort externals
PDRETY:	MOV	DX,OFFSET PRMT3
	MOV	AH,9
	INT	21H
	MOV	AH,1
	INT	21H
	OR	AL,' '
	CMP	AL,'p'
	JE	MPRNT
	CMP	AL,'d'
	JNE	PDRETY
	MOV	DX,OFFSET PRMT4
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET IBUF
	MOV	AH,10
	INT	21H			;Get output file name
	MOV	CL,IBL
	XOR	CH,CH
	MOV	SI,OFFSET IBD
	MOV	DX,SI
	ADD	SI,CX
	MOV	BYTE PTR [SI],0		;Make name end with null
	MOV	AH,3CH
	XOR	CX,CX
	INT	21H			;Create	output file
	MOV	FHAN,AX			;Save handle
	CALL	XRDISK			;Output	array to disk
	JMP	EXIT
MPRNT:	CALL	XRPRNT			;Now print Xref	listing
	MOV	AH,5
	MOV	DL,12
	INT	21H			;Force out last	page
	MOV	DL,27
	INT	21H
	MOV	DL,'@'			;Reset printer
	INT	21H
EXIT:	RET
XRMAIN	ENDP
;
CODE	ENDS
;
	END	XRMAIN
