 PAGE	81,128
 TITLE	XRHEDR	- Process THEADR Record
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	PUBLIC	MNAMES,MNEND,MNCNT,MNPTR,MNCUR
;
MNAMES	DB	9020 DUP (?)		;Space for 1000	eight byte names
MNEND	EQU	$
MNCNT	DW	?
MNPTR	DW	MNAMES
MNCUR	DW	?
;
ABTMSG	DB	13,10,'Over 1000 primary module names - Terminating$'
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRHEDR							      |
;==============================================================================
;									      |
; This module processes	the header record it expects to	find in	the input     |
; buffer.  It extracts the module name and adds	it to the module name	      |
; stack.								      |
;									      |
; Entry	conventions:	DS:SI points to	record				      |
;			CX contains length of record			      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN
;
	PUBLIC	XRHEDR
;
XRHEDR	PROC	NEAR
	MOV	AL,BYTE	PTR [SI]	;Get name length
	XOR	AH,AH
	DEC	CX
	CMP	AX,CX
	JA	OK			;Use record length
	MOV	CX,AX
	INC	CX			;Count length byte
OK:	MOV	DI,MNPTR		;Point to next name stack slot
	MOV	MNCUR,DI		;Save current pointer
	REP	MOVSB			;Move in name (prefixed	by length)
	INC	MNCNT			;Add name count
	MOV	MNPTR,DI		;Save next ptr
	CMP	DI,OFFSET MNEND
	JA	ABORT
	RET
ABORT:	MOV	DX,OFFSET ABTMSG
	MOV	AH,9
	INT	21H
	MOV	AX,4C03H
	INT	21H
XRHEDR	ENDP
;
CODE	ENDS
;
	END
