 PAGE	81,128
 TITLE	XRFILE	- Get file name	for search, and	open file
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	IF1
	INCLUDE	SDA.MAC
	ENDIF
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	.XLIST
	INCLUDE	IOSCB.INC
	.LIST
	PUBLIC	FHAN,FTLEN,FTAB,IOB,FNAM
;
IOB	IOSCB	<>
;
FHAN	DW	?			;File handle
FTLEN	DW	?
FTAB	DB	15000 DUP (?)		;Space for table
FNAM	DB	46 DUP (0)		;Field for the file name
;
ERR1	DB	'File not found',0
ERR2	DB	'Error reading cross reference table',0
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRFILE							      |
;==============================================================================
;									      |
; This module is entered when the user presses F1 on the main display.	      |
; It then accepts the file name	entered	in the appropriate field, and	      |
; opens	the file.  The file table is loaded, and exit is made to the	      |
; calling program.							      |
;									      |
; Entry	conventions:	None.						      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN	$SDA:NEAR
;
	PUBLIC	XRFILE
;
XRFILE	PROC	NEAR
	$FDINP	IOB,1,FNAM
	CMP	IOB.TVL,27
	JNE	GOON
	RET
GOON:	MOV	DI,OFFSET FNAM+45
	MOV	AL,' '
	MOV	CX,46
	STD
	REPE	SCASB			;Reverse scan for non blank
	CLD
	INC	DI
	INC	DI
	XOR	AL,AL
	STOSB				;Set terminating null
	MOV	DX,OFFSET FNAM
	MOV	AX,3D00H		;Open for input
	INT	21H
	JNC	OK1
	$SERRM	IOB,24,ERR1
	JMP	XRFILE
OK1:	MOV	FHAN,AX
	MOV	BX,FHAN
	MOV	DX,OFFSET FTLEN
	MOV	CX,2
	MOV	AH,3FH
	INT	21H			;Read in table length
	MOV	CX,FTLEN
	MOV	DX,OFFSET FTAB
	MOV	AH,3FH
	INT	21H			;Read in control table
	CMP	AX,CX
	JE	OK2
	$SERRM	IOB,24,ERR2
	JMP	XRFILE
OK2:	MOV	DL,2
CLR:	MOV	IOB.FLD,DL
	$FDCLR	IOB
	INC	DL
	CMP	DL,63
	JBE	CLR
	RET
XRFILE	ENDP
;
CODE	ENDS
;
	END
