 PAGE	81,128
 TITLE	XRDISP	- Display module for review of Cross Ref file
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	IF1
	INCLUDE	SDA.MAC
	ENDIF
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	XRDSCR:BYTE,FNAM:BYTE
;
	PUBLIC	STAB
	.XLIST
	INCLUDE	SCTAB.INC
	.LIST
STAB	SCTAB	<,1,1,FLDTAB>
FLDTAB	DB	1,1
	DW	FNAM
;
FKY1	DB	'FILE',0,'PUBLIC',0,0,0,0,0,0,0,0,'EXIT',0
	DW	0
;
WTG	DB	59,60,68
WTGA	DW	XRFILE,XRNAME,EXIT
;
DATA	ENDS
;
STACK	SEGMENT	PARA STACK 'STACK'
	DB	20 DUP ('STACK')
STACK	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRDISP							      |
;==============================================================================
;									      |
; This is the main module for the display of the cross reference file.	As    |
; such it provides the main control for	the subordinate	modules	used in	      |
; performing the actual	data display.					      |
;									      |
; Entry	conventions:	None.						      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN	XRFILE:NEAR,XRNAME:NEAR
;
	PUBLIC	XRDISP
;
XRDISP	PROC	FAR
	PUSH	DS
	XOR	AX,AX
	PUSH	AX
	MOV	AX,DATA
	MOV	DS,AX
	MOV	ES,AX
	$FDDTS	ON			;Turn time tick
RBLD:	$SDISPX	XRDSCR			;Put up	screen
	$SFUNK	STAB,25,FKY1
RFRSH:	$SERRM	STAB,0,0
	$DISPLY	STAB,0,0,,0
	TEST	STAB.TFL,1
	JZ	RFRSH
	MOV	AL,STAB.TVL
	XOR	BX,BX
	MOV	CX,3
CLP:	CMP	AL,WTG[BX]
	JE	HIT
	INC	BX
	LOOP	CLP
	JMP	RFRSH
HIT:	SHL	BX,1
	CALL	WTGA[BX]
	JMP	RFRSH
;
EXIT:	POP	AX			;Discard level
	$FDDTS	OFF			;Turn off tick
	$SCATR	7			;Restore normal	attribute
	$SCCLR	FULL			;Clear the screen
	$SCURA	ON,LINE			;and restore cursor
	RET
XRDISP	ENDP
;
CODE	ENDS
;
	END	XRDISP
