 PAGE	81,128
 TITLE	XRNAME	- Get Module name for search and complete search
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	IF1
	INCLUDE	SDA.MAC
	ENDIF
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	IOB:WORD,FTLEN:WORD,FTAB:BYTE,FHAN:WORD
	.XLIST
	INCLUDE	IOSCB.INC
	.LIST
;
SNAME	DB	?
MNAME	DB	12 DUP (?)
WORK	DB	20 DUP (?)
;
ERR1	DB	'Public name not found - Try again - Esc to exit',0
ERR2	DB	'Seek failure - Returning to main menu',0
ERR3	DB	'***MORE*** Press "ENTER" to continue',0
ERR4	DB	'                                     ',0
;
IBUF	DB	3000 DUP (?)	;Read buffer
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XRNAME							      |
;==============================================================================
;									      |
;  This	procedure solicits the module name for the search, and having got     |
;  a name, it then completes the search	display.  Control is returned to      |
;  the caller after search is completed.  Note that an invalid name will      |
;  cause an error message, and the module will then wait for a proper name    |
;  to be entered.							      |
;									      |
; Entry	conventions:	None.						      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN
;
	PUBLIC	XRNAME
;
XRNAME	PROC	NEAR
	MOV	IOB.FLD,3
	CALL	CLEAR
	$FDINP	IOB,2,MNAME
	CMP	IOB.TVL,27
	JNE	GOON
	RET
GOON:	MOV	CX,12
	MOV	DI,OFFSET MNAME
	MOV	AL,' '
	REPNE	SCASB			;Scan for trailing blank
	DEC	DI
	SUB	DI,OFFSET MNAME		;Compute length	of name
	MOV	AX,DI
	MOV	SNAME,AL		;  and save as prefix
	MOV	SI,OFFSET FTAB
	MOV	DX,FTLEN
	ADD	DX,SI
SLP:	CALL	COMP			;Compare search	name against directory
	JE	HIT
	ADD	SI,16
	CMP	SI,DX
	JB	SLP
	$SERRM	IOB,24,ERR1
	JMP	XRNAME
HIT:	MOV	DX,WORD	PTR [SI+14]
	XOR	CX,CX
	MOV	BX,FHAN
	MOV	AX,4200H
	INT	21H			;Seek to entry in file
	JNC	OK1
	$SERRM	IOB,24,ERR2
	RET
OK1:	MOV	DX,OFFSET IBUF
	MOV	AH,3FH
	MOV	CX,3000
	INT	21H			;Read block (max = 3000)
	MOV	SI,OFFSET IBUF
	MOV	IOB.FLD,3
DLP:	CALL	MOVE
	JC	EXIT
	INC	IOB.FLD
	CMP	IOB.FLD,63
	JBE	DLP
	$SERRM	IOB,24,ERR3
	$FDOUT	IOB,,WORK
	$FDOIN	IOB,63,WORK
	MOV	IOB.FLD,4
	CALL	CLEAR
	MOV	IOB.FLD,4
	JMP	DLP
EXIT:	RET
XRNAME	ENDP
;
COMP	PROC	NEAR
	PUSH	SI
	MOV	DI,OFFSET SNAME
	MOV	CL,SNAME
	XOR	CH,CH
	REPE	CMPSB
	POP	SI
	RET
COMP	ENDP
;
MOVE	PROC	NEAR
	MOV	CL,BYTE	PTR [SI]
	XOR	CH,CH
	CMP	CL,0FFH
	JNE	MOK
	STC
	RET
MOK:	MOV	DI,OFFSET WORK
	INC	SI
	REP	MOVSB
	XOR	AL,AL
	STOSB
	PUSH	SI
	$FDOUT	IOB,,WORK
	POP	SI
	CLC
	RET
MOVE	ENDP
;
CLEAR	PROC	NEAR
CLRLP:	$FDCLR	IOB
	INC	IOB.FLD
	CMP	IOB.FLD,63
	JBE	CLRLP
	RET
CLEAR	ENDP
;
CODE	ENDS
;
	END
