 PAGE	81,128
 TITLE	XREXTN	- Process External References
 SUBTTL	V1.0 - May 1986	- Cross	Reference Facility
;
;=============================================================================|
;	     Copyright 1986 - Dan Daetwyler - Springdale, AR 72764	      |
;=============================================================================|
	.SALL
;
DATA	SEGMENT	BYTE PUBLIC 'DATA'
;
	EXTRN	MNCUR:WORD
;
	PUBLIC	MEXTN,MEEND,MECNT,MEPTR
;
MEXTN	DB	30050 DUP (?)		;Space for 2000	12 byte	names +	ptrs
MEEND	EQU	$
MECNT	DW	?
MEPTR	DW	MEXTN
;
ABTMSG	DB	13,10,'Over 2000 externals - Stack overflow - Terminating$'
;
DATA	ENDS
;
CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:DATA,ES:DATA
;
;==============================================================================
; Entry	Point	XREXTN							      |
;==============================================================================
;									      |
; This procedure processes the EXTDEF record, and extracts all external	      |
; reference names.  It also associates the names with a	pointer	to the	      |
; module name stack for	the module currently active.			      |
;									      |
; Entry	conventions:	DS:SI points to	the record			      |
;			CX contains the	record length			      |
;									      |
; Returns:		None.						      |
;									      |
;==============================================================================
;
	EXTRN
;
	PUBLIC	XREXTN
;
XREXTN	PROC	NEAR
	DEC	CX			;Discard checksum length
LP:	CALL	STKNAM			;Put name in stack
	LOOP	LP			;Discard type index count
	RET
XREXTN	ENDP
;
STKNAM	PROC	NEAR
	PUSH	BX
	MOV	BX,CX
	MOV	DX,13
	MOV	CL,BYTE	PTR [SI]	;Get name length
	MOV	DI,MEPTR		;Point to next stack entry
	XOR	CH,CH
	JCXZ	EXIT
	INC	CX			;Count length byte
	SUB	BX,CX
	SUB	DX,CX
	REP	MOVSB			;Move in name with length prefix
	OR	DX,DX
	JZ	NOPAD
	MOV	CX,DX
	MOV	AL,' '			;Pad name to 12	bytes
	REP	STOSB
NOPAD:	MOV	AX,MNCUR		;Get current module name ptr
	STOSW				;  and save in stack
	MOV	MEPTR,DI
	CMP	DI,OFFSET MEEND
	JA	ABORT
	INC	MECNT			;Count names in	stack
	MOV	CX,BX
	INC	SI			;Step over type	byte
	POP	BX
	RET
EXIT:	MOV	CX,1
	POP	BX
	RET
ABORT:	MOV	DX,OFFSET ABTMSG
	MOV	AH,9
	INT	21H
	MOV	AX,4C01H
	INT	21H			;Terminate
STKNAM	ENDP
;
CODE	ENDS
;
	END
