        DEFINT A-Z
        DECLARE FUNCTION NuVal& (k$)
        DECLARE FUNCTION Empty& (k$)

'   This program demonstrates the speed increase possible with NuVal.
'   Run it like this: "QB /Lnuval nvtest".  The program asks you to enter
'   a maximum exponent... this is the highest power of two which will be
'   used in the current test run.  If you enter nothing, the test ends.
'   The program also verifies that NuVal returns the same values as VAL.
'
'   Because this test creates a lot of strings, the results can be skewed
'   by unpredictable garbage collection... if you really care, do 10 runs
'   with any exponent, discard the highest and lowest runs, and average
'   the remaining ones.  Notice that NuVal's advantage is greatest with
'   smaller values, since it has less overhead.
'
'   To test the function interactively, run the program "Testnvi"

        CLS
        RANDOMIZE TIMER
        DO
           LINE INPUT "Enter maximum exponent (4 to 31) for testing: "; p$
           IF LEN(p$) = 0 THEN
              CLS
              SYSTEM
           END IF
           ex = NuVal(p$)
           IF (ex > 3) AND (ex < 32) THEN
              EXIT DO
           END IF
        LOOP

        PRINT "Generating 500 random numeric strings...";
        DIM ary$(500)
        FOR k = 1 TO 500
           m& = RND * 2 ^ ex
           IF k MOD 2 THEN
              m& = -m&
           END IF
           ary$(k) = STR$(m&)
        NEXT
        PRINT " Done"

        PRINT "Checking validity of function...";
        FOR k = 1 TO 500
           p$ = ary$(k)
           IF NuVal(p$) <> VAL(p$) THEN
              BEEP
              PRINT
              PRINT "NuVal failed with "; p$
              STOP
           END IF
        NEXT
        PRINT " Ok"
        m& = FRE("")

        PRINT "Timing shell loop...";
        t! = TIMER
        FOR k = 1 TO 500
          p$ = ary$(k)
          m& = Empty(p$)
        NEXT
        e! = TIMER - t!
        PRINT e!
        m& = FRE("")

        PRINT "Timing VAL...";
        t! = TIMER
        FOR k = 1 TO 500
          p$ = ary$(k)
          m& = VAL(p$)
        NEXT
        ol! = TIMER - t! - e!
        PRINT ol!
        m& = FRE("")

        PRINT "Timing NuVal...";
        t! = TIMER
        FOR k = 1 TO 500
          p$ = ary$(k)
          m& = NuVal(p$)
        NEXT
        nu! = TIMER - t! - e!
        PRINT nu!

        PRINT
        PRINT "NuVal was"; ol! / nu!; "times faster than VAL with this data"
        PRINT
        PRINT "Press 'Enter' to try again, 'space' to view data, any other key to quit";
        DO
           k$ = INKEY$
        LOOP UNTIL LEN(k$)
        IF UCASE$(k$) = " " THEN
            CLS
            FOR k = 1 TO 500
               PRINT ary$(k),
            NEXT
            PRINT
            PRINT "Any key..."
            k$ = INPUT$(1)
        ELSEIF k$ <> CHR$(13) THEN
           CLS
           SYSTEM
        END IF
        RUN

