; Program:  NETDRIVE
; Purpose:  Used to find the first network drive that contains a directory
;           called \LOGIN, then switches to that drive and directory and
;           saves the current drive letter into a DOS environment variable
;           named NETDRV.
; Author:   Dave Holden
; Date:     06-19-90
; Version:  1.1  06-19-91  Now checks for network drive up to drive Z:.  Used
;                          to stop looking at drive P:.

CODE      SEGMENT
          ASSUME CS:CODE, DS:CODE, ES:CODE
          ORG     100h
          INCLUDE DOS.INC
BEG:      JMP     START

STRING    DB      8 DUP (0)
DRV       DB      "NETDRV="        ; Variable name
LDRV      EQU     $-drv
DRVCTR    DB      00                      ; Drive counter variable
OLDDRV    DB      00                      ; Variable to save beginning drive
PATH      DB      '\LOGIN',00             ; Login path (ASCIIZ string)
ERR1      DB      "Invalid command",7,13,10,"$"
ERR2      DB      "Out of environment space",7,13,10,"$"
ERR3      DB      "Must have DOS Version 2.0 or higher",7,13,10,"$"
NONET     DB      07h,0Dh,'Network shell not loaded!',0Dh,0Ah,24h

START:    MOV     AH,19h                  ; Get Current Drive function
          INT     21h                     ; Returns drive number in AL
          MOV     byte ptr CS:OLDDRV,AL   ; Save current drive

          MOV     AH,0DBh                 ; Get # of Logical Drives (Novell)
          INT     21h
          CMP     AL,00                   ; If AL=0 then shell not loaded,
          JE      NETERR                  ; jump to NETERR
          MOV     byte ptr CS:DRVCTR,AL   ; Otherwise, save logical drv count

CHGDR:    MOV     AH,0Eh                  ; Set Drive function
          MOV     DL,byte ptr CS:DRVCTR      ; Move next drive (to try) into DL
          INT     21h

          MOV     AX,CS                   ; Move Segment Address of PATH (CS)
          MOV     DS,AX                   ;  into Data Segment (DS)
          MOV     AH,3Bh                  ; Change Current Directory function
          MOV     DX,offset CS:PATH       ; Set DX to offset of PATH
          INT     21h

          JNC     SHELLOK                 ; Change Dir worked if Carry Flag=0
          ADD     byte ptr CS:DRVCTR,1    ; Otherwise, inc Drive counter
          CMP     byte ptr CS:DRVCTR,19h  ; If drive number is too high,
          JG      RESTDR                  ;  restore drive and stop.
          CLC
          JMP     CHGDR                   ; If drive number is okay then try
                                          ;  again.
RESTDR:   MOV     AH,0Eh                  ; Set Drive function
          MOV     DL,byte ptr CS:OLDDRV   ; Move previously saved drive to DL
          INT     21h                     ; Restore drive
          MOV     AH,4Ch                  ; Terminate function
          MOV     AL,01h                  ; Set ERRORLEVEL to 1  (no net drive)
          INT     21h

NETERR:   MOV     AX,CS                   ; Move Segment Address of PATH (CS)
          MOV     DS,AX                   ; into Data Segment (DS)
          MOV     AH,09h                  ; Print String function
          MOV     DX,offset CS:NONET      ; Set DX to offset of NONET string
          INT     21h
          MOV     AH,4Ch                  ; Terminate function
          MOV     AL,02h                  ; Set ERRORLEVEL to 2  (no shell)
          INT     21h

SHELLOK:  mov     ax,cs                 ; Starting execution address
	  mov	  ds,ax			; Initialize data segment

DOSOK:    call    GetDrv                ; Call the GetDrv procedure
          push    ax                    ; Save
	  push	  es
	  call	  DoEnviron		; Put result in	environment string
	  or	  ax,ax			; Test for 0 before
	  pop	  es			;   restore
	  pop	  ax
          jz      DONE

	  cmp	  BYTE PTR es:[5Dh],'E'	; Is it	Environment command
          je      DONE                  ; Yes? Skip message

ERROR2:   @DispStr err2                 ; Error message

DONE:     @Exit   0                     ; Quit with AL as return code

; Procedure Getdrv
; Purpose   Get	the current directory or drive
; Input	    None
; Output    Current directory or drive in "string"; level or drive number in AX

Getdrv    PROC    NEAR
	  @GetDrv			; Yes? Get drive
	  mov	  ah,al			; Copy
	  add	  ah,'A'		; Convert to drive letter
	  mov	  string,ah		; Put character	in string
          mov     string[1],':'
	  cbw
	  ret
Getdrv    ENDP

; Procedure DoEnviron
; Purpose   Convert a string to	an environment variable
; Input	    String in "string"
; Output    String in "WHAT" environment variable;
;	      AX has 0 for success, nonzero for	failure

DoEnviron PROC
	  call	  GetEnv		; Get environment size,	length,	address
	  mov	  dx,ax			; Save size and	length
	  mov	  bx,cx

; Find "NETDRV="

	  sub	  di,di			; Point	to start
	  sub	  al,al			; Search for zero
          mov     si, OFFSET drv        ; Point source at "NETDRV="
findwh:	  repne	  scasb			; Search
	  cmp	  BYTE PTR es:[di],0	; If double null, end of environment
	  je	  gotend
	  jcxz	  noroom		; Error	if not found
	  push	  di			; Save
	  push	  cx
          mov     si,OFFSET drv         ; Load address and length of "NETDRV"
          mov     cx,ldrv               ;   for comparison
	  repe	  cmpsb			; Compare
	  mov	  si,di			; Make copy
	  pop	  cx			; Restore
	  pop	  di
	  jnz	  findwh

; Find end of "NETDRV" variable

	  xchg	  di,si
	  repne	  scasb			; Find end of environment variable
	  xchg	  si,di			; Point	source to next variable

; Calculate characters left to write

	  mov	  cx,bx			; Load total characters
	  sub	  cx,si			; Subtract finished to get left

; Move everything back to overwrite "NETDRV="

movenv:	  push	  ds			; Save DS
	  mov	  ax,es			; Copy to ES
	  mov	  ds,ax
	  rep	  movsb			; Copy
	  mov	  BYTE PTR es:[di],0	; Put null at end in case of error
	  pop	  ds			; Restore

; Check	environment space

gotend:   mov     al,2                  ; Load length of string
	  sub	  ah,ah			; Clear	top
          add     ax,ldrv               ; Add length of name
	  add	  ax,di			; Add position to get final length
	  cmp	  ax,dx			; Is it	longer than environment?
	  jge	  noroom		; Yes? Quit

; Put netdrv= at end

          mov     si,OFFSET drv        ; Load address and length of drv
          mov     cx,ldrv
	  rep	  movsb

; Put new string at end

	  mov	  si,OFFSET string	; Load address and length of string
          mov     cl,2
	  rep	  movsb
	  mov	  WORD PTR es:[di],0	; Put double null at end
	  sub	  ax,ax			; Return 0 for success
	  ret

noroom:	  inc	  ax			; Return nonzero for fail
	  ret
DoEnviron ENDP

; Procedure GetEnv
; Purpose   Find and measure the environment
; Input	    None
; Output    Segment of environment in ES, size in AX, length in	CX

GetEnv	  PROC
	  mov	  dx,es:10h		; Load segment of COMMAND.COM
	  mov	  es,dx			;   into ES
	  mov	  ax,es:2Ch		; Load COMMAND.COM's environment
	  or	  ax,ax			; Is it	0?
	  jnz	  secondry		; No? This is a	secondary command
					;   and	we have	its environment	in AX
	  dec	  dx			; Yes? This is original	COMMAND.COM
	  mov	  es,dx			;   so point ES	to paragraph before PSP
	  add	  dx,es:03		; Offset of environment	is 3 bytes in
	  add	  dx,2			; Adjust it back to PSP
	  mov	  ax,dx			; Put it in AX

secondry: mov     si,ax                 ; Save a copy
	  sub	  dx,dx			; Clear	DX for multiply
	  dec	  ax			; Get paragaraph before	environment
	  mov	  es,ax			; Load into DS
	  mov	  ax,es:03		; Size in paragraphs is	at byte	4
	  mov	  cx,16			; Multiply by 16
	  mul	  cx
	  mov	  es,si			; Restore environment address
	  sub	  di,di			; Point	to start
	  mov	  cx,ax			; Load maximum count (size of
	  mov	  bx,ax			;   environment) and save a copy
	  sub	  ax,ax			; Search for double null
null2:	  repne	  scasb			; Look for null
	  jz	  noerr			; If not out of	space, continue
	  sub	  ax,ax			;   else error (return 0)
	  jmp	  error2
noerr:	  cmp	  BYTE PTR es:[di],0	; Is it	double null?
	  jne	  null2			; No? Look again
	  mov	  cx,di			; Yes? Save length in CX
	  mov	  ax,bx			; Reload size to AX

	  ret
GetEnv	  ENDP
CODE      ENDS
          END     BEG                   ; End assembly

