	page	,132
	title	Batch file Beep

;------------------------------------------------------------------------
;
;  Beep      -	Bill Gibson - 1987
;		Lathrup Village, Mi 48076
;
; * Ver. 1.01 -  sound using ASCII character 7		    -	02/26/87
;	 1.02 -  using the 8253 timer chip directly	    -	02/26/87
;
;  For Public Domain Use.  Not for Sale or Hire.
;------------------------------------------------------------------------
COMMENT *
	   As requested by Viggo Jensen.

   Beep utility - sounds alarm until any key is pressed.

		  Obviously, best use of this small utility is at
		  the end of a batch file.  Could be used to replace
		  the DOS "pause" command.
*
;------------------------------------------------------------------------
code		SEGMENT BYTE PUBLIC 'code'
ASSUME		CS:code,DS:code,SS:code

		ORG	100h

Beep		PROC	FAR

		CALL	Sound		;beep the horn
exit:
		MOV	AH,4Ch
		INT	21h

;------------------------------------------------------------------------
; Work Area - constants,equates,messages
;------------------------------------------------------------------------
cr		EQU	0Dh		;carriage return
lf		EQU	0Ah		;line feed
esc		EQU	01Bh		;escape char

msg1		DB	cr,lf,'Beeping - press any key to quit...','$'

;--------------------------------------------------------------------------
; Sub-Routines: Declare each Proc PUBLIC for use with MapSym & SymDeb v4.0
;--------------------------------------------------------------------------
		PUBLIC	Sound
Sound		PROC	NEAR
		MOV	DX,OFFSET msg1
		MOV	AH,9
		INT	21h
s1:
		MOV	DL,7		;sound the horn
		MOV	AH,2
		INT	21h
		MOV	AH,0Bh		;check standard input device
		INT	21h
		OR	AL,AL		;any character waiting ?
		JZ	s1
		RET
Sound		ENDP

Beep		ENDP
code		ENDS
		END	Beep
