;---------------------------------------; 
; ZCUT.ASM Macro assembler source code.	; 
;---------------------------------------; 
	CODE	SEGMENT			; 
	ASSUME	CS:CODE,SS:CODE		; 
	ASSUME	DS:CODE,ES:CODE		; 
	ORG	100H			; ".COM" files originate at 100 Hex.
;---------------------------------------; 
; DOS loads program then gives control to below line START at offset 100H.
;---------------------------------------;
START:	JMP	BEGIN			; Jump over DONE_flag to BEGIN action.
;---------------------------------------;
DONE_flag	DB	0		; Done with ZCUT?  0 = No.  1 = Yes.
;---------------------------------------;
; Begin ZCUT action on below line.	;
;---------------------------------------;
BEGIN:	CALL	DISPLAY_copyright	; Show user copyright message.
	CALL	OPEN_filename		; Must open [filename].
	CALL	DISPLAY_processing	; Show user processing [filename].
MORE:	CALL	READ_filename		; Read some of [filename] into memory.
	CALL	DO_zcut_file		; Do one Z01 to Z99 file.
	CMP	DONE_flag,0		; Do all of [filename] yet?
	JE	MORE			; No.  Jump to do MORE.
	CALL	CLOSE_filename		; Yes. Close [filename].
	CALL	DISPLAY_processing_done	; Show user processing completed.
	MOV	AL,00			; Tell batch file no errors.
	MOV	AH,4CH			; Terminate program DOS function.
	INT	21H			; Call DOS functions.
;---------------------------------------;
; End ZCUT action on above line.	;
;---------------------------------------;
; Copyright message memory storage.	;
;---------------------------------------;
COPYRIGHT_MSG:				;
DB'ZCUT  Version 1.10.29 1987 (C) E R Garapic Brook Park OH.',13,10
DB'Comes AS-IS with no warranty.  May be freely distributed.',13,10,13,10,'$'
;---------------------------------------;
; Display copyright message		;
;---------------------------------------;
DISPLAY_copyright:			;
	LEA	DX,COPYRIGHT_MSG	; Point to message.
	MOV	AH,9			; Display string function.
	INT	21H			; Call DOS functions.
	RET				; Return to caller.
;---------------------------------------;
; Open [filename]			;
;---------------------------------------;
OPEN_filename:				;
	MOV	DI,80H			;
	MOV	BL,[DI]			; Get [filename] byte count.
	MOV	BH,0			;
	MOV	byte ptr [BX+DI+1],0	; Make [filename] ASCIIZero string.
NEXT_BYTE:				;
	INC	DI			;
  	CMP	byte ptr [DI],' '	; Space before [filename]?
	JZ	NEXT_BYTE		; Yes.  Increment pointer past space.
        MOV     filename_PTR,DI		; Save pointer to [filename] ASCIIZ.
	MOV	DX,DI			; Point DX to [filename] ASCIIZ.
	MOV	AX,3D00H		; Open file DOS function.
	INT	21H			; Call DOS functions.
	JNC	OVER1			; Jump over if no error.
	JMP	ERROR_EXIT		; Jump file access error.
OVER1:	MOV	filename_HANDLE,AX	; Store [filename] handle for later.
	RET				;
;---------------------------------------;
; [filename] handle memory storage	;
;---------------------------------------;
filename_HANDLE	DW	0000H		; [filename] handle storage.
;---------------------------------------;
; Processing  message memory storage.	;
;---------------------------------------;
PROCESSING_MSG:				;
DB 'ZCUT is processing  $'		;
;---------------------------------------;
; Display processing [filename]		;
;---------------------------------------;
DISPLAY_processing:			;
	LEA	DX,PROCESSING_MSG	; Point to message.
	MOV	AH,9			; Display string function.
	INT	21H			; Call DOS functions.
	CALL	DISPLAY_filename	; Displays [filename].
	RET				; Return to caller.
;---------------------------------------;
filename_PTR	dw ?			; Address of first byte of [filename].
;---------------------------------------;
; Display [filename]			; 
;---------------------------------------;
DISPLAY_filename:			; Display [filename]
	MOV	BX,filename_PTR		; Point to first [filename] character.
        CALL	DISPLAY_NAME		;
	MOV	CX,2			; Carriage Return, Line Feed count.
	CALL	CRLF			;
	RET				; Return to caller.
;---------------------------------------;
; Count of bytes read memory storage.	;
;---------------------------------------;
BYTES_READ	DW	0		; Actual bytes read from [filename].
AMOUNT		EQU	40000		; Try for 40,000 bytes per read.
;---------------------------------------;
; Read file [filename].			;
;---------------------------------------;
READ_filename:				; 
	MOV	AH,3FH			; AH = Read file function.
	MOV	BX,filename_HANDLE	; BX = File handle.
	MOV	CX,AMOUNT		; CX = 40,000 bytes.
	LEA	DX,BUFFER		; DX = Buffer address.
	INT	21H			; Call DOS functions.
	JNC	OVER2			; Jump over if no error.
	JMP	ERROR_EXIT		; Jump file access error.
OVER2:					;
	MOV	BYTES_READ,AX		; Store amount of bytes read.
	CMP	AX,AMOUNT		;
	JE	MORE1			; Jump if equals AMOUNT.
	MOV	DONE_flag,1		; Flag = 1 is last block read.
MORE1:					;		
	CMP	DONE_flag,1		; Last block read?
	JE	NO_TOUCH_UP		; Yes. Do NO_TOUCH_UP on last block.
	CALL	TOUCH_UP		; Read more bytes til end of line.
NO_TOUCH_UP:				;
	RET				; Return to caller.
;---------------------------------------;
BUFFER_END_POINTER DW BUFFER 		; Point to file memory buffer.
;---------------------------------------;
; Computes end of line before cutting.	;
;---------------------------------------;
TOUCH_UP:				;
	ADD 	BUFFER_END_POINTER,AX	; Set pointer.
TOUCH1:					;
	MOV	AH,3FH			; AH = Read file function.
	MOV	BX,filename_HANDLE	; BX = [filename] handle
	MOV	CX,1			; Read one byte of [filename].
	MOV	DX,BUFFER_END_POINTER	; DX = current [filename] buffer ptr.
	INT	21H			; Call DOS functions.
	JNC	OVER3			; Jump if no error.
	JMP	ERROR_EXIT		; Jump file access error.
OVER3:					;
	MOV	SI,BUFFER_END_POINTER	; SI points to last byte read.
	INC	BUFFER_END_POINTER	; Point to next buffer location.
	INC	BYTES_READ		; Increment bytes read count.
	MOV	AL,[SI]			; Get last byte read.
	CMP	AL,10			; LineFeed?
	JE	WE_DONE			; Jump if yes.
	JMP	TOUCH1			; Jump to read another byte.
WE_DONE:				;
	MOV	BUFFER_END_POINTER,offset BUFFER   ; Reset pointer.
	RET				; Return to caller.
;---------------------------------------;
; Do one Z01 thru Z99 file.		;
;---------------------------------------;
DO_zcut_file:				;
	CALL	ZCUT_AUTO_NAME		; Auto name ZCUT filename.
	MOV	AH,3CH			; AH = Create file function.
	MOV	CX,0000H		; CX = Normal file.
	LEA	DX,ZCUT_NAME_BUFFER	; DX = ZCUT filename buffer.
	INT	21H			; Call DOS functions.
	JNC	OVER4			; Jump over if no error.
	JMP	ERROR_EXIT		; Jump file access error.
OVER4:					;
	MOV	ZCUT_HANDLE,AX		; Save ZCUT_HANDLE
	MOV	AH,40H			; AH = Write to file function.
	MOV     BX,ZCUT_HANDLE		; BX = ZCUT_HANDLE
        MOV     CX,BYTES_READ		; CX = About 40,000 bytes.
	LEA	DX, BUFFER		; DX = Pointer to buffer.
	INT	21H			; Call DOS functions.
	JNC	OVER5			; Jump over if no erroe.
	JMP	ERROR_EXIT		; Jump file access error.
OVER5:					;
	MOV	AH,3EH			; AX = Close file function.
	MOV	BX,ZCUT_HANDLE		; BX = ZCUT_HANDLE
	INT	21H			; Call DOS functions.
	JNC	OVER6			; Jump if no error.
	JMP	ERROR_EXIT		; Jump file access error.
OVER6:					;
	RET				; Return to caller.
;---------------------------------------;
; Storage used by DO_zcut_file routine.	;
;---------------------------------------;
ZCUT_NAME_BUFFER	DB 80H DUP(?)	; Auto name buffer. Z01 to Z99.
BIN_NUM		DB	1		; Auto name binary buffer.
ZCUT_HANDLE	DW	0000H		; ZCUT file handle.
;---------------------------------------;
; Prepare filename Z01 to Z99 for file creation and also display it to screen.
;---------------------------------------;
ZCUT_AUTO_NAME:				; 
	MOV	SI,filename_PTR		; Point to [filename].
	LEA	DI,ZCUT_NAME_BUFFER	; Point to auto filename buffer.
ZMORE:					; 
	MOV	AL,[SI]			; Get one character from [filename]
	CMP	AL,'.'			; Period?
	JE	BUILD_EXTENSION		; Jump if yes.
	CMP	AL,00H			; Zero?
	JE	BUILD_EXTENSION		; Jump if yes.
	MOV	[DI],AL			; Put byte in auto name buffer.
	INC	DI			; Bump auto name buffer ptr.
	INC	SI			; Bump [filename] buffer ptr.
	JMP	ZMORE			; Jump ------------------> ZMORE:
BUILD_EXTENSION:			;
	MOV	AL,'.'			; Period part of extension.
	MOV	[DI],AL			; Place it.
	INC	DI			;
	MOV	AL,'Z'			; Z part of extension.
	MOV	[DI],AL			; Place it.
	INC	DI			;
	CMP	BYTE PTR BIN_NUM,99	; Is it .Z99 yet?
	JNE	AUTO_NUMBER_EXT		; No.  Jump over reset.
	MOV	BYTE PTR BIN_NUM,1	; Yes. Reset to .Z01 extension.
AUTO_NUMBER_EXT:			; Now auto number the extension.
	MOV	AL,BIN_NUM		; Get BIN_NUM in AL
	CALL	BIN2ASC			; Convert binary to ASCII & place it.
	MOV	AL,0			; Get zero for ASCIIZ string.
	MOV	[DI],AL			; Place it. For filename ASCIIZ string.
	INC	BIN_NUM			; Increment for next name. Z01-Z99.
	CALL	DISPLAY_ZCUT_FILENAME	; Show user the ZCUT filename.
	RET				; Return to caller.
;---------------------------------------;
; Convert binary number to ASCII and place the result.
;---------------------------------------;
BIN2ASC:				; DI points to destination on entry.
	AAM				; Convert AL binary to BCD value in AX.
	ADD	AX,3030H		; BCD to ASCII.
	XCHG	AH,AL			; Get SECOND digit in AL.
	MOV	[DI],AL			; Place it.
	INC	DI			;
	XCHG	AH,AL			; Get FIRST digit in AL.
	MOV	[DI],AL			; Place it.
	INC	DI			; 
	RET				; Return to caller.
;---------------------------------------;
; Display one ZCUT filename.		;
;---------------------------------------;
DISPLAY_ZCUT_FILENAME:			;
	LEA	BX,ZCUT_NAME_BUFFER	; Point to ZCUT filename.
        CALL	DISPLAY_NAME		;
	MOV	CX,1			; Carriage Return, Line Feed count.
	CALL	CRLF			;
	RET				;
;---------------------------------------;
; Display [filename] or ZCUT file name	;
;---------------------------------------;
DISPLAY_NAME:				;
	MOV	DL,[BX]			; Get one [filename] character.
	CMP	DL,' '			; Space?
	JE	ZOUT			; Jump if yes.
	CMP	DL,0			; Zero?
	JE	ZOUT			; Jump if yes.
	CMP	DL,'a'			; Lower case keyed in by user?
	JB	IS_UPPER_CASE   	; Jump if no.
	CMP	DL,'z'			; Lower case keyed in by user?
	JA	IS_UPPER_CASE		; Jump if no.
	AND	DL,5FH			; Yes.  Then convert to upper case.
IS_UPPER_CASE:				; 
	MOV	AH,02H			; Display one character function.
	INT	21H			; Call DOS functions.
	INC	BX			; Point to next [filename] character.
	JMP	DISPLAY_NAME		; Jump to get another character.
ZOUT:	RET				; Return to caller.
;---------------------------------------;
; Carriage Return(s), Line feed(s).	; On entry CX equals count.
;---------------------------------------;
CRLF:					;
	MOV	DL,13			; Carriage Return.
	MOV	AH,02H			; Display character function.
	INT	21H			; Call DOS functions.
	MOV	DL,10			; Line Feed.
	MOV	AH,02H			; Display character function.
	INT	21H			; Call DOS functions.
	LOOP    CRLF			; Loop until CX is zero.
        RET				;
;---------------------------------------;
; Close [filename]			;
;---------------------------------------;
CLOSE_filename:				;
	MOV	AH,3EH			; Close file function.
	MOV	BX,filename_HANDLE	;
	INT	21H			; Call DOS functions.
	JNC	OVER7			; Jump over if no error.
	JMP	ERROR_EXIT		; Jump file access error.
OVER7:	RET				; Return to caller.
;---------------------------------------;
; Processing complete message storage.	;
;---------------------------------------;
PROC_DONE_MSG:				;
DB	13,10				; Carriage Return, Line Feed.
DB	'Processing complete.'		;
DB	13,10				; Carriage Return, Line Feed.
DB	'$'				; DOS end of string marker.
;---------------------------------------;
; Display processing complete message.	;
;---------------------------------------;
DISPLAY_processing_done:		;
	LEA	DX,PROC_DONE_MSG	; Point to message.
	MOV	AH,9			; Display string function.
	INT	21H			; Call DOS functions.
	RET				; Return to caller.
;---------------------------------------;
; Error message memory storage.		;
;---------------------------------------;
ERROR_MSG:				;
DB'File access error.',13,10,13,10	;
DB'Possible causes:',13,10,13,10	;
DB'1) [filename] not given.',13,10	;
DB'2) [filename] does not exist.',13,10	;
DB'3) Z01-Z99 file(s) write protected.'	;
DB	13,10				;
DB	'$'				;
;---------------------------------------;
; Display error message, return to DOS  ;
;---------------------------------------;
ERROR_EXIT:				; 
	LEA	DX,ERROR_MSG		; Point to file access error message.
	MOV	AH,9			; Display string function.
	INT	21H			; Call DOS functions.
	MOV	AL,01			; Tell batch file error code 1.
	MOV	AH,4CH			; Terminate program DOS function.
	INT	21H			; Call DOS functions.
;---------------------------------------;
; [filename] and ZCUT files memory storage.
;---------------------------------------;
BUFFER:					; About 40,000 bytes starting here.
;---------------------------------------;
; Tell MACRO Assembler this is the end also that START is program entry point.
;---------------------------------------;
CODE	ENDS				; End of CODE SEGMENT
	END	START			; End for Macro. START = Entry point.
;---------------------------------------;
; End of ZCUT.ASM Macro assembler source code text.  10-29-87 Gene Garapic.
;---------------------------------------;
