page ,132
Title     MORE: reworked version of the DOS "more" utility

;  by Tom Hanlin III    February 18, 1987


Sseg                segment byte stack 'prog'    ; dummy stack segment
Sseg                ends


Cseg                segment byte public 'prog'
                    assume cs:Cseg, ds:Cseg, ss:Sseg

                    org    100h

MAIN                proc   far
                    mov    ah,30h
                    int    21h                   ; get DOS version
                    cmp    al,2                  ; is it DOS 2.0 or higher?
                    jae    GoodDOSversion        ;   yes, continue

                    mov    dx,offset ErrorMsg1
                    mov    ah,9
                    int    21h                   ; display error message
Done:               int    20h                   ; exit

GoodDOSversion:     mov    ah,0Fh
                    int    10h                   ; get video mode
                    mov    ScreenCols,ah         ; store columns/screen

                    mov    dx,offset CrLf
                    mov    ah,9
                    int    21h                   ; print a <CR><LF>

; The below twiddling sees that we get our text from the original standard
; input, but that we input from the keyboard at "-- More --" prompts.
                    xor    bx,bx                 ; stdin device handle
                    mov    ah,45h
                    int    21h                   ; duplicate handle
                    mov    di,ax                 ; save new one
                    mov    ah,3Eh
                    int    21h                   ; close old one
                    mov    bx,2                  ; stderr device handle
                    mov    ah,45h
                    int    21h                   ; duplicate handle

MoreLoop:           cld
                    mov    dx,offset CrLf +3     ; for buffer, use 4K...
                    mov    cx,4096               ; ...past the program end
                    mov    bx,di                 ; old stdin file handle
                    mov    ah,3Fh
                    int    21h                   ; read from file
                    jc     Done                  ;   exit on error
                    or     ax,ax                 ; end of input?
                    jz     Done                  ;   yes, exit
                    mov    cx,ax                 ; chars actually gotten
                    mov    si,dx                 ; buffer ptr

GetChr:             lodsb                        ; get a char from the buffer

                    mov    dh,Column             ; get column position

                    cmp    al,13                 ; check chr
                    ja     NormalChr             ;   not control, so normal
                    jne    NotCR                 ;   not <CR>, keep checking
                    mov    dh,1                  ; reset column count
                    jmp    short DisplayChr      ;   go display chr

NotCR:              cmp    al,10                 ; linefeed?
                    jne    NotLF                 ;   no, keep checking
                    inc    byte ptr Row          ; increment row count
                    jmp    short DisplayChr      ;   go display chr

NotLF:              cmp    al,8                  ; backspace?
                    jne    NotBS                 ;   no, keep checking
                    cmp    dh,1                  ; can we backspace?
                    je     NextChr               ;   no, ignore it
                    dec    dh                    ; yes, do it
                    jmp    short DisplayChr      ;   go display chr

NotBS:              cmp    al,9                  ; tab?
                    jne    NotHT                 ;   no, keep checking
                    add    dh,7                  ; move to next tab position
                    and    dh,0F8h               ; keep in bounds
                    inc    dh
                    jmp    short DisplayChr      ;   go display chr

NotHT:              cmp    al,7                  ; bell?
                    je     DisplayChr            ;   yes, go "display" it

NormalChr:          inc    dh                    ; increment column
                    cmp    dh,ScreenCols         ; is it still on the screen?
                    jbe    DisplayChr            ;   yes, display chr
                    inc    byte ptr Row          ; move to next line
                    mov    dh,1                  ; restart column count

DisplayChr:         mov    Column,dh             ; save new column position

                    mov    dl,al
                    mov    ah,2
                    int    21h                   ; display chr to stdout

                    mov    ah,Row                ; get current row
                    cmp    ah,ScreenRows         ; is it still on the screen?
                    jb     NextChr               ;   yes, move along...

                    mov    dx,offset PromptMsg
                    mov    ah,9
                    int    21h                   ; display prompt message

                    mov    ax,0C01h
                    int    21h                   ; clear kbd and wait for key

                    mov    dx,offset CrLf        ; display a <CR><LF>
                    mov    ah,9
                    int    21h

                    mov    byte ptr Column,1     ; reset column
                    mov    byte ptr Row,1        ; reset row

                    dec    si
                    inc    cx
NextChr:            loop   GetChrVec             ;   go through buffer
                    jmp    MoreLoop              ;   load another buffer
GetChrVec:          jmp    GetChr
MAIN                endp


ScreenRows   db 25                ; default to 25 lines per screen
ScreenCols   db ?                 ; fill this in depending on screen mode

Column       db 1                 ; start at first column
Row          db 1                 ; ...and first row

PromptMsg    db 13,"-- More --$"
ErrorMsg1    db "MORE: Wrong DOS version"
CrLf         db 13,10,"$"

Cseg                ends

                    end    MAIN
