	page	,132
	title	Batch file Beep

;------------------------------------------------------------------------
;
;  Beep      -	Bill Gibson - 1987
;		Lathrup Village, Mi 48076
;
;   Ver. 1.01 -  sound using ASCII character 7		    -	02/26/87
;	 1.02 -  using the 8253 timer chip directly	    -	02/26/87
; *	 1.03 -  now a siren (a mod of v1.02)		    -	02/28/87
;
;  For Public Domain Use.  Not for Sale or Hire.
;------------------------------------------------------------------------
COMMENT *
	   As requested by Viggo Jensen.

   Beep utility - sounds alarm until any key is pressed.

		  Obviously, best use of this small utility is at
		  the end of a batch file.  Could be used to replace
		  the DOS "pause" command.
*
;------------------------------------------------------------------------
code		SEGMENT BYTE PUBLIC 'code'
ASSUME		CS:code,DS:code,SS:code

		ORG	100h

Beep		PROC	FAR

		CALL	Sound		;sound the horn
exit:
		MOV	AH,4Ch
		INT	21h

;------------------------------------------------------------------------
; Work Area - constants,equates,messages
;------------------------------------------------------------------------
cr		EQU	0Dh		;carriage return
lf		EQU	0Ah		;line feed
esc		EQU	01Bh		;escape char

msg1		DB	cr,lf,'Beeping - press any key to quit...','$'

;--------------------------------------------------------------------------
; Sub-Routines: Declare each Proc PUBLIC for use with MapSym & SymDeb v4.0
;--------------------------------------------------------------------------
		PUBLIC	Sound
Sound		PROC	NEAR
		MOV	DX,OFFSET msg1	;intro greeting
		MOV	AH,9
		INT	21h
s1:
		MOV	BX,0700h	;set 1/pitch - highest possible tone
		MOV	AL,0B6h 	;"switch" to
		OUT	43h,AL		;initalize the speaker timer
s2:
		MOV	AX,BX		;OUT instruction can only handle the
		OUT	42h,AL		;least significant byte (LSB) from
		MOV	AL,AH		;the AX register  (AL)
		OUT	42h,AL
		IN	AL,61h		;grab speaker port
		OR	AL,3		;turn on speaker
		OUT	61h,AL
		DEC	BX		;increase the pitch
		CMP	BX,0350h
		JZ	s1
sinput:
		PUSH	AX
		PUSH	BX
		MOV	AH,0Bh		;check standard input device
		INT	21h
		OR	AL,AL		;any character waiting ?
		POP	BX
		POP	AX
		JZ	s2		;go do new tone
soff:
		IN	AL,61h		;grab speaker port
		XOR	AL,3		;turn off speaker
		OUT	61h,AL
		RET
Sound		ENDP

Beep		ENDP
code		ENDS
		END	Beep
